/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.AutoScalingGroupMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AutoScalingGroup implements StructuredPojo, ToCopyableBuilder<AutoScalingGroup.Builder, AutoScalingGroup> {
    private final String name;

    private final String hook;

    private AutoScalingGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.hook = builder.hook;
    }

    /**
     * <p>
     * The Auto Scaling group name.
     * </p>
     * 
     * @return The Auto Scaling group name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * An Auto Scaling lifecycle event hook name.
     * </p>
     * 
     * @return An Auto Scaling lifecycle event hook name.
     */
    public String hook() {
        return hook;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((hook() == null) ? 0 : hook().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroup)) {
            return false;
        }
        AutoScalingGroup other = (AutoScalingGroup) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.hook() == null ^ this.hook() == null) {
            return false;
        }
        if (other.hook() != null && !other.hook().equals(this.hook())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (hook() != null) {
            sb.append("Hook: ").append(hook()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AutoScalingGroup> {
        /**
         * <p>
         * The Auto Scaling group name.
         * </p>
         * 
         * @param name
         *        The Auto Scaling group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An Auto Scaling lifecycle event hook name.
         * </p>
         * 
         * @param hook
         *        An Auto Scaling lifecycle event hook name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hook(String hook);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String hook;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroup model) {
            setName(model.name);
            setHook(model.hook);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getHook() {
            return hook;
        }

        @Override
        public final Builder hook(String hook) {
            this.hook = hook;
            return this;
        }

        public final void setHook(String hook) {
            this.hook = hook;
        }

        @Override
        public AutoScalingGroup build() {
            return new AutoScalingGroup(this);
        }
    }
}
