/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.codedeploy.transform.AutoRollbackConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a configuration for automatically rolling back to a previous version of an application revision
 * when a deployment doesn't complete successfully.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AutoRollbackConfiguration implements StructuredPojo,
        ToCopyableBuilder<AutoRollbackConfiguration.Builder, AutoRollbackConfiguration> {
    private final Boolean enabled;

    private final List<String> events;

    private AutoRollbackConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.events = builder.events;
    }

    /**
     * <p>
     * Indicates whether a defined automatic rollback configuration is currently enabled.
     * </p>
     * 
     * @return Indicates whether a defined automatic rollback configuration is currently enabled.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The event type or types that trigger a rollback.
     * </p>
     * 
     * @return The event type or types that trigger a rollback.
     * @see AutoRollbackEvent
     */
    public List<String> events() {
        return events;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((enabled() == null) ? 0 : enabled().hashCode());
        hashCode = 31 * hashCode + ((events() == null) ? 0 : events().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoRollbackConfiguration)) {
            return false;
        }
        AutoRollbackConfiguration other = (AutoRollbackConfiguration) obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        if (events() != null) {
            sb.append("Events: ").append(events()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoRollbackConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AutoRollbackConfiguration> {
        /**
         * <p>
         * Indicates whether a defined automatic rollback configuration is currently enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether a defined automatic rollback configuration is currently enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The event type or types that trigger a rollback.
         * </p>
         * 
         * @param events
         *        The event type or types that trigger a rollback.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRollbackEvent
         */
        Builder events(Collection<String> events);

        /**
         * <p>
         * The event type or types that trigger a rollback.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEvents(java.util.Collection)} or {@link #withEvents(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param events
         *        The event type or types that trigger a rollback.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRollbackEvent
         */
        Builder events(String... events);

        /**
         * <p>
         * The event type or types that trigger a rollback.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEvents(java.util.Collection)} or {@link #withEvents(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param events
         *        The event type or types that trigger a rollback.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRollbackEvent
         */
        Builder events(AutoRollbackEvent... events);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private List<String> events = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoRollbackConfiguration model) {
            setEnabled(model.enabled);
            setEvents(model.events);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<String> getEvents() {
            return events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = AutoRollbackEventsListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String... events) {
            if (this.events == null) {
                this.events = new SdkInternalList<>(events.length);
            }
            for (String e : events) {
                this.events.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(AutoRollbackEvent... events) {
            if (this.events == null) {
                this.events = new SdkInternalList<String>(events.length);
            }
            for (AutoRollbackEvent ele : events) {
                this.events.add(ele.toString());
            }
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = AutoRollbackEventsListCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(String... events) {
            if (this.events == null) {
                this.events = new SdkInternalList<>(events.length);
            }
            for (String e : events) {
                this.events.add(e);
            }
        }

        @SafeVarargs
        public final void setEvents(AutoRollbackEvent... events) {
            if (this.events == null) {
                this.events = new SdkInternalList<String>(events.length);
            }
            for (AutoRollbackEvent ele : events) {
                this.events.add(ele.toString());
            }
        }

        @Override
        public AutoRollbackConfiguration build() {
            return new AutoRollbackConfiguration(this);
        }
    }
}
