/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codedeploy.transform.ApplicationInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ApplicationInfo implements StructuredPojo, ToCopyableBuilder<ApplicationInfo.Builder, ApplicationInfo> {
    private final String applicationId;

    private final String applicationName;

    private final Date createTime;

    private final Boolean linkedToGitHub;

    private final String gitHubAccountName;

    private ApplicationInfo(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.applicationName = builder.applicationName;
        this.createTime = builder.createTime;
        this.linkedToGitHub = builder.linkedToGitHub;
        this.gitHubAccountName = builder.gitHubAccountName;
    }

    /**
     * <p>
     * The application ID.
     * </p>
     * 
     * @return The application ID.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The application name.
     * </p>
     * 
     * @return The application name.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The time at which the application was created.
     * </p>
     * 
     * @return The time at which the application was created.
     */
    public Date createTime() {
        return createTime;
    }

    /**
     * <p>
     * True if the user has authenticated with GitHub for the specified application; otherwise, false.
     * </p>
     * 
     * @return True if the user has authenticated with GitHub for the specified application; otherwise, false.
     */
    public Boolean linkedToGitHub() {
        return linkedToGitHub;
    }

    /**
     * <p>
     * The name for a connection to a GitHub account.
     * </p>
     * 
     * @return The name for a connection to a GitHub account.
     */
    public String gitHubAccountName() {
        return gitHubAccountName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationId() == null) ? 0 : applicationId().hashCode());
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((createTime() == null) ? 0 : createTime().hashCode());
        hashCode = 31 * hashCode + ((linkedToGitHub() == null) ? 0 : linkedToGitHub().hashCode());
        hashCode = 31 * hashCode + ((gitHubAccountName() == null) ? 0 : gitHubAccountName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationInfo)) {
            return false;
        }
        ApplicationInfo other = (ApplicationInfo) obj;
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.createTime() == null ^ this.createTime() == null) {
            return false;
        }
        if (other.createTime() != null && !other.createTime().equals(this.createTime())) {
            return false;
        }
        if (other.linkedToGitHub() == null ^ this.linkedToGitHub() == null) {
            return false;
        }
        if (other.linkedToGitHub() != null && !other.linkedToGitHub().equals(this.linkedToGitHub())) {
            return false;
        }
        if (other.gitHubAccountName() == null ^ this.gitHubAccountName() == null) {
            return false;
        }
        if (other.gitHubAccountName() != null && !other.gitHubAccountName().equals(this.gitHubAccountName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationId() != null) {
            sb.append("ApplicationId: ").append(applicationId()).append(",");
        }
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (createTime() != null) {
            sb.append("CreateTime: ").append(createTime()).append(",");
        }
        if (linkedToGitHub() != null) {
            sb.append("LinkedToGitHub: ").append(linkedToGitHub()).append(",");
        }
        if (gitHubAccountName() != null) {
            sb.append("GitHubAccountName: ").append(gitHubAccountName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ApplicationInfo> {
        /**
         * <p>
         * The application ID.
         * </p>
         * 
         * @param applicationId
         *        The application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The application name.
         * </p>
         * 
         * @param applicationName
         *        The application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The time at which the application was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Date createTime);

        /**
         * <p>
         * True if the user has authenticated with GitHub for the specified application; otherwise, false.
         * </p>
         * 
         * @param linkedToGitHub
         *        True if the user has authenticated with GitHub for the specified application; otherwise, false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedToGitHub(Boolean linkedToGitHub);

        /**
         * <p>
         * The name for a connection to a GitHub account.
         * </p>
         * 
         * @param gitHubAccountName
         *        The name for a connection to a GitHub account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubAccountName(String gitHubAccountName);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationId;

        private String applicationName;

        private Date createTime;

        private Boolean linkedToGitHub;

        private String gitHubAccountName;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationInfo model) {
            setApplicationId(model.applicationId);
            setApplicationName(model.applicationName);
            setCreateTime(model.createTime);
            setLinkedToGitHub(model.linkedToGitHub);
            setGitHubAccountName(model.gitHubAccountName);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Date getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Date createTime) {
            this.createTime = StandardMemberCopier.copy(createTime);
            return this;
        }

        public final void setCreateTime(Date createTime) {
            this.createTime = StandardMemberCopier.copy(createTime);
        }

        public final Boolean getLinkedToGitHub() {
            return linkedToGitHub;
        }

        @Override
        public final Builder linkedToGitHub(Boolean linkedToGitHub) {
            this.linkedToGitHub = linkedToGitHub;
            return this;
        }

        public final void setLinkedToGitHub(Boolean linkedToGitHub) {
            this.linkedToGitHub = linkedToGitHub;
        }

        public final String getGitHubAccountName() {
            return gitHubAccountName;
        }

        @Override
        public final Builder gitHubAccountName(String gitHubAccountName) {
            this.gitHubAccountName = gitHubAccountName;
            return this;
        }

        public final void setGitHubAccountName(String gitHubAccountName) {
            this.gitHubAccountName = gitHubAccountName;
        }

        @Override
        public ApplicationInfo build() {
            return new ApplicationInfo(this);
        }
    }
}
