/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.codedeploy.transform.AlarmConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about alarms associated with the deployment group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AlarmConfiguration implements StructuredPojo, ToCopyableBuilder<AlarmConfiguration.Builder, AlarmConfiguration> {
    private final Boolean enabled;

    private final Boolean ignorePollAlarmFailure;

    private final List<Alarm> alarms;

    private AlarmConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.ignorePollAlarmFailure = builder.ignorePollAlarmFailure;
        this.alarms = builder.alarms;
    }

    /**
     * <p>
     * Indicates whether the alarm configuration is enabled.
     * </p>
     * 
     * @return Indicates whether the alarm configuration is enabled.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Indicates whether a deployment should continue if information about the current state of alarms cannot be
     * retrieved from Amazon CloudWatch. The default value is false.
     * </p>
     * <ul>
     * <li>
     * <p>
     * true: The deployment will proceed even if alarm status information can't be retrieved from Amazon CloudWatch.
     * </p>
     * </li>
     * <li>
     * <p>
     * false: The deployment will stop if alarm status information can't be retrieved from Amazon CloudWatch.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether a deployment should continue if information about the current state of alarms cannot be
     *         retrieved from Amazon CloudWatch. The default value is false.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         true: The deployment will proceed even if alarm status information can't be retrieved from Amazon
     *         CloudWatch.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         false: The deployment will stop if alarm status information can't be retrieved from Amazon CloudWatch.
     *         </p>
     *         </li>
     */
    public Boolean ignorePollAlarmFailure() {
        return ignorePollAlarmFailure;
    }

    /**
     * <p>
     * A list of alarms configured for the deployment group. A maximum of 10 alarms can be added to a deployment group.
     * </p>
     * 
     * @return A list of alarms configured for the deployment group. A maximum of 10 alarms can be added to a deployment
     *         group.
     */
    public List<Alarm> alarms() {
        return alarms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((enabled() == null) ? 0 : enabled().hashCode());
        hashCode = 31 * hashCode + ((ignorePollAlarmFailure() == null) ? 0 : ignorePollAlarmFailure().hashCode());
        hashCode = 31 * hashCode + ((alarms() == null) ? 0 : alarms().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmConfiguration)) {
            return false;
        }
        AlarmConfiguration other = (AlarmConfiguration) obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.ignorePollAlarmFailure() == null ^ this.ignorePollAlarmFailure() == null) {
            return false;
        }
        if (other.ignorePollAlarmFailure() != null && !other.ignorePollAlarmFailure().equals(this.ignorePollAlarmFailure())) {
            return false;
        }
        if (other.alarms() == null ^ this.alarms() == null) {
            return false;
        }
        if (other.alarms() != null && !other.alarms().equals(this.alarms())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        if (ignorePollAlarmFailure() != null) {
            sb.append("IgnorePollAlarmFailure: ").append(ignorePollAlarmFailure()).append(",");
        }
        if (alarms() != null) {
            sb.append("Alarms: ").append(alarms()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AlarmConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AlarmConfiguration> {
        /**
         * <p>
         * Indicates whether the alarm configuration is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the alarm configuration is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Indicates whether a deployment should continue if information about the current state of alarms cannot be
         * retrieved from Amazon CloudWatch. The default value is false.
         * </p>
         * <ul>
         * <li>
         * <p>
         * true: The deployment will proceed even if alarm status information can't be retrieved from Amazon CloudWatch.
         * </p>
         * </li>
         * <li>
         * <p>
         * false: The deployment will stop if alarm status information can't be retrieved from Amazon CloudWatch.
         * </p>
         * </li>
         * </ul>
         * 
         * @param ignorePollAlarmFailure
         *        Indicates whether a deployment should continue if information about the current state of alarms cannot
         *        be retrieved from Amazon CloudWatch. The default value is false.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        true: The deployment will proceed even if alarm status information can't be retrieved from Amazon
         *        CloudWatch.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        false: The deployment will stop if alarm status information can't be retrieved from Amazon CloudWatch.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignorePollAlarmFailure(Boolean ignorePollAlarmFailure);

        /**
         * <p>
         * A list of alarms configured for the deployment group. A maximum of 10 alarms can be added to a deployment
         * group.
         * </p>
         * 
         * @param alarms
         *        A list of alarms configured for the deployment group. A maximum of 10 alarms can be added to a
         *        deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Collection<Alarm> alarms);

        /**
         * <p>
         * A list of alarms configured for the deployment group. A maximum of 10 alarms can be added to a deployment
         * group.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setAlarms(java.util.Collection)} or {@link #withAlarms(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param alarms
         *        A list of alarms configured for the deployment group. A maximum of 10 alarms can be added to a
         *        deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Alarm... alarms);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Boolean ignorePollAlarmFailure;

        private List<Alarm> alarms = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmConfiguration model) {
            setEnabled(model.enabled);
            setIgnorePollAlarmFailure(model.ignorePollAlarmFailure);
            setAlarms(model.alarms);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getIgnorePollAlarmFailure() {
            return ignorePollAlarmFailure;
        }

        @Override
        public final Builder ignorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
            this.ignorePollAlarmFailure = ignorePollAlarmFailure;
            return this;
        }

        public final void setIgnorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
            this.ignorePollAlarmFailure = ignorePollAlarmFailure;
        }

        public final Collection<Alarm> getAlarms() {
            return alarms;
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmListCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm... alarms) {
            if (this.alarms == null) {
                this.alarms = new SdkInternalList<>(alarms.length);
            }
            for (Alarm e : alarms) {
                this.alarms.add(e);
            }
            return this;
        }

        public final void setAlarms(Collection<Alarm> alarms) {
            this.alarms = AlarmListCopier.copy(alarms);
        }

        @SafeVarargs
        public final void setAlarms(Alarm... alarms) {
            if (this.alarms == null) {
                this.alarms = new SdkInternalList<>(alarms.length);
            }
            for (Alarm e : alarms) {
                this.alarms.add(e);
            }
        }

        @Override
        public AlarmConfiguration build() {
            return new AlarmConfiguration(this);
        }
    }
}
