/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of, and adds tags to, an on-premises instance operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AddTagsToOnPremisesInstancesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AddTagsToOnPremisesInstancesRequest.Builder, AddTagsToOnPremisesInstancesRequest> {
    private final List<Tag> tags;

    private final List<String> instanceNames;

    private AddTagsToOnPremisesInstancesRequest(BuilderImpl builder) {
        this.tags = builder.tags;
        this.instanceNames = builder.instanceNames;
    }

    /**
     * <p>
     * The tag key-value pairs to add to the on-premises instances.
     * </p>
     * <p>
     * Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not allowed.
     * </p>
     * 
     * @return The tag key-value pairs to add to the on-premises instances.</p>
     *         <p>
     *         Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not allowed.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The names of the on-premises instances to which to add tags.
     * </p>
     * 
     * @return The names of the on-premises instances to which to add tags.
     */
    public List<String> instanceNames() {
        return instanceNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((instanceNames() == null) ? 0 : instanceNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsToOnPremisesInstancesRequest)) {
            return false;
        }
        AddTagsToOnPremisesInstancesRequest other = (AddTagsToOnPremisesInstancesRequest) obj;
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.instanceNames() == null ^ this.instanceNames() == null) {
            return false;
        }
        if (other.instanceNames() != null && !other.instanceNames().equals(this.instanceNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (instanceNames() != null) {
            sb.append("InstanceNames: ").append(instanceNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AddTagsToOnPremisesInstancesRequest> {
        /**
         * <p>
         * The tag key-value pairs to add to the on-premises instances.
         * </p>
         * <p>
         * Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not allowed.
         * </p>
         * 
         * @param tags
         *        The tag key-value pairs to add to the on-premises instances.</p>
         *        <p>
         *        Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not
         *        allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag key-value pairs to add to the on-premises instances.
         * </p>
         * <p>
         * Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not allowed.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
         * existing values.
         * </p>
         * 
         * @param tags
         *        The tag key-value pairs to add to the on-premises instances.</p>
         *        <p>
         *        Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not
         *        allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The names of the on-premises instances to which to add tags.
         * </p>
         * 
         * @param instanceNames
         *        The names of the on-premises instances to which to add tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(Collection<String> instanceNames);

        /**
         * <p>
         * The names of the on-premises instances to which to add tags.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstanceNames(java.util.Collection)} or {@link #withInstanceNames(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param instanceNames
         *        The names of the on-premises instances to which to add tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(String... instanceNames);
    }

    private static final class BuilderImpl implements Builder {
        private List<Tag> tags = new SdkInternalList<>();

        private List<String> instanceNames = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(AddTagsToOnPremisesInstancesRequest model) {
            setTags(model.tags);
            setInstanceNames(model.instanceNames);
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList<>(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList<>(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public final Collection<String> getInstanceNames() {
            return instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String... instanceNames) {
            if (this.instanceNames == null) {
                this.instanceNames = new SdkInternalList<>(instanceNames.length);
            }
            for (String e : instanceNames) {
                this.instanceNames.add(e);
            }
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
        }

        @SafeVarargs
        public final void setInstanceNames(String... instanceNames) {
            if (this.instanceNames == null) {
                this.instanceNames = new SdkInternalList<>(instanceNames.length);
            }
            for (String e : instanceNames) {
                this.instanceNames.add(e);
            }
        }

        @Override
        public AddTagsToOnPremisesInstancesRequest build() {
            return new AddTagsToOnPremisesInstancesRequest(this);
        }
    }
}
