/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.AlarmsLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.BucketNameFilterRequiredException;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployException;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.DeploymentAlreadyCompletedException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigInUseException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentIdRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentIsNotInReadyStateException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentNotStartedException;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.DescriptionTooLongException;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.IamArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.IamSessionArnAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.IamUserArnAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.IamUserArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.InstanceIdRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNotRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAlarmConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidApplicationNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAutoRollbackConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAutoScalingGroupException;
import software.amazon.awssdk.services.codedeploy.model.InvalidBlueGreenDeploymentConfigurationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidBucketNameFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeployedStateFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentConfigNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentGroupNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentInstanceTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentStyleException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEC2TagException;
import software.amazon.awssdk.services.codedeploy.model.InvalidFileExistsBehaviorException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIamSessionArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIamUserArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidKeyPrefixFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLoadBalancerInfoException;
import software.amazon.awssdk.services.codedeploy.model.InvalidMinimumHealthyHostValueException;
import software.amazon.awssdk.services.codedeploy.model.InvalidNextTokenException;
import software.amazon.awssdk.services.codedeploy.model.InvalidOperationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRegistrationStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRevisionException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRoleException;
import software.amazon.awssdk.services.codedeploy.model.InvalidSortByException;
import software.amazon.awssdk.services.codedeploy.model.InvalidSortOrderException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTargetInstancesException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTriggerConfigException;
import software.amazon.awssdk.services.codedeploy.model.LifecycleHookLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.MultipleIamArnsProvidedException;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ResourceValidationException;
import software.amazon.awssdk.services.codedeploy.model.RevisionDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.RevisionRequiredException;
import software.amazon.awssdk.services.codedeploy.model.RoleRequiredException;
import software.amazon.awssdk.services.codedeploy.model.SkipWaitTimeForInstanceTerminationRequest;
import software.amazon.awssdk.services.codedeploy.model.SkipWaitTimeForInstanceTerminationResponse;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.TagLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.TagRequiredException;
import software.amazon.awssdk.services.codedeploy.model.TriggerTargetsLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.UnsupportedActionForDeploymentTypeException;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.transform.AddTagsToOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.AddTagsToOnPremisesInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetApplicationRevisionsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetApplicationRevisionsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetApplicationsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetApplicationsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentGroupsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetOnPremisesInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ContinueDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ContinueDeploymentResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateApplicationResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentConfigResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentGroupResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteApplicationResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteDeploymentConfigResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteDeploymentGroupResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeregisterOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeregisterOnPremisesInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetApplicationResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetApplicationRevisionRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetApplicationRevisionResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentConfigResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentGroupResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetOnPremisesInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListApplicationRevisionsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListApplicationRevisionsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListApplicationsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentConfigsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentConfigsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentGroupsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListGitHubAccountTokenNamesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListGitHubAccountTokenNamesResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListOnPremisesInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RegisterApplicationRevisionRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RegisterApplicationRevisionResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RegisterOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RegisterOnPremisesInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RemoveTagsFromOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RemoveTagsFromOnPremisesInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.SkipWaitTimeForInstanceTerminationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.SkipWaitTimeForInstanceTerminationResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.StopDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.StopDeploymentResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UpdateApplicationResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UpdateDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UpdateDeploymentGroupResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.waiters.CodeDeployClientWaiters;

/**
 * Internal implementation of {@link CodeDeployClient}.
 *
 * @see CodeDeployClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCodeDeployClient implements CodeDeployClient {
    private final ClientHandler clientHandler;

    private final SdkJsonProtocolFactory protocolFactory;

    private final AwsSyncClientParams clientParams;

    private volatile CodeDeployClientWaiters waiters;

    protected DefaultCodeDeployClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams)
                .withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Adds tags to on-premises instances.
     * </p>
     * 
     * @param addTagsToOnPremisesInstancesRequest
     *        Represents the input of, and adds tags to, an on-premises instance operation.
     * @return Result of the AddTagsToOnPremisesInstances operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws TagRequiredException
     *         A tag was not specified.
     * @throws InvalidTagException
     *         The specified tag was specified in an invalid format.
     * @throws TagLimitExceededException
     *         The maximum allowed number of tags was exceeded.
     * @throws InstanceLimitExceededException
     *         The maximum number of allowed on-premises instances in a single call was exceeded.
     * @throws InstanceNotRegisteredException
     *         The specified on-premises instance is not registered.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.AddTagsToOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/AddTagsToOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddTagsToOnPremisesInstancesResponse addTagsToOnPremisesInstances(
            AddTagsToOnPremisesInstancesRequest addTagsToOnPremisesInstancesRequest) throws InstanceNameRequiredException,
            TagRequiredException, InvalidTagException, TagLimitExceededException, InstanceLimitExceededException,
            InstanceNotRegisteredException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<AddTagsToOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new AddTagsToOnPremisesInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<AddTagsToOnPremisesInstancesRequest, AddTagsToOnPremisesInstancesResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(addTagsToOnPremisesInstancesRequest)
                        .withMarshaller(new AddTagsToOnPremisesInstancesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about one or more application revisions.
     * </p>
     * 
     * @param batchGetApplicationRevisionsRequest
     *        Represents the input of a BatchGetApplicationRevisions operation.
     * @return Result of the BatchGetApplicationRevisions operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.BatchGetApplicationRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetApplicationRevisionsResponse batchGetApplicationRevisions(
            BatchGetApplicationRevisionsRequest batchGetApplicationRevisionsRequest) throws ApplicationDoesNotExistException,
            ApplicationNameRequiredException, InvalidApplicationNameException, RevisionRequiredException,
            InvalidRevisionException, BatchLimitExceededException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<BatchGetApplicationRevisionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new BatchGetApplicationRevisionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<BatchGetApplicationRevisionsRequest, BatchGetApplicationRevisionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(batchGetApplicationRevisionsRequest)
                        .withMarshaller(new BatchGetApplicationRevisionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about one or more applications.
     * </p>
     * 
     * @param batchGetApplicationsRequest
     *        Represents the input of a BatchGetApplications operation.
     * @return Result of the BatchGetApplications operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.BatchGetApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetApplicationsResponse batchGetApplications(BatchGetApplicationsRequest batchGetApplicationsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            BatchLimitExceededException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<BatchGetApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new BatchGetApplicationsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<BatchGetApplicationsRequest, BatchGetApplicationsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(batchGetApplicationsRequest)
                .withMarshaller(new BatchGetApplicationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about one or more deployment groups.
     * </p>
     * 
     * @param batchGetDeploymentGroupsRequest
     *        Represents the input of a BatchGetDeploymentGroups operation.
     * @return Result of the BatchGetDeploymentGroups operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.BatchGetDeploymentGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetDeploymentGroupsResponse batchGetDeploymentGroups(
            BatchGetDeploymentGroupsRequest batchGetDeploymentGroupsRequest) throws ApplicationNameRequiredException,
            InvalidApplicationNameException, ApplicationDoesNotExistException, DeploymentGroupNameRequiredException,
            InvalidDeploymentGroupNameException, BatchLimitExceededException, SdkBaseException, SdkClientException,
            CodeDeployException {

        HttpResponseHandler<BatchGetDeploymentGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new BatchGetDeploymentGroupsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<BatchGetDeploymentGroupsRequest, BatchGetDeploymentGroupsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(batchGetDeploymentGroupsRequest)
                        .withMarshaller(new BatchGetDeploymentGroupsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about one or more instance that are part of a deployment group.
     * </p>
     * 
     * @param batchGetDeploymentInstancesRequest
     *        Represents the input of a BatchGetDeploymentInstances operation.
     * @return Result of the BatchGetDeploymentInstances operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment does not exist with the applicable IAM user or AWS account.
     * @throws InstanceIdRequiredException
     *         The instance ID was not specified.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws InvalidInstanceNameException
     *         The specified on-premises instance name was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.BatchGetDeploymentInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetDeploymentInstancesResponse batchGetDeploymentInstances(
            BatchGetDeploymentInstancesRequest batchGetDeploymentInstancesRequest) throws DeploymentIdRequiredException,
            DeploymentDoesNotExistException, InstanceIdRequiredException, InvalidDeploymentIdException,
            InvalidInstanceNameException, BatchLimitExceededException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<BatchGetDeploymentInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new BatchGetDeploymentInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<BatchGetDeploymentInstancesRequest, BatchGetDeploymentInstancesResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(batchGetDeploymentInstancesRequest)
                        .withMarshaller(new BatchGetDeploymentInstancesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about one or more deployments.
     * </p>
     * 
     * @param batchGetDeploymentsRequest
     *        Represents the input of a BatchGetDeployments operation.
     * @return Result of the BatchGetDeployments operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.BatchGetDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BatchGetDeploymentsResponse batchGetDeployments(BatchGetDeploymentsRequest batchGetDeploymentsRequest)
            throws DeploymentIdRequiredException, InvalidDeploymentIdException, BatchLimitExceededException, SdkBaseException,
            SdkClientException, CodeDeployException {

        HttpResponseHandler<BatchGetDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new BatchGetDeploymentsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<BatchGetDeploymentsRequest, BatchGetDeploymentsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(batchGetDeploymentsRequest).withMarshaller(new BatchGetDeploymentsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about one or more on-premises instances.
     * </p>
     * 
     * @param batchGetOnPremisesInstancesRequest
     *        Represents the input of a BatchGetOnPremisesInstances operation.
     * @return Result of the BatchGetOnPremisesInstances operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The specified on-premises instance name was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.BatchGetOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetOnPremisesInstancesResponse batchGetOnPremisesInstances(
            BatchGetOnPremisesInstancesRequest batchGetOnPremisesInstancesRequest) throws InstanceNameRequiredException,
            InvalidInstanceNameException, BatchLimitExceededException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<BatchGetOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new BatchGetOnPremisesInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<BatchGetOnPremisesInstancesRequest, BatchGetOnPremisesInstancesResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(batchGetOnPremisesInstancesRequest)
                        .withMarshaller(new BatchGetOnPremisesInstancesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment
     * to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic
     * rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can
     * start as soon as all instances have a status of Ready.)
     * </p>
     * 
     * @param continueDeploymentRequest
     * @return Result of the ContinueDeployment operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentAlreadyCompletedException
     *         The deployment is already complete.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentIsNotInReadyStateException
     *         The deployment does not have a status of Ready and can't continue yet.
     * @throws UnsupportedActionForDeploymentTypeException
     *         A call was submitted that is not supported for the specified deployment type.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ContinueDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ContinueDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ContinueDeploymentResponse continueDeployment(ContinueDeploymentRequest continueDeploymentRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentAlreadyCompletedException,
            InvalidDeploymentIdException, DeploymentIsNotInReadyStateException, UnsupportedActionForDeploymentTypeException,
            SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<ContinueDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ContinueDeploymentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ContinueDeploymentRequest, ContinueDeploymentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(continueDeploymentRequest).withMarshaller(new ContinueDeploymentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     * 
     * @param createApplicationRequest
     *        Represents the input of a CreateApplication operation.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationAlreadyExistsException
     *         An application with the specified name already exists with the applicable IAM user or AWS account.
     * @throws ApplicationLimitExceededException
     *         More applications were attempted to be created than are allowed.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.CreateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationAlreadyExistsException,
            ApplicationLimitExceededException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<CreateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateApplicationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateApplicationRequest, CreateApplicationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createApplicationRequest).withMarshaller(new CreateApplicationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deploys an application revision through the specified deployment group.
     * </p>
     * 
     * @param createDeploymentRequest
     *        Represents the input of a CreateDeployment operation.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group does not exist with the applicable IAM user or AWS account.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws RevisionDoesNotExistException
     *         The named revision does not exist with the applicable IAM user or AWS account.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the applicable IAM user or AWS account.
     * @throws DescriptionTooLongException
     *         The description is too long.
     * @throws DeploymentLimitExceededException
     *         The number of allowed deployments was exceeded.
     * @throws InvalidTargetInstancesException
     *         The target instance configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Configuration data for target instances was entered for an in-place deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The limit of 10 tags for a tag type was exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The combined length of the tag names exceeded the limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A specified tag is not currently applied to any instances.
     *         </p>
     *         </li>
     * @throws InvalidAutoRollbackConfigException
     *         The automatic rollback configuration was specified in an invalid format. For example, automatic rollback
     *         is enabled but an invalid triggering event type or no event types were listed.
     * @throws InvalidLoadBalancerInfoException
     *         An invalid load balancer name, or no load balancer name, was specified.
     * @throws InvalidFileExistsBehaviorException
     *         An invalid fileExistsBehavior option was specified to determine how AWS CodeDeploy handles files or
     *         directories that already exist in a deployment target location but weren't part of the previous
     *         successful deployment. Valid values include "DISALLOW", "OVERWRITE", and "RETAIN".
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.CreateDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException,
            RevisionRequiredException, RevisionDoesNotExistException, InvalidRevisionException,
            InvalidDeploymentConfigNameException, DeploymentConfigDoesNotExistException, DescriptionTooLongException,
            DeploymentLimitExceededException, InvalidTargetInstancesException, InvalidAutoRollbackConfigException,
            InvalidLoadBalancerInfoException, InvalidFileExistsBehaviorException, SdkBaseException, SdkClientException,
            CodeDeployException {

        HttpResponseHandler<CreateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateDeploymentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateDeploymentRequest, CreateDeploymentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createDeploymentRequest).withMarshaller(new CreateDeploymentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a deployment configuration.
     * </p>
     * 
     * @param createDeploymentConfigRequest
     *        Represents the input of a CreateDeploymentConfig operation.
     * @return Result of the CreateDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigAlreadyExistsException
     *         A deployment configuration with the specified name already exists with the applicable IAM user or AWS
     *         account.
     * @throws InvalidMinimumHealthyHostValueException
     *         The minimum healthy instance value was specified in an invalid format.
     * @throws DeploymentConfigLimitExceededException
     *         The deployment configurations limit was exceeded.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.CreateDeploymentConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDeploymentConfigResponse createDeploymentConfig(CreateDeploymentConfigRequest createDeploymentConfigRequest)
            throws InvalidDeploymentConfigNameException, DeploymentConfigNameRequiredException,
            DeploymentConfigAlreadyExistsException, InvalidMinimumHealthyHostValueException,
            DeploymentConfigLimitExceededException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<CreateDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateDeploymentConfigResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateDeploymentConfigRequest, CreateDeploymentConfigResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createDeploymentConfigRequest)
                .withMarshaller(new CreateDeploymentConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a deployment group to which application revisions will be deployed.
     * </p>
     * 
     * @param createDeploymentGroupRequest
     *        Represents the input of a CreateDeploymentGroup operation.
     * @return Result of the CreateDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupAlreadyExistsException
     *         A deployment group with the specified name already exists with the applicable IAM user or AWS account.
     * @throws InvalidEC2TagException
     *         The tag was specified in an invalid format.
     * @throws InvalidTagException
     *         The specified tag was specified in an invalid format.
     * @throws InvalidAutoScalingGroupException
     *         The Auto Scaling group was specified in an invalid format or does not exist.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the applicable IAM user or AWS account.
     * @throws RoleRequiredException
     *         The role ID was not specified.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Auto Scaling.
     * @throws DeploymentGroupLimitExceededException
     *         The deployment groups limit was exceeded.
     * @throws LifecycleHookLimitExceededException
     *         The limit for lifecycle hooks was exceeded.
     * @throws InvalidTriggerConfigException
     *         The trigger was specified in an invalid format.
     * @throws TriggerTargetsLimitExceededException
     *         The maximum allowed number of triggers was exceeded.
     * @throws InvalidAlarmConfigException
     *         The format of the alarm configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the 255 character limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled but the alarm list is empty.
     *         </p>
     *         </li>
     * @throws AlarmsLimitExceededException
     *         The maximum number of alarms for a deployment group (10) was exceeded.
     * @throws InvalidAutoRollbackConfigException
     *         The automatic rollback configuration was specified in an invalid format. For example, automatic rollback
     *         is enabled but an invalid triggering event type or no event types were listed.
     * @throws InvalidLoadBalancerInfoException
     *         An invalid load balancer name, or no load balancer name, was specified.
     * @throws InvalidDeploymentStyleException
     *         An invalid deployment style was specified. Valid deployment types include "IN_PLACE" and "BLUE_GREEN".
     *         Valid deployment options include "WITH_TRAFFIC_CONTROL" and "WITHOUT_TRAFFIC_CONTROL".
     * @throws InvalidBlueGreenDeploymentConfigurationException
     *         The configuration for the blue/green deployment group was provided in an invalid format. For information
     *         about deployment configuration format, see <a>CreateDeploymentConfig</a>.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.CreateDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDeploymentGroupResponse createDeploymentGroup(CreateDeploymentGroupRequest createDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, DeploymentGroupAlreadyExistsException,
            InvalidEC2TagException, InvalidTagException, InvalidAutoScalingGroupException, InvalidDeploymentConfigNameException,
            DeploymentConfigDoesNotExistException, RoleRequiredException, InvalidRoleException,
            DeploymentGroupLimitExceededException, LifecycleHookLimitExceededException, InvalidTriggerConfigException,
            TriggerTargetsLimitExceededException, InvalidAlarmConfigException, AlarmsLimitExceededException,
            InvalidAutoRollbackConfigException, InvalidLoadBalancerInfoException, InvalidDeploymentStyleException,
            InvalidBlueGreenDeploymentConfigurationException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<CreateDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateDeploymentGroupResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateDeploymentGroupRequest, CreateDeploymentGroupResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createDeploymentGroupRequest)
                .withMarshaller(new CreateDeploymentGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     * 
     * @param deleteApplicationRequest
     *        Represents the input of a DeleteApplication operation.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.DeleteApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, SdkBaseException, SdkClientException,
            CodeDeployException {

        HttpResponseHandler<DeleteApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteApplicationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteApplicationRequest, DeleteApplicationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteApplicationRequest).withMarshaller(new DeleteApplicationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a deployment configuration.
     * </p>
     * <note>
     * <p>
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be
     * deleted.
     * </p>
     * </note>
     * 
     * @param deleteDeploymentConfigRequest
     *        Represents the input of a DeleteDeploymentConfig operation.
     * @return Result of the DeleteDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigInUseException
     *         The deployment configuration is still in use.
     * @throws InvalidOperationException
     *         An invalid operation was detected.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.DeleteDeploymentConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDeploymentConfigResponse deleteDeploymentConfig(DeleteDeploymentConfigRequest deleteDeploymentConfigRequest)
            throws InvalidDeploymentConfigNameException, DeploymentConfigNameRequiredException, DeploymentConfigInUseException,
            InvalidOperationException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<DeleteDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteDeploymentConfigResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteDeploymentConfigRequest, DeleteDeploymentConfigResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteDeploymentConfigRequest)
                .withMarshaller(new DeleteDeploymentConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a deployment group.
     * </p>
     * 
     * @param deleteDeploymentGroupRequest
     *        Represents the input of a DeleteDeploymentGroup operation.
     * @return Result of the DeleteDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Auto Scaling.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.DeleteDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDeploymentGroupResponse deleteDeploymentGroup(DeleteDeploymentGroupRequest deleteDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, DeploymentGroupNameRequiredException,
            InvalidDeploymentGroupNameException, InvalidRoleException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<DeleteDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteDeploymentGroupResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteDeploymentGroupRequest, DeleteDeploymentGroupResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteDeploymentGroupRequest)
                .withMarshaller(new DeleteDeploymentGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deregisters an on-premises instance.
     * </p>
     * 
     * @param deregisterOnPremisesInstanceRequest
     *        Represents the input of a DeregisterOnPremisesInstance operation.
     * @return Result of the DeregisterOnPremisesInstance operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The specified on-premises instance name was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.DeregisterOnPremisesInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeregisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterOnPremisesInstanceResponse deregisterOnPremisesInstance(
            DeregisterOnPremisesInstanceRequest deregisterOnPremisesInstanceRequest) throws InstanceNameRequiredException,
            InvalidInstanceNameException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<DeregisterOnPremisesInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeregisterOnPremisesInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DeregisterOnPremisesInstanceRequest, DeregisterOnPremisesInstanceResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deregisterOnPremisesInstanceRequest)
                        .withMarshaller(new DeregisterOnPremisesInstanceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about an application.
     * </p>
     * 
     * @param getApplicationRequest
     *        Represents the input of a GetApplication operation.
     * @return Result of the GetApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.GetApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetApplicationResponse getApplication(GetApplicationRequest getApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<GetApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetApplicationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetApplicationRequest, GetApplicationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getApplicationRequest).withMarshaller(new GetApplicationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about an application revision.
     * </p>
     * 
     * @param getApplicationRevisionRequest
     *        Represents the input of a GetApplicationRevision operation.
     * @return Result of the GetApplicationRevision operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws RevisionDoesNotExistException
     *         The named revision does not exist with the applicable IAM user or AWS account.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.GetApplicationRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetApplicationRevisionResponse getApplicationRevision(GetApplicationRevisionRequest getApplicationRevisionRequest)
            throws ApplicationDoesNotExistException, ApplicationNameRequiredException, InvalidApplicationNameException,
            RevisionDoesNotExistException, RevisionRequiredException, InvalidRevisionException, SdkBaseException,
            SdkClientException, CodeDeployException {

        HttpResponseHandler<GetApplicationRevisionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetApplicationRevisionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetApplicationRevisionRequest, GetApplicationRevisionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getApplicationRevisionRequest)
                .withMarshaller(new GetApplicationRevisionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about a deployment.
     * </p>
     * 
     * @param getDeploymentRequest
     *        Represents the input of a GetDeployment operation.
     * @return Result of the GetDeployment operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentDoesNotExistException
     *         The deployment does not exist with the applicable IAM user or AWS account.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.GetDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDeploymentResponse getDeployment(GetDeploymentRequest getDeploymentRequest) throws DeploymentIdRequiredException,
            InvalidDeploymentIdException, DeploymentDoesNotExistException, SdkBaseException, SdkClientException,
            CodeDeployException {

        HttpResponseHandler<GetDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetDeploymentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDeploymentRequest, GetDeploymentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDeploymentRequest).withMarshaller(new GetDeploymentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about a deployment configuration.
     * </p>
     * 
     * @param getDeploymentConfigRequest
     *        Represents the input of a GetDeploymentConfig operation.
     * @return Result of the GetDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the applicable IAM user or AWS account.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.GetDeploymentConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDeploymentConfigResponse getDeploymentConfig(GetDeploymentConfigRequest getDeploymentConfigRequest)
            throws InvalidDeploymentConfigNameException, DeploymentConfigNameRequiredException,
            DeploymentConfigDoesNotExistException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<GetDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetDeploymentConfigResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDeploymentConfigRequest, GetDeploymentConfigResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDeploymentConfigRequest).withMarshaller(new GetDeploymentConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about a deployment group.
     * </p>
     * 
     * @param getDeploymentGroupRequest
     *        Represents the input of a GetDeploymentGroup operation.
     * @return Result of the GetDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group does not exist with the applicable IAM user or AWS account.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.GetDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDeploymentGroupResponse getDeploymentGroup(GetDeploymentGroupRequest getDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException,
            SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<GetDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetDeploymentGroupResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDeploymentGroupRequest, GetDeploymentGroupResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDeploymentGroupRequest).withMarshaller(new GetDeploymentGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about an instance as part of a deployment.
     * </p>
     * 
     * @param getDeploymentInstanceRequest
     *        Represents the input of a GetDeploymentInstance operation.
     * @return Result of the GetDeploymentInstance operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment does not exist with the applicable IAM user or AWS account.
     * @throws InstanceIdRequiredException
     *         The instance ID was not specified.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws InstanceDoesNotExistException
     *         The specified instance does not exist in the deployment group.
     * @throws InvalidInstanceNameException
     *         The specified on-premises instance name was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.GetDeploymentInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDeploymentInstanceResponse getDeploymentInstance(GetDeploymentInstanceRequest getDeploymentInstanceRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, InstanceIdRequiredException,
            InvalidDeploymentIdException, InstanceDoesNotExistException, InvalidInstanceNameException, SdkBaseException,
            SdkClientException, CodeDeployException {

        HttpResponseHandler<GetDeploymentInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetDeploymentInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDeploymentInstanceRequest, GetDeploymentInstanceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDeploymentInstanceRequest)
                .withMarshaller(new GetDeploymentInstanceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about an on-premises instance.
     * </p>
     * 
     * @param getOnPremisesInstanceRequest
     *        Represents the input of a GetOnPremisesInstance operation.
     * @return Result of the GetOnPremisesInstance operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InstanceNotRegisteredException
     *         The specified on-premises instance is not registered.
     * @throws InvalidInstanceNameException
     *         The specified on-premises instance name was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.GetOnPremisesInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOnPremisesInstanceResponse getOnPremisesInstance(GetOnPremisesInstanceRequest getOnPremisesInstanceRequest)
            throws InstanceNameRequiredException, InstanceNotRegisteredException, InvalidInstanceNameException, SdkBaseException,
            SdkClientException, CodeDeployException {

        HttpResponseHandler<GetOnPremisesInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetOnPremisesInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetOnPremisesInstanceRequest, GetOnPremisesInstanceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getOnPremisesInstanceRequest)
                .withMarshaller(new GetOnPremisesInstanceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     * 
     * @param listApplicationRevisionsRequest
     *        Represents the input of a ListApplicationRevisions operation.
     * @return Result of the ListApplicationRevisions operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws InvalidSortByException
     *         The column name to sort by is either not present or was specified in an invalid format.
     * @throws InvalidSortOrderException
     *         The sort order was specified in an invalid format.
     * @throws InvalidBucketNameFilterException
     *         The bucket name either doesn't exist or was specified in an invalid format.
     * @throws InvalidKeyPrefixFilterException
     *         The specified key prefix filter was specified in an invalid format.
     * @throws BucketNameFilterRequiredException
     *         A bucket name is required, but was not provided.
     * @throws InvalidDeployedStateFilterException
     *         The deployed state filter was specified in an invalid format.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListApplicationRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListApplicationRevisionsResponse listApplicationRevisions(
            ListApplicationRevisionsRequest listApplicationRevisionsRequest) throws ApplicationDoesNotExistException,
            ApplicationNameRequiredException, InvalidApplicationNameException, InvalidSortByException, InvalidSortOrderException,
            InvalidBucketNameFilterException, InvalidKeyPrefixFilterException, BucketNameFilterRequiredException,
            InvalidDeployedStateFilterException, InvalidNextTokenException, SdkBaseException, SdkClientException,
            CodeDeployException {

        HttpResponseHandler<ListApplicationRevisionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListApplicationRevisionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<ListApplicationRevisionsRequest, ListApplicationRevisionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listApplicationRevisionsRequest)
                        .withMarshaller(new ListApplicationRevisionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the applications registered with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listApplicationsRequest
     *        Represents the input of a ListApplications operation.
     * @return Result of the ListApplications operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest)
            throws InvalidNextTokenException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<ListApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListApplicationsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListApplicationsRequest, ListApplicationsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listApplicationsRequest).withMarshaller(new ListApplicationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the deployment configurations with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listDeploymentConfigsRequest
     *        Represents the input of a ListDeploymentConfigs operation.
     * @return Result of the ListDeploymentConfigs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListDeploymentConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDeploymentConfigsResponse listDeploymentConfigs(ListDeploymentConfigsRequest listDeploymentConfigsRequest)
            throws InvalidNextTokenException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<ListDeploymentConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListDeploymentConfigsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListDeploymentConfigsRequest, ListDeploymentConfigsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listDeploymentConfigsRequest)
                .withMarshaller(new ListDeploymentConfigsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the deployment groups for an application registered with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listDeploymentGroupsRequest
     *        Represents the input of a ListDeploymentGroups operation.
     * @return Result of the ListDeploymentGroups operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListDeploymentGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDeploymentGroupsResponse listDeploymentGroups(ListDeploymentGroupsRequest listDeploymentGroupsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            InvalidNextTokenException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<ListDeploymentGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListDeploymentGroupsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListDeploymentGroupsRequest, ListDeploymentGroupsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listDeploymentGroupsRequest)
                .withMarshaller(new ListDeploymentGroupsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the instance for a deployment associated with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listDeploymentInstancesRequest
     *        Represents the input of a ListDeploymentInstances operation.
     * @return Result of the ListDeploymentInstances operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentNotStartedException
     *         The specified deployment has not started.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws InvalidInstanceStatusException
     *         The specified instance status does not exist.
     * @throws InvalidInstanceTypeException
     *         An invalid instance type was specified for instances in a blue/green deployment. Valid values include
     *         "Blue" for an original environment and "Green" for a replacement environment.
     * @throws InvalidDeploymentInstanceTypeException
     *         An instance type was specified for an in-place deployment. Instance types are supported for blue/green
     *         deployments only.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListDeploymentInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDeploymentInstancesResponse listDeploymentInstances(ListDeploymentInstancesRequest listDeploymentInstancesRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentNotStartedException,
            InvalidNextTokenException, InvalidDeploymentIdException, InvalidInstanceStatusException,
            InvalidInstanceTypeException, InvalidDeploymentInstanceTypeException, SdkBaseException, SdkClientException,
            CodeDeployException {

        HttpResponseHandler<ListDeploymentInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListDeploymentInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListDeploymentInstancesRequest, ListDeploymentInstancesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listDeploymentInstancesRequest)
                .withMarshaller(new ListDeploymentInstancesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the applicable IAM user or AWS
     * account.
     * </p>
     * 
     * @param listDeploymentsRequest
     *        Represents the input of a ListDeployments operation.
     * @return Result of the ListDeployments operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidTimeRangeException
     *         The specified time range was specified in an invalid format.
     * @throws InvalidDeploymentStatusException
     *         The specified deployment status doesn't exist or cannot be determined.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDeploymentsResponse listDeployments(ListDeploymentsRequest listDeploymentsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException, DeploymentGroupNameRequiredException,
            InvalidTimeRangeException, InvalidDeploymentStatusException, InvalidNextTokenException, SdkBaseException,
            SdkClientException, CodeDeployException {

        HttpResponseHandler<ListDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListDeploymentsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListDeploymentsRequest, ListDeploymentsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listDeploymentsRequest).withMarshaller(new ListDeploymentsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the names of stored connections to GitHub accounts.
     * </p>
     * 
     * @param listGitHubAccountTokenNamesRequest
     *        Represents the input of a ListGitHubAccountTokenNames operation.
     * @return Result of the ListGitHubAccountTokenNames operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws ResourceValidationException
     *         The specified resource could not be validated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListGitHubAccountTokenNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListGitHubAccountTokenNames"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListGitHubAccountTokenNamesResponse listGitHubAccountTokenNames(
            ListGitHubAccountTokenNamesRequest listGitHubAccountTokenNamesRequest) throws InvalidNextTokenException,
            ResourceValidationException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<ListGitHubAccountTokenNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListGitHubAccountTokenNamesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<ListGitHubAccountTokenNamesRequest, ListGitHubAccountTokenNamesResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listGitHubAccountTokenNamesRequest)
                        .withMarshaller(new ListGitHubAccountTokenNamesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets a list of names for one or more on-premises instances.
     * </p>
     * <p>
     * Unless otherwise specified, both registered and deregistered on-premises instance names will be listed. To list
     * only registered or deregistered on-premises instance names, use the registration status parameter.
     * </p>
     * 
     * @param listOnPremisesInstancesRequest
     *        Represents the input of a ListOnPremisesInstances operation.
     * @return Result of the ListOnPremisesInstances operation returned by the service.
     * @throws InvalidRegistrationStatusException
     *         The registration status was specified in an invalid format.
     * @throws InvalidTagFilterException
     *         The specified tag filter was specified in an invalid format.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListOnPremisesInstancesResponse listOnPremisesInstances(ListOnPremisesInstancesRequest listOnPremisesInstancesRequest)
            throws InvalidRegistrationStatusException, InvalidTagFilterException, InvalidNextTokenException, SdkBaseException,
            SdkClientException, CodeDeployException {

        HttpResponseHandler<ListOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListOnPremisesInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListOnPremisesInstancesRequest, ListOnPremisesInstancesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listOnPremisesInstancesRequest)
                .withMarshaller(new ListOnPremisesInstancesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Registers with AWS CodeDeploy a revision for the specified application.
     * </p>
     * 
     * @param registerApplicationRevisionRequest
     *        Represents the input of a RegisterApplicationRevision operation.
     * @return Result of the RegisterApplicationRevision operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws DescriptionTooLongException
     *         The description is too long.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.RegisterApplicationRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterApplicationRevisionResponse registerApplicationRevision(
            RegisterApplicationRevisionRequest registerApplicationRevisionRequest) throws ApplicationDoesNotExistException,
            ApplicationNameRequiredException, InvalidApplicationNameException, DescriptionTooLongException,
            RevisionRequiredException, InvalidRevisionException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<RegisterApplicationRevisionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RegisterApplicationRevisionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RegisterApplicationRevisionRequest, RegisterApplicationRevisionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(registerApplicationRevisionRequest)
                        .withMarshaller(new RegisterApplicationRevisionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Registers an on-premises instance.
     * </p>
     * <note>
     * <p>
     * Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.
     * </p>
     * </note>
     * 
     * @param registerOnPremisesInstanceRequest
     *        Represents the input of the register on-premises instance operation.
     * @return Result of the RegisterOnPremisesInstance operation returned by the service.
     * @throws InstanceNameAlreadyRegisteredException
     *         The specified on-premises instance name is already registered.
     * @throws IamArnRequiredException
     *         No IAM ARN was included in the request. You must use an IAM session ARN or IAM user ARN in the request.
     * @throws IamSessionArnAlreadyRegisteredException
     *         The request included an IAM session ARN that has already been used to register a different instance.
     * @throws IamUserArnAlreadyRegisteredException
     *         The specified IAM user ARN is already registered with an on-premises instance.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws IamUserArnRequiredException
     *         An IAM user ARN was not specified.
     * @throws InvalidInstanceNameException
     *         The specified on-premises instance name was specified in an invalid format.
     * @throws InvalidIamSessionArnException
     *         The IAM session ARN was specified in an invalid format.
     * @throws InvalidIamUserArnException
     *         The IAM user ARN was specified in an invalid format.
     * @throws MultipleIamArnsProvidedException
     *         Both an IAM user ARN and an IAM session ARN were included in the request. Use only one ARN type.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.RegisterOnPremisesInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterOnPremisesInstanceResponse registerOnPremisesInstance(
            RegisterOnPremisesInstanceRequest registerOnPremisesInstanceRequest) throws InstanceNameAlreadyRegisteredException,
            IamArnRequiredException, IamSessionArnAlreadyRegisteredException, IamUserArnAlreadyRegisteredException,
            InstanceNameRequiredException, IamUserArnRequiredException, InvalidInstanceNameException,
            InvalidIamSessionArnException, InvalidIamUserArnException, MultipleIamArnsProvidedException, SdkBaseException,
            SdkClientException, CodeDeployException {

        HttpResponseHandler<RegisterOnPremisesInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RegisterOnPremisesInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RegisterOnPremisesInstanceRequest, RegisterOnPremisesInstanceResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(registerOnPremisesInstanceRequest)
                        .withMarshaller(new RegisterOnPremisesInstanceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes one or more tags from one or more on-premises instances.
     * </p>
     * 
     * @param removeTagsFromOnPremisesInstancesRequest
     *        Represents the input of a RemoveTagsFromOnPremisesInstances operation.
     * @return Result of the RemoveTagsFromOnPremisesInstances operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws TagRequiredException
     *         A tag was not specified.
     * @throws InvalidTagException
     *         The specified tag was specified in an invalid format.
     * @throws TagLimitExceededException
     *         The maximum allowed number of tags was exceeded.
     * @throws InstanceLimitExceededException
     *         The maximum number of allowed on-premises instances in a single call was exceeded.
     * @throws InstanceNotRegisteredException
     *         The specified on-premises instance is not registered.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.RemoveTagsFromOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RemoveTagsFromOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveTagsFromOnPremisesInstancesResponse removeTagsFromOnPremisesInstances(
            RemoveTagsFromOnPremisesInstancesRequest removeTagsFromOnPremisesInstancesRequest)
            throws InstanceNameRequiredException, TagRequiredException, InvalidTagException, TagLimitExceededException,
            InstanceLimitExceededException, InstanceNotRegisteredException, SdkBaseException, SdkClientException,
            CodeDeployException {

        HttpResponseHandler<RemoveTagsFromOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RemoveTagsFromOnPremisesInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RemoveTagsFromOnPremisesInstancesRequest, RemoveTagsFromOnPremisesInstancesResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(removeTagsFromOnPremisesInstancesRequest)
                        .withMarshaller(new RemoveTagsFromOnPremisesInstancesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after
     * the traffic routing is completed.
     * </p>
     * 
     * @param skipWaitTimeForInstanceTerminationRequest
     * @return Result of the SkipWaitTimeForInstanceTermination operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentAlreadyCompletedException
     *         The deployment is already complete.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentNotStartedException
     *         The specified deployment has not started.
     * @throws UnsupportedActionForDeploymentTypeException
     *         A call was submitted that is not supported for the specified deployment type.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.SkipWaitTimeForInstanceTermination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/SkipWaitTimeForInstanceTermination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SkipWaitTimeForInstanceTerminationResponse skipWaitTimeForInstanceTermination(
            SkipWaitTimeForInstanceTerminationRequest skipWaitTimeForInstanceTerminationRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentAlreadyCompletedException,
            InvalidDeploymentIdException, DeploymentNotStartedException, UnsupportedActionForDeploymentTypeException,
            SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<SkipWaitTimeForInstanceTerminationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new SkipWaitTimeForInstanceTerminationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<SkipWaitTimeForInstanceTerminationRequest, SkipWaitTimeForInstanceTerminationResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(skipWaitTimeForInstanceTerminationRequest)
                        .withMarshaller(new SkipWaitTimeForInstanceTerminationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Attempts to stop an ongoing deployment.
     * </p>
     * 
     * @param stopDeploymentRequest
     *        Represents the input of a StopDeployment operation.
     * @return Result of the StopDeployment operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentAlreadyCompletedException
     *         The deployment is already complete.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.StopDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/StopDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopDeploymentResponse stopDeployment(StopDeploymentRequest stopDeploymentRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentAlreadyCompletedException,
            InvalidDeploymentIdException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<StopDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new StopDeploymentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<StopDeploymentRequest, StopDeploymentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(stopDeploymentRequest).withMarshaller(new StopDeploymentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Changes the name of an application.
     * </p>
     * 
     * @param updateApplicationRequest
     *        Represents the input of an UpdateApplication operation.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationAlreadyExistsException
     *         An application with the specified name already exists with the applicable IAM user or AWS account.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.UpdateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationAlreadyExistsException,
            ApplicationDoesNotExistException, SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<UpdateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UpdateApplicationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateApplicationRequest, UpdateApplicationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateApplicationRequest).withMarshaller(new UpdateApplicationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Changes information about a deployment group.
     * </p>
     * 
     * @param updateDeploymentGroupRequest
     *        Represents the input of an UpdateDeploymentGroup operation.
     * @return Result of the UpdateDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupAlreadyExistsException
     *         A deployment group with the specified name already exists with the applicable IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group does not exist with the applicable IAM user or AWS account.
     * @throws InvalidEC2TagException
     *         The tag was specified in an invalid format.
     * @throws InvalidTagException
     *         The specified tag was specified in an invalid format.
     * @throws InvalidAutoScalingGroupException
     *         The Auto Scaling group was specified in an invalid format or does not exist.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the applicable IAM user or AWS account.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Auto Scaling.
     * @throws LifecycleHookLimitExceededException
     *         The limit for lifecycle hooks was exceeded.
     * @throws InvalidTriggerConfigException
     *         The trigger was specified in an invalid format.
     * @throws TriggerTargetsLimitExceededException
     *         The maximum allowed number of triggers was exceeded.
     * @throws InvalidAlarmConfigException
     *         The format of the alarm configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the 255 character limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled but the alarm list is empty.
     *         </p>
     *         </li>
     * @throws AlarmsLimitExceededException
     *         The maximum number of alarms for a deployment group (10) was exceeded.
     * @throws InvalidAutoRollbackConfigException
     *         The automatic rollback configuration was specified in an invalid format. For example, automatic rollback
     *         is enabled but an invalid triggering event type or no event types were listed.
     * @throws InvalidLoadBalancerInfoException
     *         An invalid load balancer name, or no load balancer name, was specified.
     * @throws InvalidDeploymentStyleException
     *         An invalid deployment style was specified. Valid deployment types include "IN_PLACE" and "BLUE_GREEN".
     *         Valid deployment options include "WITH_TRAFFIC_CONTROL" and "WITHOUT_TRAFFIC_CONTROL".
     * @throws InvalidBlueGreenDeploymentConfigurationException
     *         The configuration for the blue/green deployment group was provided in an invalid format. For information
     *         about deployment configuration format, see <a>CreateDeploymentConfig</a>.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.UpdateDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDeploymentGroupResponse updateDeploymentGroup(UpdateDeploymentGroupRequest updateDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            InvalidDeploymentGroupNameException, DeploymentGroupAlreadyExistsException, DeploymentGroupNameRequiredException,
            DeploymentGroupDoesNotExistException, InvalidEC2TagException, InvalidTagException, InvalidAutoScalingGroupException,
            InvalidDeploymentConfigNameException, DeploymentConfigDoesNotExistException, InvalidRoleException,
            LifecycleHookLimitExceededException, InvalidTriggerConfigException, TriggerTargetsLimitExceededException,
            InvalidAlarmConfigException, AlarmsLimitExceededException, InvalidAutoRollbackConfigException,
            InvalidLoadBalancerInfoException, InvalidDeploymentStyleException, InvalidBlueGreenDeploymentConfigurationException,
            SdkBaseException, SdkClientException, CodeDeployException {

        HttpResponseHandler<UpdateDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UpdateDeploymentGroupResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateDeploymentGroupRequest, UpdateDeploymentGroupResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateDeploymentGroupRequest)
                .withMarshaller(new UpdateDeploymentGroupRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata()
                .withProtocolVersion("1.1")
                .withSupportsCbor(false)
                .withSupportsIon(false)
                .withBaseServiceExceptionClass(software.amazon.awssdk.services.codedeploy.model.CodeDeployException.class)
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ResourceValidationException").withModeledClass(
                                ResourceValidationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidOperationException").withModeledClass(
                                InvalidOperationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentConfigDoesNotExistException").withModeledClass(
                                DeploymentConfigDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ApplicationNameRequiredException").withModeledClass(
                                ApplicationNameRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidAutoRollbackConfigException").withModeledClass(
                                InvalidAutoRollbackConfigException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentLimitExceededException").withModeledClass(
                                DeploymentLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidTagFilterException").withModeledClass(
                                InvalidTagFilterException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentAlreadyCompletedException").withModeledClass(
                                DeploymentAlreadyCompletedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentGroupLimitExceededException").withModeledClass(
                                DeploymentGroupLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeploymentGroupNameException").withModeledClass(
                                InvalidDeploymentGroupNameException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("AlarmsLimitExceededException").withModeledClass(
                                AlarmsLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(
                                InvalidNextTokenException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("TriggerTargetsLimitExceededException").withModeledClass(
                                TriggerTargetsLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidLoadBalancerInfoException").withModeledClass(
                                InvalidLoadBalancerInfoException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("MultipleIamArnsProvidedException").withModeledClass(
                                MultipleIamArnsProvidedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeploymentConfigNameException").withModeledClass(
                                InvalidDeploymentConfigNameException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("LifecycleHookLimitExceededException").withModeledClass(
                                LifecycleHookLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("IamUserArnAlreadyRegisteredException").withModeledClass(
                                IamUserArnAlreadyRegisteredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("RevisionRequiredException").withModeledClass(
                                RevisionRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentIsNotInReadyStateException").withModeledClass(
                                DeploymentIsNotInReadyStateException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InstanceNotRegisteredException").withModeledClass(
                                InstanceNotRegisteredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidBlueGreenDeploymentConfigurationException")
                                .withModeledClass(InvalidBlueGreenDeploymentConfigurationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ApplicationAlreadyExistsException").withModeledClass(
                                ApplicationAlreadyExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeployedStateFilterException").withModeledClass(
                                InvalidDeployedStateFilterException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InstanceDoesNotExistException").withModeledClass(
                                InstanceDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidAlarmConfigException").withModeledClass(
                                InvalidAlarmConfigException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DescriptionTooLongException").withModeledClass(
                                DescriptionTooLongException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidInstanceStatusException").withModeledClass(
                                InvalidInstanceStatusException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InstanceLimitExceededException").withModeledClass(
                                InstanceLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentIdRequiredException").withModeledClass(
                                DeploymentIdRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentConfigNameRequiredException").withModeledClass(
                                DeploymentConfigNameRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ApplicationLimitExceededException").withModeledClass(
                                ApplicationLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidRegistrationStatusException").withModeledClass(
                                InvalidRegistrationStatusException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentGroupDoesNotExistException").withModeledClass(
                                DeploymentGroupDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UnsupportedActionForDeploymentTypeException")
                                .withModeledClass(UnsupportedActionForDeploymentTypeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidMinimumHealthyHostValueException").withModeledClass(
                                InvalidMinimumHealthyHostValueException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("BatchLimitExceededException").withModeledClass(
                                BatchLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ApplicationDoesNotExistException").withModeledClass(
                                ApplicationDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidTargetInstancesException").withModeledClass(
                                InvalidTargetInstancesException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("TagRequiredException").withModeledClass(
                                TagRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("BucketNameFilterRequiredException").withModeledClass(
                                BucketNameFilterRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidIamUserArnException").withModeledClass(
                                InvalidIamUserArnException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidInstanceTypeException").withModeledClass(
                                InvalidInstanceTypeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidTriggerConfigException").withModeledClass(
                                InvalidTriggerConfigException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("IamArnRequiredException").withModeledClass(
                                IamArnRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidKeyPrefixFilterException").withModeledClass(
                                InvalidKeyPrefixFilterException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidBucketNameFilterException").withModeledClass(
                                InvalidBucketNameFilterException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("RoleRequiredException").withModeledClass(
                                RoleRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentNotStartedException").withModeledClass(
                                DeploymentNotStartedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidIamSessionArnException").withModeledClass(
                                InvalidIamSessionArnException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentGroupAlreadyExistsException").withModeledClass(
                                DeploymentGroupAlreadyExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InstanceNameRequiredException").withModeledClass(
                                InstanceNameRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentConfigLimitExceededException").withModeledClass(
                                DeploymentConfigLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidRevisionException").withModeledClass(
                                InvalidRevisionException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("IamUserArnRequiredException").withModeledClass(
                                IamUserArnRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeploymentIdException").withModeledClass(
                                InvalidDeploymentIdException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeploymentStatusException").withModeledClass(
                                InvalidDeploymentStatusException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidInstanceNameException").withModeledClass(
                                InvalidInstanceNameException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentConfigInUseException").withModeledClass(
                                DeploymentConfigInUseException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentConfigAlreadyExistsException").withModeledClass(
                                DeploymentConfigAlreadyExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("IamSessionArnAlreadyRegisteredException").withModeledClass(
                                IamSessionArnAlreadyRegisteredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InstanceNameAlreadyRegisteredException").withModeledClass(
                                InstanceNameAlreadyRegisteredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidTagException").withModeledClass(
                                InvalidTagException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidApplicationNameException").withModeledClass(
                                InvalidApplicationNameException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeploymentStyleException").withModeledClass(
                                InvalidDeploymentStyleException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidTimeRangeException").withModeledClass(
                                InvalidTimeRangeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidSortByException").withModeledClass(
                                InvalidSortByException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeploymentInstanceTypeException").withModeledClass(
                                InvalidDeploymentInstanceTypeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidEC2TagException").withModeledClass(
                                InvalidEC2TagException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentDoesNotExistException").withModeledClass(
                                DeploymentDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidSortOrderException").withModeledClass(
                                InvalidSortOrderException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentGroupNameRequiredException").withModeledClass(
                                DeploymentGroupNameRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("RevisionDoesNotExistException").withModeledClass(
                                RevisionDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidRoleException").withModeledClass(
                                InvalidRoleException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InstanceIdRequiredException").withModeledClass(
                                InstanceIdRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidFileExistsBehaviorException").withModeledClass(
                                InvalidFileExistsBehaviorException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("TagLimitExceededException").withModeledClass(
                                TagLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidAutoScalingGroupException").withModeledClass(
                                InvalidAutoScalingGroupException.class)));
    }

    public CodeDeployClientWaiters waiters() {
        if (waiters == null) {
            synchronized (this) {
                if (waiters == null) {
                    waiters = new CodeDeployClientWaiters(this);
                }
            }
        }
        return waiters;
    }

    @Override
    public void close() throws Exception {
        clientHandler.close();
    }
}
