/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.AlarmsLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.BucketNameFilterRequiredException;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.DeploymentAlreadyCompletedException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigInUseException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentIdRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentIsNotInReadyStateException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentNotStartedException;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.DescriptionTooLongException;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.IamArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.IamSessionArnAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.IamUserArnAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.IamUserArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.InstanceIdRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNotRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAlarmConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidApplicationNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAutoRollbackConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAutoScalingGroupException;
import software.amazon.awssdk.services.codedeploy.model.InvalidBlueGreenDeploymentConfigurationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidBucketNameFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeployedStateFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentConfigNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentGroupNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentInstanceTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentStyleException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEC2TagException;
import software.amazon.awssdk.services.codedeploy.model.InvalidFileExistsBehaviorException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIamSessionArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIamUserArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidKeyPrefixFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLoadBalancerInfoException;
import software.amazon.awssdk.services.codedeploy.model.InvalidMinimumHealthyHostValueException;
import software.amazon.awssdk.services.codedeploy.model.InvalidNextTokenException;
import software.amazon.awssdk.services.codedeploy.model.InvalidOperationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRegistrationStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRevisionException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRoleException;
import software.amazon.awssdk.services.codedeploy.model.InvalidSortByException;
import software.amazon.awssdk.services.codedeploy.model.InvalidSortOrderException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTargetInstancesException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTriggerConfigException;
import software.amazon.awssdk.services.codedeploy.model.LifecycleHookLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.MultipleIamArnsProvidedException;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ResourceValidationException;
import software.amazon.awssdk.services.codedeploy.model.RevisionDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.RevisionRequiredException;
import software.amazon.awssdk.services.codedeploy.model.RoleRequiredException;
import software.amazon.awssdk.services.codedeploy.model.SkipWaitTimeForInstanceTerminationRequest;
import software.amazon.awssdk.services.codedeploy.model.SkipWaitTimeForInstanceTerminationResponse;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.TagLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.TagRequiredException;
import software.amazon.awssdk.services.codedeploy.model.TriggerTargetsLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.UnsupportedActionForDeploymentTypeException;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.transform.AddTagsToOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.AddTagsToOnPremisesInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetApplicationRevisionsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetApplicationRevisionsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetApplicationsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetApplicationsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentGroupsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetDeploymentsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.BatchGetOnPremisesInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ContinueDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ContinueDeploymentResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateApplicationResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentConfigResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentGroupResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.CreateDeploymentResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteApplicationResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteDeploymentConfigResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeleteDeploymentGroupResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeregisterOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.DeregisterOnPremisesInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetApplicationResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetApplicationRevisionRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetApplicationRevisionResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentConfigRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentConfigResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentGroupResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetDeploymentResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.GetOnPremisesInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListApplicationRevisionsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListApplicationRevisionsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListApplicationsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentConfigsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentConfigsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentGroupsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListDeploymentsResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListGitHubAccountTokenNamesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListGitHubAccountTokenNamesResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.ListOnPremisesInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RegisterApplicationRevisionRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RegisterApplicationRevisionResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RegisterOnPremisesInstanceRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RegisterOnPremisesInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RemoveTagsFromOnPremisesInstancesRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.RemoveTagsFromOnPremisesInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.SkipWaitTimeForInstanceTerminationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.SkipWaitTimeForInstanceTerminationResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.StopDeploymentRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.StopDeploymentResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UpdateApplicationResponseUnmarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UpdateDeploymentGroupRequestMarshaller;
import software.amazon.awssdk.services.codedeploy.transform.UpdateDeploymentGroupResponseUnmarshaller;

/**
 * Internal implementation of {@link CodeDeployAsyncClient}.
 *
 * @see CodeDeployAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCodeDeployAsyncClient implements CodeDeployAsyncClient {
    private final AsyncClientHandler clientHandler;

    private final SdkJsonProtocolFactory protocolFactory;

    protected DefaultCodeDeployAsyncClient(AwsAsyncClientParams clientParams) {
        this.clientHandler = new SdkAsyncClientHandler(new ClientHandlerParams().withAsyncClientParams(clientParams)
                .withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Adds tags to on-premises instances.
     * </p>
     * 
     * @param addTagsToOnPremisesInstancesRequest
     *        Represents the input of, and adds tags to, an on-premises instance operation.
     * @return A Java Future containing the result of the AddTagsToOnPremisesInstances operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagException The specified tag was specified in an invalid format.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>InstanceLimitExceededException The maximum number of allowed on-premises instances in a single call
     *         was exceeded.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.AddTagsToOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/AddTagsToOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsToOnPremisesInstancesResponse> addTagsToOnPremisesInstances(
            AddTagsToOnPremisesInstancesRequest addTagsToOnPremisesInstancesRequest) {

        HttpResponseHandler<AddTagsToOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new AddTagsToOnPremisesInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<AddTagsToOnPremisesInstancesRequest, AddTagsToOnPremisesInstancesResponse>()
                        .withMarshaller(new AddTagsToOnPremisesInstancesRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(addTagsToOnPremisesInstancesRequest));
    }

    /**
     * <p>
     * Gets information about one or more application revisions.
     * </p>
     * 
     * @param batchGetApplicationRevisionsRequest
     *        Represents the input of a BatchGetApplicationRevisions operation.
     * @return A Java Future containing the result of the BatchGetApplicationRevisions operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.BatchGetApplicationRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetApplicationRevisionsResponse> batchGetApplicationRevisions(
            BatchGetApplicationRevisionsRequest batchGetApplicationRevisionsRequest) {

        HttpResponseHandler<BatchGetApplicationRevisionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new BatchGetApplicationRevisionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<BatchGetApplicationRevisionsRequest, BatchGetApplicationRevisionsResponse>()
                        .withMarshaller(new BatchGetApplicationRevisionsRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(batchGetApplicationRevisionsRequest));
    }

    /**
     * <p>
     * Gets information about one or more applications.
     * </p>
     * 
     * @param batchGetApplicationsRequest
     *        Represents the input of a BatchGetApplications operation.
     * @return A Java Future containing the result of the BatchGetApplications operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.BatchGetApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetApplicationsResponse> batchGetApplications(
            BatchGetApplicationsRequest batchGetApplicationsRequest) {

        HttpResponseHandler<BatchGetApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new BatchGetApplicationsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<BatchGetApplicationsRequest, BatchGetApplicationsResponse>()
                .withMarshaller(new BatchGetApplicationsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchGetApplicationsRequest));
    }

    /**
     * <p>
     * Gets information about one or more deployment groups.
     * </p>
     * 
     * @param batchGetDeploymentGroupsRequest
     *        Represents the input of a BatchGetDeploymentGroups operation.
     * @return A Java Future containing the result of the BatchGetDeploymentGroups operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.BatchGetDeploymentGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetDeploymentGroupsResponse> batchGetDeploymentGroups(
            BatchGetDeploymentGroupsRequest batchGetDeploymentGroupsRequest) {

        HttpResponseHandler<BatchGetDeploymentGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new BatchGetDeploymentGroupsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<BatchGetDeploymentGroupsRequest, BatchGetDeploymentGroupsResponse>()
                        .withMarshaller(new BatchGetDeploymentGroupsRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(batchGetDeploymentGroupsRequest));
    }

    /**
     * <p>
     * Gets information about one or more instance that are part of a deployment group.
     * </p>
     * 
     * @param batchGetDeploymentInstancesRequest
     *        Represents the input of a BatchGetDeploymentInstances operation.
     * @return A Java Future containing the result of the BatchGetDeploymentInstances operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>InstanceIdRequiredException The instance ID was not specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>InvalidInstanceNameException The specified on-premises instance name was specified in an invalid
     *         format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.BatchGetDeploymentInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetDeploymentInstancesResponse> batchGetDeploymentInstances(
            BatchGetDeploymentInstancesRequest batchGetDeploymentInstancesRequest) {

        HttpResponseHandler<BatchGetDeploymentInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new BatchGetDeploymentInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<BatchGetDeploymentInstancesRequest, BatchGetDeploymentInstancesResponse>()
                        .withMarshaller(new BatchGetDeploymentInstancesRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(batchGetDeploymentInstancesRequest));
    }

    /**
     * <p>
     * Gets information about one or more deployments.
     * </p>
     * 
     * @param batchGetDeploymentsRequest
     *        Represents the input of a BatchGetDeployments operation.
     * @return A Java Future containing the result of the BatchGetDeployments operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.BatchGetDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetDeploymentsResponse> batchGetDeployments(
            BatchGetDeploymentsRequest batchGetDeploymentsRequest) {

        HttpResponseHandler<BatchGetDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new BatchGetDeploymentsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<BatchGetDeploymentsRequest, BatchGetDeploymentsResponse>()
                .withMarshaller(new BatchGetDeploymentsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchGetDeploymentsRequest));
    }

    /**
     * <p>
     * Gets information about one or more on-premises instances.
     * </p>
     * 
     * @param batchGetOnPremisesInstancesRequest
     *        Represents the input of a BatchGetOnPremisesInstances operation.
     * @return A Java Future containing the result of the BatchGetOnPremisesInstances operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The specified on-premises instance name was specified in an invalid
     *         format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.BatchGetOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetOnPremisesInstancesResponse> batchGetOnPremisesInstances(
            BatchGetOnPremisesInstancesRequest batchGetOnPremisesInstancesRequest) {

        HttpResponseHandler<BatchGetOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new BatchGetOnPremisesInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<BatchGetOnPremisesInstancesRequest, BatchGetOnPremisesInstancesResponse>()
                        .withMarshaller(new BatchGetOnPremisesInstancesRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(batchGetOnPremisesInstancesRequest));
    }

    /**
     * <p>
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment
     * to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic
     * rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can
     * start as soon as all instances have a status of Ready.)
     * </p>
     * 
     * @param continueDeploymentRequest
     * @return A Java Future containing the result of the ContinueDeployment operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentAlreadyCompletedException The deployment is already complete.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentIsNotInReadyStateException The deployment does not have a status of Ready and can't
     *         continue yet.</li>
     *         <li>UnsupportedActionForDeploymentTypeException A call was submitted that is not supported for the
     *         specified deployment type.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ContinueDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ContinueDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ContinueDeploymentResponse> continueDeployment(ContinueDeploymentRequest continueDeploymentRequest) {

        HttpResponseHandler<ContinueDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ContinueDeploymentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ContinueDeploymentRequest, ContinueDeploymentResponse>()
                .withMarshaller(new ContinueDeploymentRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(continueDeploymentRequest));
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     * 
     * @param createApplicationRequest
     *        Represents the input of a CreateApplication operation.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationAlreadyExistsException An application with the specified name already exists with the
     *         applicable IAM user or AWS account.</li>
     *         <li>ApplicationLimitExceededException More applications were attempted to be created than are allowed.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.CreateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {

        HttpResponseHandler<CreateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateApplicationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateApplicationRequest, CreateApplicationResponse>()
                .withMarshaller(new CreateApplicationRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createApplicationRequest));
    }

    /**
     * <p>
     * Deploys an application revision through the specified deployment group.
     * </p>
     * 
     * @param createDeploymentRequest
     *        Represents the input of a CreateDeployment operation.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>RevisionDoesNotExistException The named revision does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>DescriptionTooLongException The description is too long.</li>
     *         <li>DeploymentLimitExceededException The number of allowed deployments was exceeded.</li>
     *         <li>InvalidTargetInstancesException The target instance configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Configuration data for target instances was entered for an in-place deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The limit of 10 tags for a tag type was exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The combined length of the tag names exceeded the limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A specified tag is not currently applied to any instances.
     *         </p>
     *         </li></li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled but an invalid triggering event type or no event types
     *         were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidFileExistsBehaviorException An invalid fileExistsBehavior option was specified to determine
     *         how AWS CodeDeploy handles files or directories that already exist in a deployment target location but
     *         weren't part of the previous successful deployment. Valid values include "DISALLOW", "OVERWRITE", and
     *         "RETAIN".</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.CreateDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {

        HttpResponseHandler<CreateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateDeploymentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateDeploymentRequest, CreateDeploymentResponse>()
                .withMarshaller(new CreateDeploymentRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createDeploymentRequest));
    }

    /**
     * <p>
     * Creates a deployment configuration.
     * </p>
     * 
     * @param createDeploymentConfigRequest
     *        Represents the input of a CreateDeploymentConfig operation.
     * @return A Java Future containing the result of the CreateDeploymentConfig operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigAlreadyExistsException A deployment configuration with the specified name already
     *         exists with the applicable IAM user or AWS account.</li>
     *         <li>InvalidMinimumHealthyHostValueException The minimum healthy instance value was specified in an
     *         invalid format.</li>
     *         <li>DeploymentConfigLimitExceededException The deployment configurations limit was exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.CreateDeploymentConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeploymentConfigResponse> createDeploymentConfig(
            CreateDeploymentConfigRequest createDeploymentConfigRequest) {

        HttpResponseHandler<CreateDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateDeploymentConfigResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateDeploymentConfigRequest, CreateDeploymentConfigResponse>()
                .withMarshaller(new CreateDeploymentConfigRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createDeploymentConfigRequest));
    }

    /**
     * <p>
     * Creates a deployment group to which application revisions will be deployed.
     * </p>
     * 
     * @param createDeploymentGroupRequest
     *        Represents the input of a CreateDeploymentGroup operation.
     * @return A Java Future containing the result of the CreateDeploymentGroup operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupAlreadyExistsException A deployment group with the specified name already exists with
     *         the applicable IAM user or AWS account.</li>
     *         <li>InvalidEC2TagException The tag was specified in an invalid format.</li>
     *         <li>InvalidTagException The specified tag was specified in an invalid format.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>RoleRequiredException The role ID was not specified.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Auto
     *         Scaling.</li>
     *         <li>DeploymentGroupLimitExceededException The deployment groups limit was exceeded.</li>
     *         <li>LifecycleHookLimitExceededException The limit for lifecycle hooks was exceeded.</li>
     *         <li>InvalidTriggerConfigException The trigger was specified in an invalid format.</li>
     *         <li>TriggerTargetsLimitExceededException The maximum allowed number of triggers was exceeded.</li>
     *         <li>InvalidAlarmConfigException The format of the alarm configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the 255 character limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled but the alarm list is empty.
     *         </p>
     *         </li></li>
     *         <li>AlarmsLimitExceededException The maximum number of alarms for a deployment group (10) was exceeded.</li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled but an invalid triggering event type or no event types
     *         were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidDeploymentStyleException An invalid deployment style was specified. Valid deployment types
     *         include "IN_PLACE" and "BLUE_GREEN". Valid deployment options include "WITH_TRAFFIC_CONTROL" and
     *         "WITHOUT_TRAFFIC_CONTROL".</li>
     *         <li>InvalidBlueGreenDeploymentConfigurationException The configuration for the blue/green deployment
     *         group was provided in an invalid format. For information about deployment configuration format, see
     *         <a>CreateDeploymentConfig</a>.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.CreateDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeploymentGroupResponse> createDeploymentGroup(
            CreateDeploymentGroupRequest createDeploymentGroupRequest) {

        HttpResponseHandler<CreateDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CreateDeploymentGroupResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateDeploymentGroupRequest, CreateDeploymentGroupResponse>()
                .withMarshaller(new CreateDeploymentGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createDeploymentGroupRequest));
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     * 
     * @param deleteApplicationRequest
     *        Represents the input of a DeleteApplication operation.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.DeleteApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {

        HttpResponseHandler<DeleteApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteApplicationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteApplicationRequest, DeleteApplicationResponse>()
                .withMarshaller(new DeleteApplicationRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteApplicationRequest));
    }

    /**
     * <p>
     * Deletes a deployment configuration.
     * </p>
     * <note>
     * <p>
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be
     * deleted.
     * </p>
     * </note>
     * 
     * @param deleteDeploymentConfigRequest
     *        Represents the input of a DeleteDeploymentConfig operation.
     * @return A Java Future containing the result of the DeleteDeploymentConfig operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigInUseException The deployment configuration is still in use.</li>
     *         <li>InvalidOperationException An invalid operation was detected.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.DeleteDeploymentConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeploymentConfigResponse> deleteDeploymentConfig(
            DeleteDeploymentConfigRequest deleteDeploymentConfigRequest) {

        HttpResponseHandler<DeleteDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteDeploymentConfigResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteDeploymentConfigRequest, DeleteDeploymentConfigResponse>()
                .withMarshaller(new DeleteDeploymentConfigRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteDeploymentConfigRequest));
    }

    /**
     * <p>
     * Deletes a deployment group.
     * </p>
     * 
     * @param deleteDeploymentGroupRequest
     *        Represents the input of a DeleteDeploymentGroup operation.
     * @return A Java Future containing the result of the DeleteDeploymentGroup operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Auto
     *         Scaling.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.DeleteDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeploymentGroupResponse> deleteDeploymentGroup(
            DeleteDeploymentGroupRequest deleteDeploymentGroupRequest) {

        HttpResponseHandler<DeleteDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeleteDeploymentGroupResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteDeploymentGroupRequest, DeleteDeploymentGroupResponse>()
                .withMarshaller(new DeleteDeploymentGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteDeploymentGroupRequest));
    }

    /**
     * <p>
     * Deregisters an on-premises instance.
     * </p>
     * 
     * @param deregisterOnPremisesInstanceRequest
     *        Represents the input of a DeregisterOnPremisesInstance operation.
     * @return A Java Future containing the result of the DeregisterOnPremisesInstance operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The specified on-premises instance name was specified in an invalid
     *         format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.DeregisterOnPremisesInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeregisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterOnPremisesInstanceResponse> deregisterOnPremisesInstance(
            DeregisterOnPremisesInstanceRequest deregisterOnPremisesInstanceRequest) {

        HttpResponseHandler<DeregisterOnPremisesInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeregisterOnPremisesInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DeregisterOnPremisesInstanceRequest, DeregisterOnPremisesInstanceResponse>()
                        .withMarshaller(new DeregisterOnPremisesInstanceRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deregisterOnPremisesInstanceRequest));
    }

    /**
     * <p>
     * Gets information about an application.
     * </p>
     * 
     * @param getApplicationRequest
     *        Represents the input of a GetApplication operation.
     * @return A Java Future containing the result of the GetApplication operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.GetApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetApplicationResponse> getApplication(GetApplicationRequest getApplicationRequest) {

        HttpResponseHandler<GetApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetApplicationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetApplicationRequest, GetApplicationResponse>()
                .withMarshaller(new GetApplicationRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getApplicationRequest));
    }

    /**
     * <p>
     * Gets information about an application revision.
     * </p>
     * 
     * @param getApplicationRevisionRequest
     *        Represents the input of a GetApplicationRevision operation.
     * @return A Java Future containing the result of the GetApplicationRevision operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>RevisionDoesNotExistException The named revision does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.GetApplicationRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetApplicationRevisionResponse> getApplicationRevision(
            GetApplicationRevisionRequest getApplicationRevisionRequest) {

        HttpResponseHandler<GetApplicationRevisionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetApplicationRevisionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetApplicationRevisionRequest, GetApplicationRevisionResponse>()
                .withMarshaller(new GetApplicationRevisionRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getApplicationRevisionRequest));
    }

    /**
     * <p>
     * Gets information about a deployment.
     * </p>
     * 
     * @param getDeploymentRequest
     *        Represents the input of a GetDeployment operation.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentDoesNotExistException The deployment does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.GetDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeploymentResponse> getDeployment(GetDeploymentRequest getDeploymentRequest) {

        HttpResponseHandler<GetDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetDeploymentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDeploymentRequest, GetDeploymentResponse>()
                .withMarshaller(new GetDeploymentRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDeploymentRequest));
    }

    /**
     * <p>
     * Gets information about a deployment configuration.
     * </p>
     * 
     * @param getDeploymentConfigRequest
     *        Represents the input of a GetDeploymentConfig operation.
     * @return A Java Future containing the result of the GetDeploymentConfig operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.GetDeploymentConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeploymentConfigResponse> getDeploymentConfig(
            GetDeploymentConfigRequest getDeploymentConfigRequest) {

        HttpResponseHandler<GetDeploymentConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetDeploymentConfigResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDeploymentConfigRequest, GetDeploymentConfigResponse>()
                .withMarshaller(new GetDeploymentConfigRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDeploymentConfigRequest));
    }

    /**
     * <p>
     * Gets information about a deployment group.
     * </p>
     * 
     * @param getDeploymentGroupRequest
     *        Represents the input of a GetDeploymentGroup operation.
     * @return A Java Future containing the result of the GetDeploymentGroup operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.GetDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeploymentGroupResponse> getDeploymentGroup(GetDeploymentGroupRequest getDeploymentGroupRequest) {

        HttpResponseHandler<GetDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetDeploymentGroupResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDeploymentGroupRequest, GetDeploymentGroupResponse>()
                .withMarshaller(new GetDeploymentGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDeploymentGroupRequest));
    }

    /**
     * <p>
     * Gets information about an instance as part of a deployment.
     * </p>
     * 
     * @param getDeploymentInstanceRequest
     *        Represents the input of a GetDeploymentInstance operation.
     * @return A Java Future containing the result of the GetDeploymentInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>InstanceIdRequiredException The instance ID was not specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>InstanceDoesNotExistException The specified instance does not exist in the deployment group.</li>
     *         <li>InvalidInstanceNameException The specified on-premises instance name was specified in an invalid
     *         format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.GetDeploymentInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeploymentInstanceResponse> getDeploymentInstance(
            GetDeploymentInstanceRequest getDeploymentInstanceRequest) {

        HttpResponseHandler<GetDeploymentInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetDeploymentInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDeploymentInstanceRequest, GetDeploymentInstanceResponse>()
                .withMarshaller(new GetDeploymentInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDeploymentInstanceRequest));
    }

    /**
     * <p>
     * Gets information about an on-premises instance.
     * </p>
     * 
     * @param getOnPremisesInstanceRequest
     *        Represents the input of a GetOnPremisesInstance operation.
     * @return A Java Future containing the result of the GetOnPremisesInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>InvalidInstanceNameException The specified on-premises instance name was specified in an invalid
     *         format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.GetOnPremisesInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOnPremisesInstanceResponse> getOnPremisesInstance(
            GetOnPremisesInstanceRequest getOnPremisesInstanceRequest) {

        HttpResponseHandler<GetOnPremisesInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetOnPremisesInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetOnPremisesInstanceRequest, GetOnPremisesInstanceResponse>()
                .withMarshaller(new GetOnPremisesInstanceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getOnPremisesInstanceRequest));
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     * 
     * @param listApplicationRevisionsRequest
     *        Represents the input of a ListApplicationRevisions operation.
     * @return A Java Future containing the result of the ListApplicationRevisions operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>InvalidSortByException The column name to sort by is either not present or was specified in an
     *         invalid format.</li>
     *         <li>InvalidSortOrderException The sort order was specified in an invalid format.</li>
     *         <li>InvalidBucketNameFilterException The bucket name either doesn't exist or was specified in an invalid
     *         format.</li>
     *         <li>InvalidKeyPrefixFilterException The specified key prefix filter was specified in an invalid format.</li>
     *         <li>BucketNameFilterRequiredException A bucket name is required, but was not provided.</li>
     *         <li>InvalidDeployedStateFilterException The deployed state filter was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListApplicationRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListApplicationRevisionsResponse> listApplicationRevisions(
            ListApplicationRevisionsRequest listApplicationRevisionsRequest) {

        HttpResponseHandler<ListApplicationRevisionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListApplicationRevisionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<ListApplicationRevisionsRequest, ListApplicationRevisionsResponse>()
                        .withMarshaller(new ListApplicationRevisionsRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listApplicationRevisionsRequest));
    }

    /**
     * <p>
     * Lists the applications registered with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listApplicationsRequest
     *        Represents the input of a ListApplications operation.
     * @return A Java Future containing the result of the ListApplications operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {

        HttpResponseHandler<ListApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListApplicationsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListApplicationsRequest, ListApplicationsResponse>()
                .withMarshaller(new ListApplicationsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listApplicationsRequest));
    }

    /**
     * <p>
     * Lists the deployment configurations with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listDeploymentConfigsRequest
     *        Represents the input of a ListDeploymentConfigs operation.
     * @return A Java Future containing the result of the ListDeploymentConfigs operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListDeploymentConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeploymentConfigsResponse> listDeploymentConfigs(
            ListDeploymentConfigsRequest listDeploymentConfigsRequest) {

        HttpResponseHandler<ListDeploymentConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListDeploymentConfigsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListDeploymentConfigsRequest, ListDeploymentConfigsResponse>()
                .withMarshaller(new ListDeploymentConfigsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listDeploymentConfigsRequest));
    }

    /**
     * <p>
     * Lists the deployment groups for an application registered with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listDeploymentGroupsRequest
     *        Represents the input of a ListDeploymentGroups operation.
     * @return A Java Future containing the result of the ListDeploymentGroups operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListDeploymentGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeploymentGroupsResponse> listDeploymentGroups(
            ListDeploymentGroupsRequest listDeploymentGroupsRequest) {

        HttpResponseHandler<ListDeploymentGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListDeploymentGroupsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListDeploymentGroupsRequest, ListDeploymentGroupsResponse>()
                .withMarshaller(new ListDeploymentGroupsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listDeploymentGroupsRequest));
    }

    /**
     * <p>
     * Lists the instance for a deployment associated with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listDeploymentInstancesRequest
     *        Represents the input of a ListDeploymentInstances operation.
     * @return A Java Future containing the result of the ListDeploymentInstances operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>InvalidInstanceStatusException The specified instance status does not exist.</li>
     *         <li>InvalidInstanceTypeException An invalid instance type was specified for instances in a blue/green
     *         deployment. Valid values include "Blue" for an original environment and "Green" for a replacement
     *         environment.</li>
     *         <li>InvalidDeploymentInstanceTypeException An instance type was specified for an in-place deployment.
     *         Instance types are supported for blue/green deployments only.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListDeploymentInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeploymentInstancesResponse> listDeploymentInstances(
            ListDeploymentInstancesRequest listDeploymentInstancesRequest) {

        HttpResponseHandler<ListDeploymentInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListDeploymentInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListDeploymentInstancesRequest, ListDeploymentInstancesResponse>()
                .withMarshaller(new ListDeploymentInstancesRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listDeploymentInstancesRequest));
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the applicable IAM user or AWS
     * account.
     * </p>
     * 
     * @param listDeploymentsRequest
     *        Represents the input of a ListDeployments operation.
     * @return A Java Future containing the result of the ListDeployments operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidTimeRangeException The specified time range was specified in an invalid format.</li>
     *         <li>InvalidDeploymentStatusException The specified deployment status doesn't exist or cannot be
     *         determined.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest listDeploymentsRequest) {

        HttpResponseHandler<ListDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListDeploymentsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListDeploymentsRequest, ListDeploymentsResponse>()
                .withMarshaller(new ListDeploymentsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listDeploymentsRequest));
    }

    /**
     * <p>
     * Lists the names of stored connections to GitHub accounts.
     * </p>
     * 
     * @param listGitHubAccountTokenNamesRequest
     *        Represents the input of a ListGitHubAccountTokenNames operation.
     * @return A Java Future containing the result of the ListGitHubAccountTokenNames operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>ResourceValidationException The specified resource could not be validated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListGitHubAccountTokenNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListGitHubAccountTokenNames"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGitHubAccountTokenNamesResponse> listGitHubAccountTokenNames(
            ListGitHubAccountTokenNamesRequest listGitHubAccountTokenNamesRequest) {

        HttpResponseHandler<ListGitHubAccountTokenNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListGitHubAccountTokenNamesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<ListGitHubAccountTokenNamesRequest, ListGitHubAccountTokenNamesResponse>()
                        .withMarshaller(new ListGitHubAccountTokenNamesRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listGitHubAccountTokenNamesRequest));
    }

    /**
     * <p>
     * Gets a list of names for one or more on-premises instances.
     * </p>
     * <p>
     * Unless otherwise specified, both registered and deregistered on-premises instance names will be listed. To list
     * only registered or deregistered on-premises instance names, use the registration status parameter.
     * </p>
     * 
     * @param listOnPremisesInstancesRequest
     *        Represents the input of a ListOnPremisesInstances operation.
     * @return A Java Future containing the result of the ListOnPremisesInstances operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRegistrationStatusException The registration status was specified in an invalid format.</li>
     *         <li>InvalidTagFilterException The specified tag filter was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOnPremisesInstancesResponse> listOnPremisesInstances(
            ListOnPremisesInstancesRequest listOnPremisesInstancesRequest) {

        HttpResponseHandler<ListOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListOnPremisesInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListOnPremisesInstancesRequest, ListOnPremisesInstancesResponse>()
                .withMarshaller(new ListOnPremisesInstancesRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listOnPremisesInstancesRequest));
    }

    /**
     * <p>
     * Registers with AWS CodeDeploy a revision for the specified application.
     * </p>
     * 
     * @param registerApplicationRevisionRequest
     *        Represents the input of a RegisterApplicationRevision operation.
     * @return A Java Future containing the result of the RegisterApplicationRevision operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>DescriptionTooLongException The description is too long.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.RegisterApplicationRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterApplicationRevisionResponse> registerApplicationRevision(
            RegisterApplicationRevisionRequest registerApplicationRevisionRequest) {

        HttpResponseHandler<RegisterApplicationRevisionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RegisterApplicationRevisionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RegisterApplicationRevisionRequest, RegisterApplicationRevisionResponse>()
                        .withMarshaller(new RegisterApplicationRevisionRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(registerApplicationRevisionRequest));
    }

    /**
     * <p>
     * Registers an on-premises instance.
     * </p>
     * <note>
     * <p>
     * Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.
     * </p>
     * </note>
     * 
     * @param registerOnPremisesInstanceRequest
     *        Represents the input of the register on-premises instance operation.
     * @return A Java Future containing the result of the RegisterOnPremisesInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameAlreadyRegisteredException The specified on-premises instance name is already registered.
     *         </li>
     *         <li>IamArnRequiredException No IAM ARN was included in the request. You must use an IAM session ARN or
     *         IAM user ARN in the request.</li>
     *         <li>IamSessionArnAlreadyRegisteredException The request included an IAM session ARN that has already been
     *         used to register a different instance.</li>
     *         <li>IamUserArnAlreadyRegisteredException The specified IAM user ARN is already registered with an
     *         on-premises instance.</li>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>IamUserArnRequiredException An IAM user ARN was not specified.</li>
     *         <li>InvalidInstanceNameException The specified on-premises instance name was specified in an invalid
     *         format.</li>
     *         <li>InvalidIamSessionArnException The IAM session ARN was specified in an invalid format.</li>
     *         <li>InvalidIamUserArnException The IAM user ARN was specified in an invalid format.</li>
     *         <li>MultipleIamArnsProvidedException Both an IAM user ARN and an IAM session ARN were included in the
     *         request. Use only one ARN type.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.RegisterOnPremisesInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterOnPremisesInstanceResponse> registerOnPremisesInstance(
            RegisterOnPremisesInstanceRequest registerOnPremisesInstanceRequest) {

        HttpResponseHandler<RegisterOnPremisesInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RegisterOnPremisesInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RegisterOnPremisesInstanceRequest, RegisterOnPremisesInstanceResponse>()
                        .withMarshaller(new RegisterOnPremisesInstanceRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(registerOnPremisesInstanceRequest));
    }

    /**
     * <p>
     * Removes one or more tags from one or more on-premises instances.
     * </p>
     * 
     * @param removeTagsFromOnPremisesInstancesRequest
     *        Represents the input of a RemoveTagsFromOnPremisesInstances operation.
     * @return A Java Future containing the result of the RemoveTagsFromOnPremisesInstances operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagException The specified tag was specified in an invalid format.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>InstanceLimitExceededException The maximum number of allowed on-premises instances in a single call
     *         was exceeded.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.RemoveTagsFromOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RemoveTagsFromOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveTagsFromOnPremisesInstancesResponse> removeTagsFromOnPremisesInstances(
            RemoveTagsFromOnPremisesInstancesRequest removeTagsFromOnPremisesInstancesRequest) {

        HttpResponseHandler<RemoveTagsFromOnPremisesInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RemoveTagsFromOnPremisesInstancesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RemoveTagsFromOnPremisesInstancesRequest, RemoveTagsFromOnPremisesInstancesResponse>()
                        .withMarshaller(new RemoveTagsFromOnPremisesInstancesRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(removeTagsFromOnPremisesInstancesRequest));
    }

    /**
     * <p>
     * In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after
     * the traffic routing is completed.
     * </p>
     * 
     * @param skipWaitTimeForInstanceTerminationRequest
     * @return A Java Future containing the result of the SkipWaitTimeForInstanceTermination operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentAlreadyCompletedException The deployment is already complete.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>UnsupportedActionForDeploymentTypeException A call was submitted that is not supported for the
     *         specified deployment type.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.SkipWaitTimeForInstanceTermination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/SkipWaitTimeForInstanceTermination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SkipWaitTimeForInstanceTerminationResponse> skipWaitTimeForInstanceTermination(
            SkipWaitTimeForInstanceTerminationRequest skipWaitTimeForInstanceTerminationRequest) {

        HttpResponseHandler<SkipWaitTimeForInstanceTerminationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new SkipWaitTimeForInstanceTerminationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<SkipWaitTimeForInstanceTerminationRequest, SkipWaitTimeForInstanceTerminationResponse>()
                        .withMarshaller(new SkipWaitTimeForInstanceTerminationRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(skipWaitTimeForInstanceTerminationRequest));
    }

    /**
     * <p>
     * Attempts to stop an ongoing deployment.
     * </p>
     * 
     * @param stopDeploymentRequest
     *        Represents the input of a StopDeployment operation.
     * @return A Java Future containing the result of the StopDeployment operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentAlreadyCompletedException The deployment is already complete.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.StopDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/StopDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopDeploymentResponse> stopDeployment(StopDeploymentRequest stopDeploymentRequest) {

        HttpResponseHandler<StopDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new StopDeploymentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<StopDeploymentRequest, StopDeploymentResponse>()
                .withMarshaller(new StopDeploymentRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(stopDeploymentRequest));
    }

    /**
     * <p>
     * Changes the name of an application.
     * </p>
     * 
     * @param updateApplicationRequest
     *        Represents the input of an UpdateApplication operation.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationAlreadyExistsException An application with the specified name already exists with the
     *         applicable IAM user or AWS account.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.UpdateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {

        HttpResponseHandler<UpdateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UpdateApplicationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateApplicationRequest, UpdateApplicationResponse>()
                .withMarshaller(new UpdateApplicationRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateApplicationRequest));
    }

    /**
     * <p>
     * Changes information about a deployment group.
     * </p>
     * 
     * @param updateDeploymentGroupRequest
     *        Represents the input of an UpdateDeploymentGroup operation.
     * @return A Java Future containing the result of the UpdateDeploymentGroup operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupAlreadyExistsException A deployment group with the specified name already exists with
     *         the applicable IAM user or AWS account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>InvalidEC2TagException The tag was specified in an invalid format.</li>
     *         <li>InvalidTagException The specified tag was specified in an invalid format.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Auto
     *         Scaling.</li>
     *         <li>LifecycleHookLimitExceededException The limit for lifecycle hooks was exceeded.</li>
     *         <li>InvalidTriggerConfigException The trigger was specified in an invalid format.</li>
     *         <li>TriggerTargetsLimitExceededException The maximum allowed number of triggers was exceeded.</li>
     *         <li>InvalidAlarmConfigException The format of the alarm configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the 255 character limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled but the alarm list is empty.
     *         </p>
     *         </li></li>
     *         <li>AlarmsLimitExceededException The maximum number of alarms for a deployment group (10) was exceeded.</li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled but an invalid triggering event type or no event types
     *         were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidDeploymentStyleException An invalid deployment style was specified. Valid deployment types
     *         include "IN_PLACE" and "BLUE_GREEN". Valid deployment options include "WITH_TRAFFIC_CONTROL" and
     *         "WITHOUT_TRAFFIC_CONTROL".</li>
     *         <li>InvalidBlueGreenDeploymentConfigurationException The configuration for the blue/green deployment
     *         group was provided in an invalid format. For information about deployment configuration format, see
     *         <a>CreateDeploymentConfig</a>.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.UpdateDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDeploymentGroupResponse> updateDeploymentGroup(
            UpdateDeploymentGroupRequest updateDeploymentGroupRequest) {

        HttpResponseHandler<UpdateDeploymentGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new UpdateDeploymentGroupResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateDeploymentGroupRequest, UpdateDeploymentGroupResponse>()
                .withMarshaller(new UpdateDeploymentGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateDeploymentGroupRequest));
    }

    @Override
    public void close() throws Exception {
        clientHandler.close();
    }

    private software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata()
                .withProtocolVersion("1.1")
                .withSupportsCbor(false)
                .withSupportsIon(false)
                .withBaseServiceExceptionClass(software.amazon.awssdk.services.codedeploy.model.CodeDeployException.class)
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ResourceValidationException").withModeledClass(
                                ResourceValidationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidOperationException").withModeledClass(
                                InvalidOperationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentConfigDoesNotExistException").withModeledClass(
                                DeploymentConfigDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ApplicationNameRequiredException").withModeledClass(
                                ApplicationNameRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidAutoRollbackConfigException").withModeledClass(
                                InvalidAutoRollbackConfigException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentLimitExceededException").withModeledClass(
                                DeploymentLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidTagFilterException").withModeledClass(
                                InvalidTagFilterException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentAlreadyCompletedException").withModeledClass(
                                DeploymentAlreadyCompletedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentGroupLimitExceededException").withModeledClass(
                                DeploymentGroupLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeploymentGroupNameException").withModeledClass(
                                InvalidDeploymentGroupNameException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("AlarmsLimitExceededException").withModeledClass(
                                AlarmsLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(
                                InvalidNextTokenException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("TriggerTargetsLimitExceededException").withModeledClass(
                                TriggerTargetsLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidLoadBalancerInfoException").withModeledClass(
                                InvalidLoadBalancerInfoException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("MultipleIamArnsProvidedException").withModeledClass(
                                MultipleIamArnsProvidedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeploymentConfigNameException").withModeledClass(
                                InvalidDeploymentConfigNameException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("LifecycleHookLimitExceededException").withModeledClass(
                                LifecycleHookLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("IamUserArnAlreadyRegisteredException").withModeledClass(
                                IamUserArnAlreadyRegisteredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("RevisionRequiredException").withModeledClass(
                                RevisionRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentIsNotInReadyStateException").withModeledClass(
                                DeploymentIsNotInReadyStateException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InstanceNotRegisteredException").withModeledClass(
                                InstanceNotRegisteredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidBlueGreenDeploymentConfigurationException")
                                .withModeledClass(InvalidBlueGreenDeploymentConfigurationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ApplicationAlreadyExistsException").withModeledClass(
                                ApplicationAlreadyExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeployedStateFilterException").withModeledClass(
                                InvalidDeployedStateFilterException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InstanceDoesNotExistException").withModeledClass(
                                InstanceDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidAlarmConfigException").withModeledClass(
                                InvalidAlarmConfigException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DescriptionTooLongException").withModeledClass(
                                DescriptionTooLongException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidInstanceStatusException").withModeledClass(
                                InvalidInstanceStatusException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InstanceLimitExceededException").withModeledClass(
                                InstanceLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentIdRequiredException").withModeledClass(
                                DeploymentIdRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentConfigNameRequiredException").withModeledClass(
                                DeploymentConfigNameRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ApplicationLimitExceededException").withModeledClass(
                                ApplicationLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidRegistrationStatusException").withModeledClass(
                                InvalidRegistrationStatusException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentGroupDoesNotExistException").withModeledClass(
                                DeploymentGroupDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UnsupportedActionForDeploymentTypeException")
                                .withModeledClass(UnsupportedActionForDeploymentTypeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidMinimumHealthyHostValueException").withModeledClass(
                                InvalidMinimumHealthyHostValueException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("BatchLimitExceededException").withModeledClass(
                                BatchLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ApplicationDoesNotExistException").withModeledClass(
                                ApplicationDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidTargetInstancesException").withModeledClass(
                                InvalidTargetInstancesException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("TagRequiredException").withModeledClass(
                                TagRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("BucketNameFilterRequiredException").withModeledClass(
                                BucketNameFilterRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidIamUserArnException").withModeledClass(
                                InvalidIamUserArnException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidInstanceTypeException").withModeledClass(
                                InvalidInstanceTypeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidTriggerConfigException").withModeledClass(
                                InvalidTriggerConfigException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("IamArnRequiredException").withModeledClass(
                                IamArnRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidKeyPrefixFilterException").withModeledClass(
                                InvalidKeyPrefixFilterException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidBucketNameFilterException").withModeledClass(
                                InvalidBucketNameFilterException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("RoleRequiredException").withModeledClass(
                                RoleRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentNotStartedException").withModeledClass(
                                DeploymentNotStartedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidIamSessionArnException").withModeledClass(
                                InvalidIamSessionArnException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentGroupAlreadyExistsException").withModeledClass(
                                DeploymentGroupAlreadyExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InstanceNameRequiredException").withModeledClass(
                                InstanceNameRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentConfigLimitExceededException").withModeledClass(
                                DeploymentConfigLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidRevisionException").withModeledClass(
                                InvalidRevisionException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("IamUserArnRequiredException").withModeledClass(
                                IamUserArnRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeploymentIdException").withModeledClass(
                                InvalidDeploymentIdException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeploymentStatusException").withModeledClass(
                                InvalidDeploymentStatusException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidInstanceNameException").withModeledClass(
                                InvalidInstanceNameException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentConfigInUseException").withModeledClass(
                                DeploymentConfigInUseException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentConfigAlreadyExistsException").withModeledClass(
                                DeploymentConfigAlreadyExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("IamSessionArnAlreadyRegisteredException").withModeledClass(
                                IamSessionArnAlreadyRegisteredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InstanceNameAlreadyRegisteredException").withModeledClass(
                                InstanceNameAlreadyRegisteredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidTagException").withModeledClass(
                                InvalidTagException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidApplicationNameException").withModeledClass(
                                InvalidApplicationNameException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeploymentStyleException").withModeledClass(
                                InvalidDeploymentStyleException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidTimeRangeException").withModeledClass(
                                InvalidTimeRangeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidSortByException").withModeledClass(
                                InvalidSortByException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeploymentInstanceTypeException").withModeledClass(
                                InvalidDeploymentInstanceTypeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidEC2TagException").withModeledClass(
                                InvalidEC2TagException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentDoesNotExistException").withModeledClass(
                                DeploymentDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidSortOrderException").withModeledClass(
                                InvalidSortOrderException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DeploymentGroupNameRequiredException").withModeledClass(
                                DeploymentGroupNameRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("RevisionDoesNotExistException").withModeledClass(
                                RevisionDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidRoleException").withModeledClass(
                                InvalidRoleException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InstanceIdRequiredException").withModeledClass(
                                InstanceIdRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidFileExistsBehaviorException").withModeledClass(
                                InvalidFileExistsBehaviorException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("TagLimitExceededException").withModeledClass(
                                TagLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidAutoScalingGroupException").withModeledClass(
                                InvalidAutoScalingGroupException.class)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}
