/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy;

import javax.annotation.Generated;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.AlarmsLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ApplicationNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.BucketNameFilterRequiredException;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployException;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.DeploymentAlreadyCompletedException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigInUseException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupAlreadyExistsException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentIdRequiredException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentIsNotInReadyStateException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.DeploymentNotStartedException;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.DescriptionTooLongException;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.IamArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.IamSessionArnAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.IamUserArnAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.IamUserArnRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.InstanceIdRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameAlreadyRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameRequiredException;
import software.amazon.awssdk.services.codedeploy.model.InstanceNotRegisteredException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAlarmConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidApplicationNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAutoRollbackConfigException;
import software.amazon.awssdk.services.codedeploy.model.InvalidAutoScalingGroupException;
import software.amazon.awssdk.services.codedeploy.model.InvalidBlueGreenDeploymentConfigurationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidBucketNameFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeployedStateFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentConfigNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentGroupNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentIdException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentInstanceTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidDeploymentStyleException;
import software.amazon.awssdk.services.codedeploy.model.InvalidEC2TagException;
import software.amazon.awssdk.services.codedeploy.model.InvalidFileExistsBehaviorException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIamSessionArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidIamUserArnException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceNameException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidInstanceTypeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidKeyPrefixFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidLoadBalancerInfoException;
import software.amazon.awssdk.services.codedeploy.model.InvalidMinimumHealthyHostValueException;
import software.amazon.awssdk.services.codedeploy.model.InvalidNextTokenException;
import software.amazon.awssdk.services.codedeploy.model.InvalidOperationException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRegistrationStatusException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRevisionException;
import software.amazon.awssdk.services.codedeploy.model.InvalidRoleException;
import software.amazon.awssdk.services.codedeploy.model.InvalidSortByException;
import software.amazon.awssdk.services.codedeploy.model.InvalidSortOrderException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTagFilterException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTargetInstancesException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.codedeploy.model.InvalidTriggerConfigException;
import software.amazon.awssdk.services.codedeploy.model.LifecycleHookLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.MultipleIamArnsProvidedException;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ResourceValidationException;
import software.amazon.awssdk.services.codedeploy.model.RevisionDoesNotExistException;
import software.amazon.awssdk.services.codedeploy.model.RevisionRequiredException;
import software.amazon.awssdk.services.codedeploy.model.RoleRequiredException;
import software.amazon.awssdk.services.codedeploy.model.SkipWaitTimeForInstanceTerminationRequest;
import software.amazon.awssdk.services.codedeploy.model.SkipWaitTimeForInstanceTerminationResponse;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.TagLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.TagRequiredException;
import software.amazon.awssdk.services.codedeploy.model.TriggerTargetsLimitExceededException;
import software.amazon.awssdk.services.codedeploy.model.UnsupportedActionForDeploymentTypeException;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.waiters.CodeDeployClientWaiters;

/**
 * Service client for accessing CodeDeploy. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS CodeDeploy</fullname>
 * <p>
 * AWS CodeDeploy is a deployment service that automates application deployments to Amazon EC2 instances or on-premises
 * instances running in your own facility.
 * </p>
 * <p>
 * You can deploy a nearly unlimited variety of application content, such as code, web and configuration files,
 * executables, packages, scripts, multimedia files, and so on. AWS CodeDeploy can deploy application content stored in
 * Amazon S3 buckets, GitHub repositories, or Bitbucket repositories. You do not need to make changes to your existing
 * code before you can use AWS CodeDeploy.
 * </p>
 * <p>
 * AWS CodeDeploy makes it easier for you to rapidly release new features, helps you avoid downtime during application
 * deployment, and handles the complexity of updating your applications, without many of the risks associated with
 * error-prone manual deployments.
 * </p>
 * <p>
 * <b>AWS CodeDeploy Components</b>
 * </p>
 * <p>
 * Use the information in this guide to help you work with the following AWS CodeDeploy components:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Application</b>: A name that uniquely identifies the application you want to deploy. AWS CodeDeploy uses this
 * name, which functions as a container, to ensure the correct combination of revision, deployment configuration, and
 * deployment group are referenced during a deployment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Deployment group</b>: A set of individual instances. A deployment group contains individually tagged instances,
 * Amazon EC2 instances in Auto Scaling groups, or both.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Deployment configuration</b>: A set of deployment rules and deployment success and failure conditions used by AWS
 * CodeDeploy during a deployment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Deployment</b>: The process, and the components involved in the process, of installing content on one or more
 * instances.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Application revisions</b>: An archive file containing source content—source code, web pages, executable files, and
 * deployment scripts—along with an application specification file (AppSpec file). Revisions are stored in Amazon S3
 * buckets or GitHub repositories. For Amazon S3, a revision is uniquely identified by its Amazon S3 object key and its
 * ETag, version, or both. For GitHub, a revision is uniquely identified by its commit ID.
 * </p>
 * </li>
 * </ul>
 * <p>
 * This guide also contains information to help you get details about the instances in your deployments and to make
 * on-premises instances available for AWS CodeDeploy deployments.
 * </p>
 * <p>
 * <b>AWS CodeDeploy Information Resources</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy User Guide</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="http://docs.aws.amazon.com/codedeploy/latest/APIReference/">AWS CodeDeploy API Reference Guide</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="http://docs.aws.amazon.com/cli/latest/reference/deploy/index.html">AWS CLI Reference for AWS CodeDeploy</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://forums.aws.amazon.com/forum.jspa?forumID=179">AWS CodeDeploy Developer Forum</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public interface CodeDeployClient extends AutoCloseable {
    String SERVICE_NAME = "codedeploy";

    /**
     * Create a {@link CodeDeployClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.DefaultCredentialsProvider}.
     */
    static CodeDeployClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodeDeployClient}.
     */
    static CodeDeployClientBuilder builder() {
        return new DefaultCodeDeployClientBuilder();
    }

    /**
     * <p>
     * Adds tags to on-premises instances.
     * </p>
     * 
     * @param addTagsToOnPremisesInstancesRequest
     *        Represents the input of, and adds tags to, an on-premises instance operation.
     * @return Result of the AddTagsToOnPremisesInstances operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws TagRequiredException
     *         A tag was not specified.
     * @throws InvalidTagException
     *         The specified tag was specified in an invalid format.
     * @throws TagLimitExceededException
     *         The maximum allowed number of tags was exceeded.
     * @throws InstanceLimitExceededException
     *         The maximum number of allowed on-premises instances in a single call was exceeded.
     * @throws InstanceNotRegisteredException
     *         The specified on-premises instance is not registered.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.AddTagsToOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/AddTagsToOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default AddTagsToOnPremisesInstancesResponse addTagsToOnPremisesInstances(
            AddTagsToOnPremisesInstancesRequest addTagsToOnPremisesInstancesRequest) throws InstanceNameRequiredException,
            TagRequiredException, InvalidTagException, TagLimitExceededException, InstanceLimitExceededException,
            InstanceNotRegisteredException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more application revisions.
     * </p>
     * 
     * @param batchGetApplicationRevisionsRequest
     *        Represents the input of a BatchGetApplicationRevisions operation.
     * @return Result of the BatchGetApplicationRevisions operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.BatchGetApplicationRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetApplicationRevisionsResponse batchGetApplicationRevisions(
            BatchGetApplicationRevisionsRequest batchGetApplicationRevisionsRequest) throws ApplicationDoesNotExistException,
            ApplicationNameRequiredException, InvalidApplicationNameException, RevisionRequiredException,
            InvalidRevisionException, BatchLimitExceededException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more applications.
     * </p>
     * 
     * @param batchGetApplicationsRequest
     *        Represents the input of a BatchGetApplications operation.
     * @return Result of the BatchGetApplications operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.BatchGetApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetApplicationsResponse batchGetApplications(BatchGetApplicationsRequest batchGetApplicationsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            BatchLimitExceededException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more deployment groups.
     * </p>
     * 
     * @param batchGetDeploymentGroupsRequest
     *        Represents the input of a BatchGetDeploymentGroups operation.
     * @return Result of the BatchGetDeploymentGroups operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.BatchGetDeploymentGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetDeploymentGroupsResponse batchGetDeploymentGroups(
            BatchGetDeploymentGroupsRequest batchGetDeploymentGroupsRequest) throws ApplicationNameRequiredException,
            InvalidApplicationNameException, ApplicationDoesNotExistException, DeploymentGroupNameRequiredException,
            InvalidDeploymentGroupNameException, BatchLimitExceededException, SdkBaseException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more instance that are part of a deployment group.
     * </p>
     * 
     * @param batchGetDeploymentInstancesRequest
     *        Represents the input of a BatchGetDeploymentInstances operation.
     * @return Result of the BatchGetDeploymentInstances operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment does not exist with the applicable IAM user or AWS account.
     * @throws InstanceIdRequiredException
     *         The instance ID was not specified.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws InvalidInstanceNameException
     *         The specified on-premises instance name was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.BatchGetDeploymentInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetDeploymentInstancesResponse batchGetDeploymentInstances(
            BatchGetDeploymentInstancesRequest batchGetDeploymentInstancesRequest) throws DeploymentIdRequiredException,
            DeploymentDoesNotExistException, InstanceIdRequiredException, InvalidDeploymentIdException,
            InvalidInstanceNameException, BatchLimitExceededException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more deployments.
     * </p>
     * 
     * @param batchGetDeploymentsRequest
     *        Represents the input of a BatchGetDeployments operation.
     * @return Result of the BatchGetDeployments operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.BatchGetDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchGetDeploymentsResponse batchGetDeployments(BatchGetDeploymentsRequest batchGetDeploymentsRequest)
            throws DeploymentIdRequiredException, InvalidDeploymentIdException, BatchLimitExceededException, SdkBaseException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more on-premises instances.
     * </p>
     * 
     * @param batchGetOnPremisesInstancesRequest
     *        Represents the input of a BatchGetOnPremisesInstances operation.
     * @return Result of the BatchGetOnPremisesInstances operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The specified on-premises instance name was specified in an invalid format.
     * @throws BatchLimitExceededException
     *         The maximum number of names or IDs allowed for this request (100) was exceeded.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.BatchGetOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetOnPremisesInstancesResponse batchGetOnPremisesInstances(
            BatchGetOnPremisesInstancesRequest batchGetOnPremisesInstancesRequest) throws InstanceNameRequiredException,
            InvalidInstanceNameException, BatchLimitExceededException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment
     * to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic
     * rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can
     * start as soon as all instances have a status of Ready.)
     * </p>
     * 
     * @param continueDeploymentRequest
     * @return Result of the ContinueDeployment operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentAlreadyCompletedException
     *         The deployment is already complete.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentIsNotInReadyStateException
     *         The deployment does not have a status of Ready and can't continue yet.
     * @throws UnsupportedActionForDeploymentTypeException
     *         A call was submitted that is not supported for the specified deployment type.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ContinueDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ContinueDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default ContinueDeploymentResponse continueDeployment(ContinueDeploymentRequest continueDeploymentRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentAlreadyCompletedException,
            InvalidDeploymentIdException, DeploymentIsNotInReadyStateException, UnsupportedActionForDeploymentTypeException,
            SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     * 
     * @param createApplicationRequest
     *        Represents the input of a CreateApplication operation.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationAlreadyExistsException
     *         An application with the specified name already exists with the applicable IAM user or AWS account.
     * @throws ApplicationLimitExceededException
     *         More applications were attempted to be created than are allowed.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.CreateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationAlreadyExistsException,
            ApplicationLimitExceededException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploys an application revision through the specified deployment group.
     * </p>
     * 
     * @param createDeploymentRequest
     *        Represents the input of a CreateDeployment operation.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group does not exist with the applicable IAM user or AWS account.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws RevisionDoesNotExistException
     *         The named revision does not exist with the applicable IAM user or AWS account.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the applicable IAM user or AWS account.
     * @throws DescriptionTooLongException
     *         The description is too long.
     * @throws DeploymentLimitExceededException
     *         The number of allowed deployments was exceeded.
     * @throws InvalidTargetInstancesException
     *         The target instance configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Configuration data for target instances was entered for an in-place deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The limit of 10 tags for a tag type was exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The combined length of the tag names exceeded the limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A specified tag is not currently applied to any instances.
     *         </p>
     *         </li>
     * @throws InvalidAutoRollbackConfigException
     *         The automatic rollback configuration was specified in an invalid format. For example, automatic rollback
     *         is enabled but an invalid triggering event type or no event types were listed.
     * @throws InvalidLoadBalancerInfoException
     *         An invalid load balancer name, or no load balancer name, was specified.
     * @throws InvalidFileExistsBehaviorException
     *         An invalid fileExistsBehavior option was specified to determine how AWS CodeDeploy handles files or
     *         directories that already exist in a deployment target location but weren't part of the previous
     *         successful deployment. Valid values include "DISALLOW", "OVERWRITE", and "RETAIN".
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.CreateDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException,
            RevisionRequiredException, RevisionDoesNotExistException, InvalidRevisionException,
            InvalidDeploymentConfigNameException, DeploymentConfigDoesNotExistException, DescriptionTooLongException,
            DeploymentLimitExceededException, InvalidTargetInstancesException, InvalidAutoRollbackConfigException,
            InvalidLoadBalancerInfoException, InvalidFileExistsBehaviorException, SdkBaseException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a deployment configuration.
     * </p>
     * 
     * @param createDeploymentConfigRequest
     *        Represents the input of a CreateDeploymentConfig operation.
     * @return Result of the CreateDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigAlreadyExistsException
     *         A deployment configuration with the specified name already exists with the applicable IAM user or AWS
     *         account.
     * @throws InvalidMinimumHealthyHostValueException
     *         The minimum healthy instance value was specified in an invalid format.
     * @throws DeploymentConfigLimitExceededException
     *         The deployment configurations limit was exceeded.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.CreateDeploymentConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeploymentConfigResponse createDeploymentConfig(CreateDeploymentConfigRequest createDeploymentConfigRequest)
            throws InvalidDeploymentConfigNameException, DeploymentConfigNameRequiredException,
            DeploymentConfigAlreadyExistsException, InvalidMinimumHealthyHostValueException,
            DeploymentConfigLimitExceededException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a deployment group to which application revisions will be deployed.
     * </p>
     * 
     * @param createDeploymentGroupRequest
     *        Represents the input of a CreateDeploymentGroup operation.
     * @return Result of the CreateDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupAlreadyExistsException
     *         A deployment group with the specified name already exists with the applicable IAM user or AWS account.
     * @throws InvalidEC2TagException
     *         The tag was specified in an invalid format.
     * @throws InvalidTagException
     *         The specified tag was specified in an invalid format.
     * @throws InvalidAutoScalingGroupException
     *         The Auto Scaling group was specified in an invalid format or does not exist.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the applicable IAM user or AWS account.
     * @throws RoleRequiredException
     *         The role ID was not specified.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Auto Scaling.
     * @throws DeploymentGroupLimitExceededException
     *         The deployment groups limit was exceeded.
     * @throws LifecycleHookLimitExceededException
     *         The limit for lifecycle hooks was exceeded.
     * @throws InvalidTriggerConfigException
     *         The trigger was specified in an invalid format.
     * @throws TriggerTargetsLimitExceededException
     *         The maximum allowed number of triggers was exceeded.
     * @throws InvalidAlarmConfigException
     *         The format of the alarm configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the 255 character limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled but the alarm list is empty.
     *         </p>
     *         </li>
     * @throws AlarmsLimitExceededException
     *         The maximum number of alarms for a deployment group (10) was exceeded.
     * @throws InvalidAutoRollbackConfigException
     *         The automatic rollback configuration was specified in an invalid format. For example, automatic rollback
     *         is enabled but an invalid triggering event type or no event types were listed.
     * @throws InvalidLoadBalancerInfoException
     *         An invalid load balancer name, or no load balancer name, was specified.
     * @throws InvalidDeploymentStyleException
     *         An invalid deployment style was specified. Valid deployment types include "IN_PLACE" and "BLUE_GREEN".
     *         Valid deployment options include "WITH_TRAFFIC_CONTROL" and "WITHOUT_TRAFFIC_CONTROL".
     * @throws InvalidBlueGreenDeploymentConfigurationException
     *         The configuration for the blue/green deployment group was provided in an invalid format. For information
     *         about deployment configuration format, see <a>CreateDeploymentConfig</a>.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.CreateDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeploymentGroupResponse createDeploymentGroup(CreateDeploymentGroupRequest createDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, DeploymentGroupAlreadyExistsException,
            InvalidEC2TagException, InvalidTagException, InvalidAutoScalingGroupException, InvalidDeploymentConfigNameException,
            DeploymentConfigDoesNotExistException, RoleRequiredException, InvalidRoleException,
            DeploymentGroupLimitExceededException, LifecycleHookLimitExceededException, InvalidTriggerConfigException,
            TriggerTargetsLimitExceededException, InvalidAlarmConfigException, AlarmsLimitExceededException,
            InvalidAutoRollbackConfigException, InvalidLoadBalancerInfoException, InvalidDeploymentStyleException,
            InvalidBlueGreenDeploymentConfigurationException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     * 
     * @param deleteApplicationRequest
     *        Represents the input of a DeleteApplication operation.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.DeleteApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, SdkBaseException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a deployment configuration.
     * </p>
     * <note>
     * <p>
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be
     * deleted.
     * </p>
     * </note>
     * 
     * @param deleteDeploymentConfigRequest
     *        Represents the input of a DeleteDeploymentConfig operation.
     * @return Result of the DeleteDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigInUseException
     *         The deployment configuration is still in use.
     * @throws InvalidOperationException
     *         An invalid operation was detected.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.DeleteDeploymentConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeploymentConfigResponse deleteDeploymentConfig(DeleteDeploymentConfigRequest deleteDeploymentConfigRequest)
            throws InvalidDeploymentConfigNameException, DeploymentConfigNameRequiredException, DeploymentConfigInUseException,
            InvalidOperationException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a deployment group.
     * </p>
     * 
     * @param deleteDeploymentGroupRequest
     *        Represents the input of a DeleteDeploymentGroup operation.
     * @return Result of the DeleteDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Auto Scaling.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.DeleteDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeploymentGroupResponse deleteDeploymentGroup(DeleteDeploymentGroupRequest deleteDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, DeploymentGroupNameRequiredException,
            InvalidDeploymentGroupNameException, InvalidRoleException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters an on-premises instance.
     * </p>
     * 
     * @param deregisterOnPremisesInstanceRequest
     *        Represents the input of a DeregisterOnPremisesInstance operation.
     * @return Result of the DeregisterOnPremisesInstance operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InvalidInstanceNameException
     *         The specified on-premises instance name was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.DeregisterOnPremisesInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeregisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterOnPremisesInstanceResponse deregisterOnPremisesInstance(
            DeregisterOnPremisesInstanceRequest deregisterOnPremisesInstanceRequest) throws InstanceNameRequiredException,
            InvalidInstanceNameException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an application.
     * </p>
     * 
     * @param getApplicationRequest
     *        Represents the input of a GetApplication operation.
     * @return Result of the GetApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.GetApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default GetApplicationResponse getApplication(GetApplicationRequest getApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an application revision.
     * </p>
     * 
     * @param getApplicationRevisionRequest
     *        Represents the input of a GetApplicationRevision operation.
     * @return Result of the GetApplicationRevision operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws RevisionDoesNotExistException
     *         The named revision does not exist with the applicable IAM user or AWS account.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.GetApplicationRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationRevisionResponse getApplicationRevision(GetApplicationRevisionRequest getApplicationRevisionRequest)
            throws ApplicationDoesNotExistException, ApplicationNameRequiredException, InvalidApplicationNameException,
            RevisionDoesNotExistException, RevisionRequiredException, InvalidRevisionException, SdkBaseException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a deployment.
     * </p>
     * 
     * @param getDeploymentRequest
     *        Represents the input of a GetDeployment operation.
     * @return Result of the GetDeployment operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentDoesNotExistException
     *         The deployment does not exist with the applicable IAM user or AWS account.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.GetDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDeploymentResponse getDeployment(GetDeploymentRequest getDeploymentRequest) throws DeploymentIdRequiredException,
            InvalidDeploymentIdException, DeploymentDoesNotExistException, SdkBaseException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a deployment configuration.
     * </p>
     * 
     * @param getDeploymentConfigRequest
     *        Represents the input of a GetDeploymentConfig operation.
     * @return Result of the GetDeploymentConfig operation returned by the service.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigNameRequiredException
     *         The deployment configuration name was not specified.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the applicable IAM user or AWS account.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.GetDeploymentConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDeploymentConfigResponse getDeploymentConfig(GetDeploymentConfigRequest getDeploymentConfigRequest)
            throws InvalidDeploymentConfigNameException, DeploymentConfigNameRequiredException,
            DeploymentConfigDoesNotExistException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a deployment group.
     * </p>
     * 
     * @param getDeploymentGroupRequest
     *        Represents the input of a GetDeploymentGroup operation.
     * @return Result of the GetDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group does not exist with the applicable IAM user or AWS account.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.GetDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDeploymentGroupResponse getDeploymentGroup(GetDeploymentGroupRequest getDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            DeploymentGroupNameRequiredException, InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException,
            SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an instance as part of a deployment.
     * </p>
     * 
     * @param getDeploymentInstanceRequest
     *        Represents the input of a GetDeploymentInstance operation.
     * @return Result of the GetDeploymentInstance operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment does not exist with the applicable IAM user or AWS account.
     * @throws InstanceIdRequiredException
     *         The instance ID was not specified.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws InstanceDoesNotExistException
     *         The specified instance does not exist in the deployment group.
     * @throws InvalidInstanceNameException
     *         The specified on-premises instance name was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.GetDeploymentInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeploymentInstanceResponse getDeploymentInstance(GetDeploymentInstanceRequest getDeploymentInstanceRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, InstanceIdRequiredException,
            InvalidDeploymentIdException, InstanceDoesNotExistException, InvalidInstanceNameException, SdkBaseException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an on-premises instance.
     * </p>
     * 
     * @param getOnPremisesInstanceRequest
     *        Represents the input of a GetOnPremisesInstance operation.
     * @return Result of the GetOnPremisesInstance operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws InstanceNotRegisteredException
     *         The specified on-premises instance is not registered.
     * @throws InvalidInstanceNameException
     *         The specified on-premises instance name was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.GetOnPremisesInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOnPremisesInstanceResponse getOnPremisesInstance(GetOnPremisesInstanceRequest getOnPremisesInstanceRequest)
            throws InstanceNameRequiredException, InstanceNotRegisteredException, InvalidInstanceNameException, SdkBaseException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     * 
     * @param listApplicationRevisionsRequest
     *        Represents the input of a ListApplicationRevisions operation.
     * @return Result of the ListApplicationRevisions operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws InvalidSortByException
     *         The column name to sort by is either not present or was specified in an invalid format.
     * @throws InvalidSortOrderException
     *         The sort order was specified in an invalid format.
     * @throws InvalidBucketNameFilterException
     *         The bucket name either doesn't exist or was specified in an invalid format.
     * @throws InvalidKeyPrefixFilterException
     *         The specified key prefix filter was specified in an invalid format.
     * @throws BucketNameFilterRequiredException
     *         A bucket name is required, but was not provided.
     * @throws InvalidDeployedStateFilterException
     *         The deployed state filter was specified in an invalid format.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListApplicationRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationRevisionsResponse listApplicationRevisions(
            ListApplicationRevisionsRequest listApplicationRevisionsRequest) throws ApplicationDoesNotExistException,
            ApplicationNameRequiredException, InvalidApplicationNameException, InvalidSortByException, InvalidSortOrderException,
            InvalidBucketNameFilterException, InvalidKeyPrefixFilterException, BucketNameFilterRequiredException,
            InvalidDeployedStateFilterException, InvalidNextTokenException, SdkBaseException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the applications registered with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listApplicationsRequest
     *        Represents the input of a ListApplications operation.
     * @return Result of the ListApplications operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest)
            throws InvalidNextTokenException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployment configurations with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listDeploymentConfigsRequest
     *        Represents the input of a ListDeploymentConfigs operation.
     * @return Result of the ListDeploymentConfigs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListDeploymentConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentConfigsResponse listDeploymentConfigs(ListDeploymentConfigsRequest listDeploymentConfigsRequest)
            throws InvalidNextTokenException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployment groups for an application registered with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listDeploymentGroupsRequest
     *        Represents the input of a ListDeploymentGroups operation.
     * @return Result of the ListDeploymentGroups operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListDeploymentGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentGroupsResponse listDeploymentGroups(ListDeploymentGroupsRequest listDeploymentGroupsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            InvalidNextTokenException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the instance for a deployment associated with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listDeploymentInstancesRequest
     *        Represents the input of a ListDeploymentInstances operation.
     * @return Result of the ListDeploymentInstances operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentNotStartedException
     *         The specified deployment has not started.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws InvalidInstanceStatusException
     *         The specified instance status does not exist.
     * @throws InvalidInstanceTypeException
     *         An invalid instance type was specified for instances in a blue/green deployment. Valid values include
     *         "Blue" for an original environment and "Green" for a replacement environment.
     * @throws InvalidDeploymentInstanceTypeException
     *         An instance type was specified for an in-place deployment. Instance types are supported for blue/green
     *         deployments only.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListDeploymentInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentInstancesResponse listDeploymentInstances(ListDeploymentInstancesRequest listDeploymentInstancesRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentNotStartedException,
            InvalidNextTokenException, InvalidDeploymentIdException, InvalidInstanceStatusException,
            InvalidInstanceTypeException, InvalidDeploymentInstanceTypeException, SdkBaseException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the applicable IAM user or AWS
     * account.
     * </p>
     * 
     * @param listDeploymentsRequest
     *        Represents the input of a ListDeployments operation.
     * @return Result of the ListDeployments operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws InvalidTimeRangeException
     *         The specified time range was specified in an invalid format.
     * @throws InvalidDeploymentStatusException
     *         The specified deployment status doesn't exist or cannot be determined.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDeploymentsResponse listDeployments(ListDeploymentsRequest listDeploymentsRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            InvalidDeploymentGroupNameException, DeploymentGroupDoesNotExistException, DeploymentGroupNameRequiredException,
            InvalidTimeRangeException, InvalidDeploymentStatusException, InvalidNextTokenException, SdkBaseException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the names of stored connections to GitHub accounts.
     * </p>
     * 
     * @param listGitHubAccountTokenNamesRequest
     *        Represents the input of a ListGitHubAccountTokenNames operation.
     * @return Result of the ListGitHubAccountTokenNames operation returned by the service.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws ResourceValidationException
     *         The specified resource could not be validated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListGitHubAccountTokenNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListGitHubAccountTokenNames"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGitHubAccountTokenNamesResponse listGitHubAccountTokenNames(
            ListGitHubAccountTokenNamesRequest listGitHubAccountTokenNamesRequest) throws InvalidNextTokenException,
            ResourceValidationException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of names for one or more on-premises instances.
     * </p>
     * <p>
     * Unless otherwise specified, both registered and deregistered on-premises instance names will be listed. To list
     * only registered or deregistered on-premises instance names, use the registration status parameter.
     * </p>
     * 
     * @param listOnPremisesInstancesRequest
     *        Represents the input of a ListOnPremisesInstances operation.
     * @return Result of the ListOnPremisesInstances operation returned by the service.
     * @throws InvalidRegistrationStatusException
     *         The registration status was specified in an invalid format.
     * @throws InvalidTagFilterException
     *         The specified tag filter was specified in an invalid format.
     * @throws InvalidNextTokenException
     *         The next token was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.ListOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOnPremisesInstancesResponse listOnPremisesInstances(ListOnPremisesInstancesRequest listOnPremisesInstancesRequest)
            throws InvalidRegistrationStatusException, InvalidTagFilterException, InvalidNextTokenException, SdkBaseException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers with AWS CodeDeploy a revision for the specified application.
     * </p>
     * 
     * @param registerApplicationRevisionRequest
     *        Represents the input of a RegisterApplicationRevision operation.
     * @return Result of the RegisterApplicationRevision operation returned by the service.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws DescriptionTooLongException
     *         The description is too long.
     * @throws RevisionRequiredException
     *         The revision ID was not specified.
     * @throws InvalidRevisionException
     *         The revision was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.RegisterApplicationRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterApplicationRevisionResponse registerApplicationRevision(
            RegisterApplicationRevisionRequest registerApplicationRevisionRequest) throws ApplicationDoesNotExistException,
            ApplicationNameRequiredException, InvalidApplicationNameException, DescriptionTooLongException,
            RevisionRequiredException, InvalidRevisionException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an on-premises instance.
     * </p>
     * <note>
     * <p>
     * Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.
     * </p>
     * </note>
     * 
     * @param registerOnPremisesInstanceRequest
     *        Represents the input of the register on-premises instance operation.
     * @return Result of the RegisterOnPremisesInstance operation returned by the service.
     * @throws InstanceNameAlreadyRegisteredException
     *         The specified on-premises instance name is already registered.
     * @throws IamArnRequiredException
     *         No IAM ARN was included in the request. You must use an IAM session ARN or IAM user ARN in the request.
     * @throws IamSessionArnAlreadyRegisteredException
     *         The request included an IAM session ARN that has already been used to register a different instance.
     * @throws IamUserArnAlreadyRegisteredException
     *         The specified IAM user ARN is already registered with an on-premises instance.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws IamUserArnRequiredException
     *         An IAM user ARN was not specified.
     * @throws InvalidInstanceNameException
     *         The specified on-premises instance name was specified in an invalid format.
     * @throws InvalidIamSessionArnException
     *         The IAM session ARN was specified in an invalid format.
     * @throws InvalidIamUserArnException
     *         The IAM user ARN was specified in an invalid format.
     * @throws MultipleIamArnsProvidedException
     *         Both an IAM user ARN and an IAM session ARN were included in the request. Use only one ARN type.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.RegisterOnPremisesInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterOnPremisesInstanceResponse registerOnPremisesInstance(
            RegisterOnPremisesInstanceRequest registerOnPremisesInstanceRequest) throws InstanceNameAlreadyRegisteredException,
            IamArnRequiredException, IamSessionArnAlreadyRegisteredException, IamUserArnAlreadyRegisteredException,
            InstanceNameRequiredException, IamUserArnRequiredException, InvalidInstanceNameException,
            InvalidIamSessionArnException, InvalidIamUserArnException, MultipleIamArnsProvidedException, SdkBaseException,
            SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from one or more on-premises instances.
     * </p>
     * 
     * @param removeTagsFromOnPremisesInstancesRequest
     *        Represents the input of a RemoveTagsFromOnPremisesInstances operation.
     * @return Result of the RemoveTagsFromOnPremisesInstances operation returned by the service.
     * @throws InstanceNameRequiredException
     *         An on-premises instance name was not specified.
     * @throws TagRequiredException
     *         A tag was not specified.
     * @throws InvalidTagException
     *         The specified tag was specified in an invalid format.
     * @throws TagLimitExceededException
     *         The maximum allowed number of tags was exceeded.
     * @throws InstanceLimitExceededException
     *         The maximum number of allowed on-premises instances in a single call was exceeded.
     * @throws InstanceNotRegisteredException
     *         The specified on-premises instance is not registered.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.RemoveTagsFromOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RemoveTagsFromOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveTagsFromOnPremisesInstancesResponse removeTagsFromOnPremisesInstances(
            RemoveTagsFromOnPremisesInstancesRequest removeTagsFromOnPremisesInstancesRequest)
            throws InstanceNameRequiredException, TagRequiredException, InvalidTagException, TagLimitExceededException,
            InstanceLimitExceededException, InstanceNotRegisteredException, SdkBaseException, SdkClientException,
            CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after
     * the traffic routing is completed.
     * </p>
     * 
     * @param skipWaitTimeForInstanceTerminationRequest
     * @return Result of the SkipWaitTimeForInstanceTermination operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentAlreadyCompletedException
     *         The deployment is already complete.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws DeploymentNotStartedException
     *         The specified deployment has not started.
     * @throws UnsupportedActionForDeploymentTypeException
     *         A call was submitted that is not supported for the specified deployment type.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.SkipWaitTimeForInstanceTermination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/SkipWaitTimeForInstanceTermination"
     *      target="_top">AWS API Documentation</a>
     */
    default SkipWaitTimeForInstanceTerminationResponse skipWaitTimeForInstanceTermination(
            SkipWaitTimeForInstanceTerminationRequest skipWaitTimeForInstanceTerminationRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentAlreadyCompletedException,
            InvalidDeploymentIdException, DeploymentNotStartedException, UnsupportedActionForDeploymentTypeException,
            SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to stop an ongoing deployment.
     * </p>
     * 
     * @param stopDeploymentRequest
     *        Represents the input of a StopDeployment operation.
     * @return Result of the StopDeployment operation returned by the service.
     * @throws DeploymentIdRequiredException
     *         At least one deployment ID must be specified.
     * @throws DeploymentDoesNotExistException
     *         The deployment does not exist with the applicable IAM user or AWS account.
     * @throws DeploymentAlreadyCompletedException
     *         The deployment is already complete.
     * @throws InvalidDeploymentIdException
     *         At least one of the deployment IDs was specified in an invalid format.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.StopDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/StopDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default StopDeploymentResponse stopDeployment(StopDeploymentRequest stopDeploymentRequest)
            throws DeploymentIdRequiredException, DeploymentDoesNotExistException, DeploymentAlreadyCompletedException,
            InvalidDeploymentIdException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the name of an application.
     * </p>
     * 
     * @param updateApplicationRequest
     *        Represents the input of an UpdateApplication operation.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationAlreadyExistsException
     *         An application with the specified name already exists with the applicable IAM user or AWS account.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.UpdateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationAlreadyExistsException,
            ApplicationDoesNotExistException, SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about a deployment group.
     * </p>
     * 
     * @param updateDeploymentGroupRequest
     *        Represents the input of an UpdateDeploymentGroup operation.
     * @return Result of the UpdateDeploymentGroup operation returned by the service.
     * @throws ApplicationNameRequiredException
     *         The minimum number of required application names was not specified.
     * @throws InvalidApplicationNameException
     *         The application name was specified in an invalid format.
     * @throws ApplicationDoesNotExistException
     *         The application does not exist with the applicable IAM user or AWS account.
     * @throws InvalidDeploymentGroupNameException
     *         The deployment group name was specified in an invalid format.
     * @throws DeploymentGroupAlreadyExistsException
     *         A deployment group with the specified name already exists with the applicable IAM user or AWS account.
     * @throws DeploymentGroupNameRequiredException
     *         The deployment group name was not specified.
     * @throws DeploymentGroupDoesNotExistException
     *         The named deployment group does not exist with the applicable IAM user or AWS account.
     * @throws InvalidEC2TagException
     *         The tag was specified in an invalid format.
     * @throws InvalidTagException
     *         The specified tag was specified in an invalid format.
     * @throws InvalidAutoScalingGroupException
     *         The Auto Scaling group was specified in an invalid format or does not exist.
     * @throws InvalidDeploymentConfigNameException
     *         The deployment configuration name was specified in an invalid format.
     * @throws DeploymentConfigDoesNotExistException
     *         The deployment configuration does not exist with the applicable IAM user or AWS account.
     * @throws InvalidRoleException
     *         The service role ARN was specified in an invalid format. Or, if an Auto Scaling group was specified, the
     *         specified service role does not grant the appropriate permissions to Auto Scaling.
     * @throws LifecycleHookLimitExceededException
     *         The limit for lifecycle hooks was exceeded.
     * @throws InvalidTriggerConfigException
     *         The trigger was specified in an invalid format.
     * @throws TriggerTargetsLimitExceededException
     *         The maximum allowed number of triggers was exceeded.
     * @throws InvalidAlarmConfigException
     *         The format of the alarm configuration is invalid. Possible causes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the 255 character limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled but the alarm list is empty.
     *         </p>
     *         </li>
     * @throws AlarmsLimitExceededException
     *         The maximum number of alarms for a deployment group (10) was exceeded.
     * @throws InvalidAutoRollbackConfigException
     *         The automatic rollback configuration was specified in an invalid format. For example, automatic rollback
     *         is enabled but an invalid triggering event type or no event types were listed.
     * @throws InvalidLoadBalancerInfoException
     *         An invalid load balancer name, or no load balancer name, was specified.
     * @throws InvalidDeploymentStyleException
     *         An invalid deployment style was specified. Valid deployment types include "IN_PLACE" and "BLUE_GREEN".
     *         Valid deployment options include "WITH_TRAFFIC_CONTROL" and "WITHOUT_TRAFFIC_CONTROL".
     * @throws InvalidBlueGreenDeploymentConfigurationException
     *         The configuration for the blue/green deployment group was provided in an invalid format. For information
     *         about deployment configuration format, see <a>CreateDeploymentConfig</a>.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws CodeDeployException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample CodeDeployClient.UpdateDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDeploymentGroupResponse updateDeploymentGroup(UpdateDeploymentGroupRequest updateDeploymentGroupRequest)
            throws ApplicationNameRequiredException, InvalidApplicationNameException, ApplicationDoesNotExistException,
            InvalidDeploymentGroupNameException, DeploymentGroupAlreadyExistsException, DeploymentGroupNameRequiredException,
            DeploymentGroupDoesNotExistException, InvalidEC2TagException, InvalidTagException, InvalidAutoScalingGroupException,
            InvalidDeploymentConfigNameException, DeploymentConfigDoesNotExistException, InvalidRoleException,
            LifecycleHookLimitExceededException, InvalidTriggerConfigException, TriggerTargetsLimitExceededException,
            InvalidAlarmConfigException, AlarmsLimitExceededException, InvalidAutoRollbackConfigException,
            InvalidLoadBalancerInfoException, InvalidDeploymentStyleException, InvalidBlueGreenDeploymentConfigurationException,
            SdkBaseException, SdkClientException, CodeDeployException {
        throw new UnsupportedOperationException();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("codedeploy");
    }

    CodeDeployClientWaiters waiters();
}
