/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesResponse;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionResponse;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest;
import software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceResponse;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesResponse;
import software.amazon.awssdk.services.codedeploy.model.SkipWaitTimeForInstanceTerminationRequest;
import software.amazon.awssdk.services.codedeploy.model.SkipWaitTimeForInstanceTerminationResponse;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.StopDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest;
import software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupResponse;

/**
 * Service client for accessing CodeDeploy asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>AWS CodeDeploy</fullname>
 * <p>
 * AWS CodeDeploy is a deployment service that automates application deployments to Amazon EC2 instances or on-premises
 * instances running in your own facility.
 * </p>
 * <p>
 * You can deploy a nearly unlimited variety of application content, such as code, web and configuration files,
 * executables, packages, scripts, multimedia files, and so on. AWS CodeDeploy can deploy application content stored in
 * Amazon S3 buckets, GitHub repositories, or Bitbucket repositories. You do not need to make changes to your existing
 * code before you can use AWS CodeDeploy.
 * </p>
 * <p>
 * AWS CodeDeploy makes it easier for you to rapidly release new features, helps you avoid downtime during application
 * deployment, and handles the complexity of updating your applications, without many of the risks associated with
 * error-prone manual deployments.
 * </p>
 * <p>
 * <b>AWS CodeDeploy Components</b>
 * </p>
 * <p>
 * Use the information in this guide to help you work with the following AWS CodeDeploy components:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Application</b>: A name that uniquely identifies the application you want to deploy. AWS CodeDeploy uses this
 * name, which functions as a container, to ensure the correct combination of revision, deployment configuration, and
 * deployment group are referenced during a deployment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Deployment group</b>: A set of individual instances. A deployment group contains individually tagged instances,
 * Amazon EC2 instances in Auto Scaling groups, or both.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Deployment configuration</b>: A set of deployment rules and deployment success and failure conditions used by AWS
 * CodeDeploy during a deployment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Deployment</b>: The process, and the components involved in the process, of installing content on one or more
 * instances.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Application revisions</b>: An archive file containing source content—source code, web pages, executable files, and
 * deployment scripts—along with an application specification file (AppSpec file). Revisions are stored in Amazon S3
 * buckets or GitHub repositories. For Amazon S3, a revision is uniquely identified by its Amazon S3 object key and its
 * ETag, version, or both. For GitHub, a revision is uniquely identified by its commit ID.
 * </p>
 * </li>
 * </ul>
 * <p>
 * This guide also contains information to help you get details about the instances in your deployments and to make
 * on-premises instances available for AWS CodeDeploy deployments.
 * </p>
 * <p>
 * <b>AWS CodeDeploy Information Resources</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="http://docs.aws.amazon.com/codedeploy/latest/userguide">AWS CodeDeploy User Guide</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="http://docs.aws.amazon.com/codedeploy/latest/APIReference/">AWS CodeDeploy API Reference Guide</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="http://docs.aws.amazon.com/cli/latest/reference/deploy/index.html">AWS CLI Reference for AWS CodeDeploy</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://forums.aws.amazon.com/forum.jspa?forumID=179">AWS CodeDeploy Developer Forum</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public interface CodeDeployAsyncClient extends AutoCloseable {
    /**
     * Create a {@link CodeDeployAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.DefaultCredentialsProvider}.
     */
    static CodeDeployAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodeDeployAsyncClient}.
     */
    static CodeDeployAsyncClientBuilder builder() {
        return new DefaultCodeDeployAsyncClientBuilder();
    }

    /**
     * <p>
     * Adds tags to on-premises instances.
     * </p>
     * 
     * @param addTagsToOnPremisesInstancesRequest
     *        Represents the input of, and adds tags to, an on-premises instance operation.
     * @return A Java Future containing the result of the AddTagsToOnPremisesInstances operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagException The specified tag was specified in an invalid format.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>InstanceLimitExceededException The maximum number of allowed on-premises instances in a single call
     *         was exceeded.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.AddTagsToOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/AddTagsToOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddTagsToOnPremisesInstancesResponse> addTagsToOnPremisesInstances(
            AddTagsToOnPremisesInstancesRequest addTagsToOnPremisesInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more application revisions.
     * </p>
     * 
     * @param batchGetApplicationRevisionsRequest
     *        Represents the input of a BatchGetApplicationRevisions operation.
     * @return A Java Future containing the result of the BatchGetApplicationRevisions operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.BatchGetApplicationRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetApplicationRevisionsResponse> batchGetApplicationRevisions(
            BatchGetApplicationRevisionsRequest batchGetApplicationRevisionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more applications.
     * </p>
     * 
     * @param batchGetApplicationsRequest
     *        Represents the input of a BatchGetApplications operation.
     * @return A Java Future containing the result of the BatchGetApplications operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.BatchGetApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetApplicationsResponse> batchGetApplications(
            BatchGetApplicationsRequest batchGetApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more deployment groups.
     * </p>
     * 
     * @param batchGetDeploymentGroupsRequest
     *        Represents the input of a BatchGetDeploymentGroups operation.
     * @return A Java Future containing the result of the BatchGetDeploymentGroups operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.BatchGetDeploymentGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetDeploymentGroupsResponse> batchGetDeploymentGroups(
            BatchGetDeploymentGroupsRequest batchGetDeploymentGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more instance that are part of a deployment group.
     * </p>
     * 
     * @param batchGetDeploymentInstancesRequest
     *        Represents the input of a BatchGetDeploymentInstances operation.
     * @return A Java Future containing the result of the BatchGetDeploymentInstances operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>InstanceIdRequiredException The instance ID was not specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>InvalidInstanceNameException The specified on-premises instance name was specified in an invalid
     *         format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.BatchGetDeploymentInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetDeploymentInstancesResponse> batchGetDeploymentInstances(
            BatchGetDeploymentInstancesRequest batchGetDeploymentInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more deployments.
     * </p>
     * 
     * @param batchGetDeploymentsRequest
     *        Represents the input of a BatchGetDeployments operation.
     * @return A Java Future containing the result of the BatchGetDeployments operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.BatchGetDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetDeploymentsResponse> batchGetDeployments(
            BatchGetDeploymentsRequest batchGetDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more on-premises instances.
     * </p>
     * 
     * @param batchGetOnPremisesInstancesRequest
     *        Represents the input of a BatchGetOnPremisesInstances operation.
     * @return A Java Future containing the result of the BatchGetOnPremisesInstances operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The specified on-premises instance name was specified in an invalid
     *         format.</li>
     *         <li>BatchLimitExceededException The maximum number of names or IDs allowed for this request (100) was
     *         exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.BatchGetOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetOnPremisesInstancesResponse> batchGetOnPremisesInstances(
            BatchGetOnPremisesInstancesRequest batchGetOnPremisesInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment
     * to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic
     * rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can
     * start as soon as all instances have a status of Ready.)
     * </p>
     * 
     * @param continueDeploymentRequest
     * @return A Java Future containing the result of the ContinueDeployment operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentAlreadyCompletedException The deployment is already complete.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentIsNotInReadyStateException The deployment does not have a status of Ready and can't
     *         continue yet.</li>
     *         <li>UnsupportedActionForDeploymentTypeException A call was submitted that is not supported for the
     *         specified deployment type.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ContinueDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ContinueDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ContinueDeploymentResponse> continueDeployment(ContinueDeploymentRequest continueDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     * 
     * @param createApplicationRequest
     *        Represents the input of a CreateApplication operation.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationAlreadyExistsException An application with the specified name already exists with the
     *         applicable IAM user or AWS account.</li>
     *         <li>ApplicationLimitExceededException More applications were attempted to be created than are allowed.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.CreateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploys an application revision through the specified deployment group.
     * </p>
     * 
     * @param createDeploymentRequest
     *        Represents the input of a CreateDeployment operation.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>RevisionDoesNotExistException The named revision does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>DescriptionTooLongException The description is too long.</li>
     *         <li>DeploymentLimitExceededException The number of allowed deployments was exceeded.</li>
     *         <li>InvalidTargetInstancesException The target instance configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Configuration data for target instances was entered for an in-place deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The limit of 10 tags for a tag type was exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The combined length of the tag names exceeded the limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A specified tag is not currently applied to any instances.
     *         </p>
     *         </li></li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled but an invalid triggering event type or no event types
     *         were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidFileExistsBehaviorException An invalid fileExistsBehavior option was specified to determine
     *         how AWS CodeDeploy handles files or directories that already exist in a deployment target location but
     *         weren't part of the previous successful deployment. Valid values include "DISALLOW", "OVERWRITE", and
     *         "RETAIN".</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.CreateDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a deployment configuration.
     * </p>
     * 
     * @param createDeploymentConfigRequest
     *        Represents the input of a CreateDeploymentConfig operation.
     * @return A Java Future containing the result of the CreateDeploymentConfig operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigAlreadyExistsException A deployment configuration with the specified name already
     *         exists with the applicable IAM user or AWS account.</li>
     *         <li>InvalidMinimumHealthyHostValueException The minimum healthy instance value was specified in an
     *         invalid format.</li>
     *         <li>DeploymentConfigLimitExceededException The deployment configurations limit was exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.CreateDeploymentConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentConfigResponse> createDeploymentConfig(
            CreateDeploymentConfigRequest createDeploymentConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a deployment group to which application revisions will be deployed.
     * </p>
     * 
     * @param createDeploymentGroupRequest
     *        Represents the input of a CreateDeploymentGroup operation.
     * @return A Java Future containing the result of the CreateDeploymentGroup operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupAlreadyExistsException A deployment group with the specified name already exists with
     *         the applicable IAM user or AWS account.</li>
     *         <li>InvalidEC2TagException The tag was specified in an invalid format.</li>
     *         <li>InvalidTagException The specified tag was specified in an invalid format.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>RoleRequiredException The role ID was not specified.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Auto
     *         Scaling.</li>
     *         <li>DeploymentGroupLimitExceededException The deployment groups limit was exceeded.</li>
     *         <li>LifecycleHookLimitExceededException The limit for lifecycle hooks was exceeded.</li>
     *         <li>InvalidTriggerConfigException The trigger was specified in an invalid format.</li>
     *         <li>TriggerTargetsLimitExceededException The maximum allowed number of triggers was exceeded.</li>
     *         <li>InvalidAlarmConfigException The format of the alarm configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the 255 character limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled but the alarm list is empty.
     *         </p>
     *         </li></li>
     *         <li>AlarmsLimitExceededException The maximum number of alarms for a deployment group (10) was exceeded.</li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled but an invalid triggering event type or no event types
     *         were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidDeploymentStyleException An invalid deployment style was specified. Valid deployment types
     *         include "IN_PLACE" and "BLUE_GREEN". Valid deployment options include "WITH_TRAFFIC_CONTROL" and
     *         "WITHOUT_TRAFFIC_CONTROL".</li>
     *         <li>InvalidBlueGreenDeploymentConfigurationException The configuration for the blue/green deployment
     *         group was provided in an invalid format. For information about deployment configuration format, see
     *         <a>CreateDeploymentConfig</a>.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.CreateDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentGroupResponse> createDeploymentGroup(
            CreateDeploymentGroupRequest createDeploymentGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     * 
     * @param deleteApplicationRequest
     *        Represents the input of a DeleteApplication operation.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.DeleteApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a deployment configuration.
     * </p>
     * <note>
     * <p>
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be
     * deleted.
     * </p>
     * </note>
     * 
     * @param deleteDeploymentConfigRequest
     *        Represents the input of a DeleteDeploymentConfig operation.
     * @return A Java Future containing the result of the DeleteDeploymentConfig operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigInUseException The deployment configuration is still in use.</li>
     *         <li>InvalidOperationException An invalid operation was detected.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.DeleteDeploymentConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeploymentConfigResponse> deleteDeploymentConfig(
            DeleteDeploymentConfigRequest deleteDeploymentConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a deployment group.
     * </p>
     * 
     * @param deleteDeploymentGroupRequest
     *        Represents the input of a DeleteDeploymentGroup operation.
     * @return A Java Future containing the result of the DeleteDeploymentGroup operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Auto
     *         Scaling.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.DeleteDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeploymentGroupResponse> deleteDeploymentGroup(
            DeleteDeploymentGroupRequest deleteDeploymentGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters an on-premises instance.
     * </p>
     * 
     * @param deregisterOnPremisesInstanceRequest
     *        Represents the input of a DeregisterOnPremisesInstance operation.
     * @return A Java Future containing the result of the DeregisterOnPremisesInstance operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InvalidInstanceNameException The specified on-premises instance name was specified in an invalid
     *         format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.DeregisterOnPremisesInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeregisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterOnPremisesInstanceResponse> deregisterOnPremisesInstance(
            DeregisterOnPremisesInstanceRequest deregisterOnPremisesInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an application.
     * </p>
     * 
     * @param getApplicationRequest
     *        Represents the input of a GetApplication operation.
     * @return A Java Future containing the result of the GetApplication operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.GetApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(GetApplicationRequest getApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an application revision.
     * </p>
     * 
     * @param getApplicationRevisionRequest
     *        Represents the input of a GetApplicationRevision operation.
     * @return A Java Future containing the result of the GetApplicationRevision operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>RevisionDoesNotExistException The named revision does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.GetApplicationRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationRevisionResponse> getApplicationRevision(
            GetApplicationRevisionRequest getApplicationRevisionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a deployment.
     * </p>
     * 
     * @param getDeploymentRequest
     *        Represents the input of a GetDeployment operation.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentDoesNotExistException The deployment does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.GetDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(GetDeploymentRequest getDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a deployment configuration.
     * </p>
     * 
     * @param getDeploymentConfigRequest
     *        Represents the input of a GetDeploymentConfig operation.
     * @return A Java Future containing the result of the GetDeploymentConfig operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigNameRequiredException The deployment configuration name was not specified.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.GetDeploymentConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeploymentConfigResponse> getDeploymentConfig(
            GetDeploymentConfigRequest getDeploymentConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a deployment group.
     * </p>
     * 
     * @param getDeploymentGroupRequest
     *        Represents the input of a GetDeploymentGroup operation.
     * @return A Java Future containing the result of the GetDeploymentGroup operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.GetDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeploymentGroupResponse> getDeploymentGroup(GetDeploymentGroupRequest getDeploymentGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an instance as part of a deployment.
     * </p>
     * 
     * @param getDeploymentInstanceRequest
     *        Represents the input of a GetDeploymentInstance operation.
     * @return A Java Future containing the result of the GetDeploymentInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>InstanceIdRequiredException The instance ID was not specified.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>InstanceDoesNotExistException The specified instance does not exist in the deployment group.</li>
     *         <li>InvalidInstanceNameException The specified on-premises instance name was specified in an invalid
     *         format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.GetDeploymentInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeploymentInstanceResponse> getDeploymentInstance(
            GetDeploymentInstanceRequest getDeploymentInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an on-premises instance.
     * </p>
     * 
     * @param getOnPremisesInstanceRequest
     *        Represents the input of a GetOnPremisesInstance operation.
     * @return A Java Future containing the result of the GetOnPremisesInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>InvalidInstanceNameException The specified on-premises instance name was specified in an invalid
     *         format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.GetOnPremisesInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOnPremisesInstanceResponse> getOnPremisesInstance(
            GetOnPremisesInstanceRequest getOnPremisesInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about revisions for an application.
     * </p>
     * 
     * @param listApplicationRevisionsRequest
     *        Represents the input of a ListApplicationRevisions operation.
     * @return A Java Future containing the result of the ListApplicationRevisions operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>InvalidSortByException The column name to sort by is either not present or was specified in an
     *         invalid format.</li>
     *         <li>InvalidSortOrderException The sort order was specified in an invalid format.</li>
     *         <li>InvalidBucketNameFilterException The bucket name either doesn't exist or was specified in an invalid
     *         format.</li>
     *         <li>InvalidKeyPrefixFilterException The specified key prefix filter was specified in an invalid format.</li>
     *         <li>BucketNameFilterRequiredException A bucket name is required, but was not provided.</li>
     *         <li>InvalidDeployedStateFilterException The deployed state filter was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListApplicationRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationRevisionsResponse> listApplicationRevisions(
            ListApplicationRevisionsRequest listApplicationRevisionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the applications registered with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listApplicationsRequest
     *        Represents the input of a ListApplications operation.
     * @return A Java Future containing the result of the ListApplications operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployment configurations with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listDeploymentConfigsRequest
     *        Represents the input of a ListDeploymentConfigs operation.
     * @return A Java Future containing the result of the ListDeploymentConfigs operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListDeploymentConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeploymentConfigsResponse> listDeploymentConfigs(
            ListDeploymentConfigsRequest listDeploymentConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployment groups for an application registered with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listDeploymentGroupsRequest
     *        Represents the input of a ListDeploymentGroups operation.
     * @return A Java Future containing the result of the ListDeploymentGroups operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListDeploymentGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeploymentGroupsResponse> listDeploymentGroups(
            ListDeploymentGroupsRequest listDeploymentGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the instance for a deployment associated with the applicable IAM user or AWS account.
     * </p>
     * 
     * @param listDeploymentInstancesRequest
     *        Represents the input of a ListDeploymentInstances operation.
     * @return A Java Future containing the result of the ListDeploymentInstances operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>InvalidInstanceStatusException The specified instance status does not exist.</li>
     *         <li>InvalidInstanceTypeException An invalid instance type was specified for instances in a blue/green
     *         deployment. Valid values include "Blue" for an original environment and "Green" for a replacement
     *         environment.</li>
     *         <li>InvalidDeploymentInstanceTypeException An instance type was specified for an in-place deployment.
     *         Instance types are supported for blue/green deployments only.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListDeploymentInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeploymentInstancesResponse> listDeploymentInstances(
            ListDeploymentInstancesRequest listDeploymentInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployments in a deployment group for an application registered with the applicable IAM user or AWS
     * account.
     * </p>
     * 
     * @param listDeploymentsRequest
     *        Represents the input of a ListDeployments operation.
     * @return A Java Future containing the result of the ListDeployments operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>InvalidTimeRangeException The specified time range was specified in an invalid format.</li>
     *         <li>InvalidDeploymentStatusException The specified deployment status doesn't exist or cannot be
     *         determined.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest listDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the names of stored connections to GitHub accounts.
     * </p>
     * 
     * @param listGitHubAccountTokenNamesRequest
     *        Represents the input of a ListGitHubAccountTokenNames operation.
     * @return A Java Future containing the result of the ListGitHubAccountTokenNames operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>ResourceValidationException The specified resource could not be validated.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListGitHubAccountTokenNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListGitHubAccountTokenNames"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGitHubAccountTokenNamesResponse> listGitHubAccountTokenNames(
            ListGitHubAccountTokenNamesRequest listGitHubAccountTokenNamesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of names for one or more on-premises instances.
     * </p>
     * <p>
     * Unless otherwise specified, both registered and deregistered on-premises instance names will be listed. To list
     * only registered or deregistered on-premises instance names, use the registration status parameter.
     * </p>
     * 
     * @param listOnPremisesInstancesRequest
     *        Represents the input of a ListOnPremisesInstances operation.
     * @return A Java Future containing the result of the ListOnPremisesInstances operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRegistrationStatusException The registration status was specified in an invalid format.</li>
     *         <li>InvalidTagFilterException The specified tag filter was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.ListOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOnPremisesInstancesResponse> listOnPremisesInstances(
            ListOnPremisesInstancesRequest listOnPremisesInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers with AWS CodeDeploy a revision for the specified application.
     * </p>
     * 
     * @param registerApplicationRevisionRequest
     *        Represents the input of a RegisterApplicationRevision operation.
     * @return A Java Future containing the result of the RegisterApplicationRevision operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>DescriptionTooLongException The description is too long.</li>
     *         <li>RevisionRequiredException The revision ID was not specified.</li>
     *         <li>InvalidRevisionException The revision was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.RegisterApplicationRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterApplicationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterApplicationRevisionResponse> registerApplicationRevision(
            RegisterApplicationRevisionRequest registerApplicationRevisionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an on-premises instance.
     * </p>
     * <note>
     * <p>
     * Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.
     * </p>
     * </note>
     * 
     * @param registerOnPremisesInstanceRequest
     *        Represents the input of the register on-premises instance operation.
     * @return A Java Future containing the result of the RegisterOnPremisesInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameAlreadyRegisteredException The specified on-premises instance name is already registered.
     *         </li>
     *         <li>IamArnRequiredException No IAM ARN was included in the request. You must use an IAM session ARN or
     *         IAM user ARN in the request.</li>
     *         <li>IamSessionArnAlreadyRegisteredException The request included an IAM session ARN that has already been
     *         used to register a different instance.</li>
     *         <li>IamUserArnAlreadyRegisteredException The specified IAM user ARN is already registered with an
     *         on-premises instance.</li>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>IamUserArnRequiredException An IAM user ARN was not specified.</li>
     *         <li>InvalidInstanceNameException The specified on-premises instance name was specified in an invalid
     *         format.</li>
     *         <li>InvalidIamSessionArnException The IAM session ARN was specified in an invalid format.</li>
     *         <li>InvalidIamUserArnException The IAM user ARN was specified in an invalid format.</li>
     *         <li>MultipleIamArnsProvidedException Both an IAM user ARN and an IAM session ARN were included in the
     *         request. Use only one ARN type.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.RegisterOnPremisesInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterOnPremisesInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterOnPremisesInstanceResponse> registerOnPremisesInstance(
            RegisterOnPremisesInstanceRequest registerOnPremisesInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from one or more on-premises instances.
     * </p>
     * 
     * @param removeTagsFromOnPremisesInstancesRequest
     *        Represents the input of a RemoveTagsFromOnPremisesInstances operation.
     * @return A Java Future containing the result of the RemoveTagsFromOnPremisesInstances operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNameRequiredException An on-premises instance name was not specified.</li>
     *         <li>TagRequiredException A tag was not specified.</li>
     *         <li>InvalidTagException The specified tag was specified in an invalid format.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>InstanceLimitExceededException The maximum number of allowed on-premises instances in a single call
     *         was exceeded.</li>
     *         <li>InstanceNotRegisteredException The specified on-premises instance is not registered.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.RemoveTagsFromOnPremisesInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RemoveTagsFromOnPremisesInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromOnPremisesInstancesResponse> removeTagsFromOnPremisesInstances(
            RemoveTagsFromOnPremisesInstancesRequest removeTagsFromOnPremisesInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after
     * the traffic routing is completed.
     * </p>
     * 
     * @param skipWaitTimeForInstanceTerminationRequest
     * @return A Java Future containing the result of the SkipWaitTimeForInstanceTermination operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentAlreadyCompletedException The deployment is already complete.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>DeploymentNotStartedException The specified deployment has not started.</li>
     *         <li>UnsupportedActionForDeploymentTypeException A call was submitted that is not supported for the
     *         specified deployment type.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.SkipWaitTimeForInstanceTermination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/SkipWaitTimeForInstanceTermination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SkipWaitTimeForInstanceTerminationResponse> skipWaitTimeForInstanceTermination(
            SkipWaitTimeForInstanceTerminationRequest skipWaitTimeForInstanceTerminationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to stop an ongoing deployment.
     * </p>
     * 
     * @param stopDeploymentRequest
     *        Represents the input of a StopDeployment operation.
     * @return A Java Future containing the result of the StopDeployment operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeploymentIdRequiredException At least one deployment ID must be specified.</li>
     *         <li>DeploymentDoesNotExistException The deployment does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>DeploymentAlreadyCompletedException The deployment is already complete.</li>
     *         <li>InvalidDeploymentIdException At least one of the deployment IDs was specified in an invalid format.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.StopDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/StopDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDeploymentResponse> stopDeployment(StopDeploymentRequest stopDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the name of an application.
     * </p>
     * 
     * @param updateApplicationRequest
     *        Represents the input of an UpdateApplication operation.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationAlreadyExistsException An application with the specified name already exists with the
     *         applicable IAM user or AWS account.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.UpdateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about a deployment group.
     * </p>
     * 
     * @param updateDeploymentGroupRequest
     *        Represents the input of an UpdateDeploymentGroup operation.
     * @return A Java Future containing the result of the UpdateDeploymentGroup operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApplicationNameRequiredException The minimum number of required application names was not specified.</li>
     *         <li>InvalidApplicationNameException The application name was specified in an invalid format.</li>
     *         <li>ApplicationDoesNotExistException The application does not exist with the applicable IAM user or AWS
     *         account.</li>
     *         <li>InvalidDeploymentGroupNameException The deployment group name was specified in an invalid format.</li>
     *         <li>DeploymentGroupAlreadyExistsException A deployment group with the specified name already exists with
     *         the applicable IAM user or AWS account.</li>
     *         <li>DeploymentGroupNameRequiredException The deployment group name was not specified.</li>
     *         <li>DeploymentGroupDoesNotExistException The named deployment group does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>InvalidEC2TagException The tag was specified in an invalid format.</li>
     *         <li>InvalidTagException The specified tag was specified in an invalid format.</li>
     *         <li>InvalidAutoScalingGroupException The Auto Scaling group was specified in an invalid format or does
     *         not exist.</li>
     *         <li>InvalidDeploymentConfigNameException The deployment configuration name was specified in an invalid
     *         format.</li>
     *         <li>DeploymentConfigDoesNotExistException The deployment configuration does not exist with the applicable
     *         IAM user or AWS account.</li>
     *         <li>InvalidRoleException The service role ARN was specified in an invalid format. Or, if an Auto Scaling
     *         group was specified, the specified service role does not grant the appropriate permissions to Auto
     *         Scaling.</li>
     *         <li>LifecycleHookLimitExceededException The limit for lifecycle hooks was exceeded.</li>
     *         <li>InvalidTriggerConfigException The trigger was specified in an invalid format.</li>
     *         <li>TriggerTargetsLimitExceededException The maximum allowed number of triggers was exceeded.</li>
     *         <li>InvalidAlarmConfigException The format of the alarm configuration is invalid. Possible causes
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The alarm list is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm object is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm name is empty or null or exceeds the 255 character limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Two alarms with the same name have been specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The alarm configuration is enabled but the alarm list is empty.
     *         </p>
     *         </li></li>
     *         <li>AlarmsLimitExceededException The maximum number of alarms for a deployment group (10) was exceeded.</li>
     *         <li>InvalidAutoRollbackConfigException The automatic rollback configuration was specified in an invalid
     *         format. For example, automatic rollback is enabled but an invalid triggering event type or no event types
     *         were listed.</li>
     *         <li>InvalidLoadBalancerInfoException An invalid load balancer name, or no load balancer name, was
     *         specified.</li>
     *         <li>InvalidDeploymentStyleException An invalid deployment style was specified. Valid deployment types
     *         include "IN_PLACE" and "BLUE_GREEN". Valid deployment options include "WITH_TRAFFIC_CONTROL" and
     *         "WITHOUT_TRAFFIC_CONTROL".</li>
     *         <li>InvalidBlueGreenDeploymentConfigurationException The configuration for the blue/green deployment
     *         group was provided in an invalid format. For information about deployment configuration format, see
     *         <a>CreateDeploymentConfig</a>.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>CodeDeployException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample CodeDeployAsyncClient.UpdateDeploymentGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateDeploymentGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDeploymentGroupResponse> updateDeploymentGroup(
            UpdateDeploymentGroupRequest updateDeploymentGroupRequest) {
        throw new UnsupportedOperationException();
    }
}
