/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeconnections.CodeConnectionsClient;
import software.amazon.awssdk.services.codeconnections.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeconnections.model.ListHostsRequest;
import software.amazon.awssdk.services.codeconnections.model.ListHostsResponse;

public class ListHostsIterable
implements SdkIterable<ListHostsResponse> {
    private final CodeConnectionsClient client;
    private final ListHostsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHostsIterable(CodeConnectionsClient client, ListHostsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListHostsResponseFetcher();
    }

    public Iterator<ListHostsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListHostsResponseFetcher
    implements SyncPageFetcher<ListHostsResponse> {
        private ListHostsResponseFetcher() {
        }

        public boolean hasNextPage(ListHostsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHostsResponse nextPage(ListHostsResponse previousPage) {
            if (previousPage == null) {
                return ListHostsIterable.this.client.listHosts(ListHostsIterable.this.firstRequest);
            }
            return ListHostsIterable.this.client.listHosts((ListHostsRequest)((Object)ListHostsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

