/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.internal.cloudwatch.transform;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.metrics.internal.cloudwatch.spi.Dimensions;
import software.amazon.awssdk.metrics.internal.cloudwatch.spi.RequestMetricTransformer;
import software.amazon.awssdk.metrics.internal.cloudwatch.transform.DynamoDbDimensions;
import software.amazon.awssdk.metrics.spi.MetricType;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.dynamodb.metrics.DynamoDbRequestMetric;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;

@ThreadSafe
public class DynamoDbRequestMetricTransformer
implements RequestMetricTransformer {
    @Override
    public List<MetricDatum> toMetricData(MetricType metricType, Request<?> request, Object response) {
        try {
            return this.toMetricData0(metricType, request, response);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException exception) {
        }
        catch (InvocationTargetException e) {
            LoggerFactory.getLogger(this.getClass()).debug("", e.getCause());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).debug("", (Throwable)e);
        }
        return null;
    }

    private List<MetricDatum> toMetricData0(MetricType metricType, Request<?> req, Object response) throws Exception {
        if (!(metricType instanceof DynamoDbRequestMetric)) {
            return null;
        }
        DynamoDbRequestMetric predefined = (DynamoDbRequestMetric)metricType;
        switch (predefined) {
            case DynamoDBConsumedCapacity: {
                if (response == null) {
                    return Collections.emptyList();
                }
                Method method = response.getClass().getMethod("consumedCapacity", new Class[0]);
                Object value = method.invoke(response, new Object[0]);
                if (!(value instanceof ConsumedCapacity)) {
                    return Collections.emptyList();
                }
                ConsumedCapacity consumedCapacity = (ConsumedCapacity)value;
                Double units = consumedCapacity.capacityUnits();
                if (units == null) {
                    return Collections.emptyList();
                }
                String tableName = consumedCapacity.tableName();
                ArrayList<Object> dims = new ArrayList<Object>();
                dims.add(Dimension.builder().name(Dimensions.MetricType.name()).value(metricType.name()).build());
                dims.add(Dimension.builder().name(Dimensions.RequestType.name()).value(this.requestType(req)).build());
                dims.add(Dimension.builder().name(DynamoDbDimensions.TableName.name()).value(tableName).build());
                MetricDatum datum = (MetricDatum)MetricDatum.builder().metricName(req.getServiceName()).dimensions(dims).unit(StandardUnit.Count).value(units).build();
                return Collections.singletonList(datum);
            }
        }
        return Collections.emptyList();
    }

    private String requestType(Request<?> req) {
        return req.getOriginalRequest().getClass().getSimpleName();
    }
}

