/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.internal.cloudwatch.spi;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.metrics.internal.cloudwatch.spi.RequestMetricTransformer;

public enum AwsMetricTransformerFactory {
    DynamoDb;

    public static final String DEFAULT_METRIC_TRANSFORM_PROVIDER_PACKAGE = "software.amazon.awssdk.metrics.internal.cloudwatch.transform";
    private static final String REQUEST_TRANSFORMER_CLASSNAME_SUFFIX = "RequestMetricTransformer";
    public static volatile String transformerPackage;
    private volatile RequestMetricTransformer requestMetricTransformer;

    public static String getTransformerPackage() {
        return transformerPackage;
    }

    public static void setTransformerPackage(String transformPackage) {
        if (transformPackage == null) {
            throw new IllegalArgumentException();
        }
        transformerPackage = transformPackage;
    }

    public static String buildRequestMetricTransformerFqcn(String awsPrefix, String packageName) {
        return packageName + "." + awsPrefix + REQUEST_TRANSFORMER_CLASSNAME_SUFFIX;
    }

    private RequestMetricTransformer loadRequestMetricTransformer(String fqcn) {
        Logger log = LoggerFactory.getLogger(AwsMetricTransformerFactory.class);
        if (log.isDebugEnabled()) {
            log.debug("Loading " + fqcn);
        }
        try {
            Class<?> c = Class.forName(fqcn);
            return (RequestMetricTransformer)c.newInstance();
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to load " + fqcn + "; therefore ignoring " + this.name() + " specific predefined metrics", e);
            }
            return RequestMetricTransformer.NONE;
        }
    }

    public RequestMetricTransformer getRequestMetricTransformer() {
        RequestMetricTransformer transformer = this.requestMetricTransformer;
        String packageName = transformerPackage;
        if (transformer != null && packageName.equals(transformer.getClass().getPackage().getName())) {
            return transformer;
        }
        String fqcn = AwsMetricTransformerFactory.buildRequestMetricTransformerFqcn(this.name(), packageName);
        this.requestMetricTransformer = this.loadRequestMetricTransformer(fqcn);
        return this.requestMetricTransformer;
    }

    static {
        transformerPackage = DEFAULT_METRIC_TRANSFORM_PROVIDER_PACKAGE;
    }
}

