/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.internal.cloudwatch;

import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.metrics.AwsSdkMetrics;
import software.amazon.awssdk.metrics.ByteThroughputProvider;
import software.amazon.awssdk.metrics.ServiceLatencyProvider;
import software.amazon.awssdk.metrics.ServiceMetricCollector;
import software.amazon.awssdk.metrics.ServiceMetricType;
import software.amazon.awssdk.metrics.ThroughputMetricType;
import software.amazon.awssdk.metrics.internal.cloudwatch.spi.Dimensions;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;

@ThreadSafe
public class ServiceMetricCollectorSupport
extends ServiceMetricCollector {
    protected static final Logger log = LoggerFactory.getLogger(ServiceMetricCollectorSupport.class);
    static final double NANO_PER_SEC = TimeUnit.SECONDS.toNanos(1L);
    private final BlockingQueue<MetricDatum> queue;

    protected ServiceMetricCollectorSupport(BlockingQueue<MetricDatum> queue) {
        this.queue = queue;
    }

    public void collectByteThroughput(ByteThroughputProvider provider) {
        block2: {
            try {
                this.collectByteThroughput0(provider);
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Ignoring unexpected failure", (Throwable)ex);
            }
        }
    }

    double bytesPerSecond(double byteCount, double durationNano) {
        double bytesPerSec;
        if (byteCount < 0.0 || durationNano < 0.0) {
            throw new IllegalArgumentException();
        }
        if (durationNano == 0.0) {
            durationNano = 1.0;
            if (log.isDebugEnabled()) {
                log.debug("Set zero to one to avoid division by zero; but should never get here!");
            }
        }
        if ((bytesPerSec = byteCount / durationNano * NANO_PER_SEC) == 0.0 && log.isDebugEnabled()) {
            log.debug("zero bytes per sec.  Really ?");
        }
        return bytesPerSec;
    }

    private void collectByteThroughput0(ByteThroughputProvider provider) {
        ThroughputMetricType throughputType = provider.getThroughputMetricType();
        ServiceMetricType byteCountType = throughputType.getByteCountMetricType();
        Set metrics = AwsSdkMetrics.getPredefinedMetrics();
        double byteCount = provider.getByteCount();
        double durationNano = provider.getDurationNano();
        double bytesPerSec = this.bytesPerSecond(byteCount, durationNano);
        if (metrics.contains(throughputType)) {
            Dimension throughputDimension = (Dimension)Dimension.builder().name(Dimensions.MetricType.name()).value(throughputType.name()).build();
            MetricDatum throughputDatum = (MetricDatum)MetricDatum.builder().metricName(throughputType.getServiceName()).dimensions(new Dimension[]{throughputDimension}).unit(StandardUnit.BytesSecond).value(Double.valueOf(bytesPerSec)).build();
            this.safeAddMetricsToQueue(throughputDatum);
        }
        if (metrics.contains(byteCountType)) {
            Dimension byteCountDimension = (Dimension)Dimension.builder().name(Dimensions.MetricType.name()).value(byteCountType.name()).build();
            MetricDatum byteCountDatum = (MetricDatum)MetricDatum.builder().metricName(byteCountType.getServiceName()).dimensions(new Dimension[]{byteCountDimension}).unit(StandardUnit.Bytes).value(Double.valueOf(byteCount)).build();
            this.safeAddMetricsToQueue(byteCountDatum);
        }
    }

    public void collectLatency(ServiceLatencyProvider provider) {
        ServiceMetricType type = provider.getServiceMetricType();
        Set metrics = AwsSdkMetrics.getPredefinedMetrics();
        if (metrics.contains(type)) {
            Dimension dim = (Dimension)Dimension.builder().name(Dimensions.MetricType.name()).value(type.name()).build();
            MetricDatum datum = (MetricDatum)MetricDatum.builder().metricName(type.getServiceName()).dimensions(new Dimension[]{dim}).unit(StandardUnit.Milliseconds).value(Double.valueOf(provider.getDurationMilli())).build();
            this.safeAddMetricsToQueue(datum);
        }
    }

    private void safeAddMetricsToQueue(MetricDatum metric) {
        try {
            if (!this.addMetricsToQueue(metric) && log.isDebugEnabled()) {
                log.debug("Failed to add to the metrics queue (due to no space available) for " + metric.metricName());
            }
        }
        catch (RuntimeException ex) {
            log.warn("Failed to add to the metrics queue for metric: " + metric, (Throwable)ex);
        }
    }

    protected boolean addMetricsToQueue(MetricDatum metric) {
        return this.queue.offer(metric);
    }
}

