/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.internal.cloudwatch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.metrics.internal.cloudwatch.spi.AwsMetricTransformerFactory;
import software.amazon.awssdk.metrics.internal.cloudwatch.spi.Dimensions;
import software.amazon.awssdk.metrics.internal.cloudwatch.spi.MetricData;
import software.amazon.awssdk.metrics.internal.cloudwatch.spi.RequestMetricTransformer;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;
import software.amazon.awssdk.metrics.spi.MetricType;
import software.amazon.awssdk.metrics.spi.TimingInfo;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;

@ThreadSafe
public class PredefinedMetricTransformer {
    static final boolean INCLUDE_REQUEST_TYPE = true;
    static final boolean EXCLUDE_REQUEST_TYPE = false;
    private static final Logger log = LoggerFactory.getLogger(PredefinedMetricTransformer.class);

    public List<MetricDatum> toMetricData(MetricType metricType, Request<?> request, Object response) {
        if (metricType instanceof AwsRequestMetrics.Field) {
            AwsRequestMetrics.Field predefined = (AwsRequestMetrics.Field)metricType;
            switch (predefined) {
                case HttpClientRetryCount: 
                case HttpClientPoolAvailableCount: 
                case HttpClientPoolLeasedCount: 
                case HttpClientPoolPendingCount: {
                    return this.metricOfCount(predefined, request);
                }
                case RequestCount: 
                case RetryCount: {
                    return this.metricOfRequestOrRetryCount(predefined, request);
                }
                case ThrottledRetryCount: 
                case RetryCapacityConsumed: {
                    return this.counterMetricOf((MetricType)predefined, request, false);
                }
                case ResponseProcessingTime: 
                case RequestSigningTime: {
                    return this.latencyMetricOf((MetricType)predefined, request, false);
                }
                case ClientExecuteTime: {
                    return this.latencyOfClientExecuteTime(request);
                }
                case HttpClientSendRequestTime: 
                case HttpClientReceiveResponseTime: 
                case HttpRequestTime: 
                case HttpSocketReadTime: {
                    return this.latencyMetricOf((MetricType)predefined, request, true);
                }
                case Exception: 
                case ThrottleException: {
                    return this.counterMetricOf((MetricType)predefined, request, true);
                }
            }
        }
        for (AwsRequestMetrics.Field aws : AwsMetricTransformerFactory.values()) {
            if (!metricType.name().startsWith(aws.name())) continue;
            List<MetricDatum> metricData = aws.getRequestMetricTransformer().toMetricData(metricType, request, response);
            if (metricData == null) break;
            return metricData;
        }
        if (log.isDebugEnabled()) {
            AmazonWebServiceRequest origReq = request == null ? null : request.getOriginalRequest();
            String reqClassName = origReq == null ? null : origReq.getClass().getName();
            log.debug("No request metric transformer can be found for metric type " + metricType.name() + " for " + reqClassName);
        }
        return Collections.emptyList();
    }

    protected List<MetricDatum> metricOfRequestOrRetryCount(AwsRequestMetrics.Field metricType, Request<?> req) {
        double count;
        AwsRequestMetrics m = req.getAwsRequestMetrics();
        TimingInfo ti = m.getTimingInfo();
        Number counter = ti.getCounter(AwsRequestMetrics.Field.RequestCount.name());
        if (counter == null) {
            return Collections.emptyList();
        }
        int requestCount = counter.intValue();
        if (requestCount < 1) {
            LoggerFactory.getLogger(this.getClass()).debug("request count must be at least one");
            return Collections.emptyList();
        }
        double d = count = metricType == AwsRequestMetrics.Field.RequestCount ? (double)requestCount : (double)(requestCount - 1);
        if (count < 1.0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(MetricDatum.builder().metricName(req.getServiceName()).dimensions(new Dimension[]{(Dimension)Dimension.builder().name(Dimensions.MetricType.name()).value(metricType.name()).build()}).unit(StandardUnit.Count).value(Double.valueOf(count)).timestamp(RequestMetricTransformer.Utils.endTimestamp(ti)).build());
    }

    protected List<MetricDatum> metricOfCount(AwsRequestMetrics.Field metricType, Request<?> req) {
        AwsRequestMetrics m = req.getAwsRequestMetrics();
        TimingInfo ti = m.getTimingInfo();
        Number counter = ti.getCounter(metricType.name());
        if (counter == null) {
            return Collections.emptyList();
        }
        double count = counter.doubleValue();
        if (count < 1.0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(MetricDatum.builder().metricName(req.getServiceName()).dimensions(new Dimension[]{(Dimension)Dimension.builder().name(Dimensions.MetricType.name()).value(metricType.name()).build()}).unit(StandardUnit.Count).value(Double.valueOf(count)).timestamp(RequestMetricTransformer.Utils.endTimestamp(ti)).build());
    }

    protected List<MetricDatum> latencyMetricOf(MetricType metricType, Request<?> req, boolean includesRequestType) {
        String metricName;
        AwsRequestMetrics m = req.getAwsRequestMetrics();
        TimingInfo root = m.getTimingInfo();
        List subMeasures = root.getAllSubMeasurements(metricName = metricType.name());
        if (subMeasures != null) {
            ArrayList<MetricDatum> result = new ArrayList<MetricDatum>(subMeasures.size());
            for (TimingInfo sub : subMeasures) {
                if (!sub.isEndTimeKnown()) continue;
                ArrayList<Object> dims = new ArrayList<Object>();
                dims.add(Dimension.builder().name(Dimensions.MetricType.name()).value(metricName).build());
                if (includesRequestType) {
                    dims.add(Dimension.builder().name(Dimensions.RequestType.name()).value(this.requestType(req)).build());
                }
                MetricDatum datum = (MetricDatum)MetricDatum.builder().metricName(req.getServiceName()).dimensions(dims).unit(StandardUnit.Milliseconds).value(sub.getTimeTakenMillisIfKnown()).build();
                result.add(datum);
            }
            return result;
        }
        return Collections.emptyList();
    }

    protected List<MetricDatum> latencyOfClientExecuteTime(Request<?> req) {
        AwsRequestMetrics m = req.getAwsRequestMetrics();
        TimingInfo root = m.getTimingInfo();
        String metricName = AwsRequestMetrics.Field.ClientExecuteTime.name();
        if (root.isEndTimeKnown()) {
            ArrayList<Object> dims = new ArrayList<Object>();
            dims.add(Dimension.builder().name(Dimensions.MetricType.name()).value(metricName).build());
            dims.add(Dimension.builder().name(Dimensions.RequestType.name()).value(this.requestType(req)).build());
            MetricDatum datum = (MetricDatum)MetricDatum.builder().metricName(req.getServiceName()).dimensions(dims).unit(StandardUnit.Milliseconds).value(root.getTimeTakenMillisIfKnown()).build();
            return Collections.singletonList(datum);
        }
        return Collections.emptyList();
    }

    private String requestType(Request<?> req) {
        return req.getOriginalRequest().getClass().getSimpleName();
    }

    protected List<MetricDatum> counterMetricOf(MetricType type, Request<?> req, boolean includesRequestType) {
        String metricName;
        AwsRequestMetrics m = req.getAwsRequestMetrics();
        TimingInfo ti = m.getTimingInfo();
        Number counter = ti.getCounter(metricName = type.name());
        if (counter == null) {
            return Collections.emptyList();
        }
        int count = counter.intValue();
        if (count < 1) {
            LoggerFactory.getLogger(this.getClass()).debug("Count must be at least one");
            return Collections.emptyList();
        }
        ArrayList<MetricDatum> result = new ArrayList<MetricDatum>();
        Dimension metricDimension = (Dimension)Dimension.builder().name(Dimensions.MetricType.name()).value(metricName).build();
        MetricDatum first = (MetricDatum)MetricDatum.builder().metricName(req.getServiceName()).dimensions(new Dimension[]{metricDimension}).unit(StandardUnit.Count).value(Double.valueOf(count)).timestamp(RequestMetricTransformer.Utils.endTimestamp(ti)).build();
        result.add(first);
        if (includesRequestType) {
            Dimension requestDimension = (Dimension)Dimension.builder().name(Dimensions.RequestType.name()).value(this.requestType(req)).build();
            MetricDatum second = MetricData.newMetricDatum(first, metricDimension, requestDimension);
            result.add(second);
        }
        return result;
    }
}

