/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.internal.cloudwatch;

import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.metrics.internal.cloudwatch.BlockingRequestBuilder;
import software.amazon.awssdk.metrics.internal.cloudwatch.CloudWatchMetricConfig;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.util.VersionInfoUtils;

class MetricUploaderThread
extends Thread {
    private static final String USER_AGENT = MetricUploaderThread.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String THREAD_NAME = "java-sdk-metric-uploader";
    private final CloudWatchClient cloudwatchClient;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BlockingRequestBuilder qIterator;
    private volatile boolean cancelled;

    MetricUploaderThread(CloudWatchMetricConfig config, BlockingQueue<MetricDatum> queue) {
        super(THREAD_NAME);
        if (config == null || queue == null) {
            throw new IllegalArgumentException();
        }
        this.cloudwatchClient = config.getCloudWatchClient();
        this.qIterator = new BlockingRequestBuilder(config, queue);
        this.setPriority(1);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (!this.cancelled) {
            try {
                Iterable<PutMetricDataRequest> requests = this.qIterator.nextUploadUnits();
                for (PutMetricDataRequest req : requests) {
                    this.appendUserAgent(req);
                    this.log.debug("{}", (Object)req);
                    this.cloudwatchClient.putMetricData(req);
                    Thread.yield();
                }
            }
            catch (InterruptedException e) {
                if (this.cancelled) continue;
                this.log.debug("Unexpected interruption ignored");
            }
            catch (Throwable t) {
                this.log.warn("Unexpected condition; soldier on", t);
                Thread.yield();
            }
        }
    }

    void cancel() {
        this.cancelled = true;
    }

    private void appendUserAgent(PutMetricDataRequest request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
    }
}

