/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.internal.cloudwatch;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.metrics.ServiceMetricCollector;
import software.amazon.awssdk.metrics.internal.cloudwatch.CloudWatchMetricConfig;
import software.amazon.awssdk.metrics.internal.cloudwatch.MetricUploaderThread;
import software.amazon.awssdk.metrics.internal.cloudwatch.RequestMetricCollectorSupport;
import software.amazon.awssdk.metrics.internal.cloudwatch.ServiceMetricCollectorSupport;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;

@ThreadSafe
public class MetricCollectorSupport
extends MetricCollector {
    protected static final Logger log = LoggerFactory.getLogger(MetricCollectorSupport.class);
    private static volatile MetricCollectorSupport singleton;
    private final RequestMetricCollectorSupport requestMetricCollector;
    private final ServiceMetricCollectorSupport serviceMetricCollector;
    private final BlockingQueue<MetricDatum> queue;
    private final CloudWatchMetricConfig config;
    private MetricUploaderThread uploaderThread;

    protected MetricCollectorSupport(CloudWatchMetricConfig config) {
        if (config == null) {
            throw new IllegalArgumentException();
        }
        this.config = config;
        this.queue = new LinkedBlockingQueue<MetricDatum>(config.getMetricQueueSize());
        this.requestMetricCollector = new RequestMetricCollectorSupport(this.queue);
        this.serviceMetricCollector = new ServiceMetricCollectorSupport(this.queue);
    }

    static MetricCollectorSupport getInstance() {
        return singleton;
    }

    static synchronized boolean startSingleton(CloudWatchMetricConfig config) {
        if (singleton != null) {
            return false;
        }
        log.info("Initializing " + MetricCollectorSupport.class.getSimpleName());
        return MetricCollectorSupport.createAndStartCollector(config);
    }

    static synchronized boolean restartSingleton(CloudWatchMetricConfig config) {
        if (singleton == null) {
            throw new IllegalStateException(MetricCollectorSupport.class.getSimpleName() + " has neven been initialized");
        }
        log.info("Re-initializing " + MetricCollectorSupport.class.getSimpleName());
        singleton.stop();
        return MetricCollectorSupport.createAndStartCollector(config);
    }

    private static boolean createAndStartCollector(CloudWatchMetricConfig config) {
        MetricCollectorSupport collector = new MetricCollectorSupport(config);
        if (collector.start()) {
            singleton = collector;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Class<MetricCollectorSupport> clazz = MetricCollectorSupport.class;
        synchronized (MetricCollectorSupport.class) {
            if (this.uploaderThread != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            this.uploaderThread = new MetricUploaderThread(this.config, this.queue);
            this.uploaderThread.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Class<MetricCollectorSupport> clazz = MetricCollectorSupport.class;
        synchronized (MetricCollectorSupport.class) {
            if (this.uploaderThread != null) {
                this.uploaderThread.cancel();
                this.uploaderThread.interrupt();
                this.uploaderThread = null;
                if (singleton == this) {
                    singleton = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public CloudWatchMetricConfig getConfig() {
        return this.config;
    }

    public final boolean isEnabled() {
        return true;
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public ServiceMetricCollector getServiceMetricCollector() {
        return this.serviceMetricCollector;
    }
}

