/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.internal.cloudwatch;

import java.util.Comparator;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.util.StringUtils;

enum DimensionComparator implements Comparator<Dimension>
{
    INSTANCE;

    private static final int NON_NULLS = 2;

    @Override
    public int compare(Dimension dim1, Dimension dim2) {
        int result = this.nullCompare(dim1, dim2);
        if (result == 2 && (result = this.nullSafeCompare(dim1.name(), dim2.name())) == 0) {
            return this.nullSafeCompare(dim1.value(), dim2.value());
        }
        return result;
    }

    private int nullSafeCompare(String first, String second) {
        int result = this.nullCompare(first, second);
        return result == 2 ? StringUtils.compare((String)first, (String)second) : result;
    }

    private int nullCompare(Object first, Object second) {
        if (first == second) {
            return 0;
        }
        if (first == null) {
            return -1;
        }
        if (second == null) {
            return 1;
        }
        return 2;
    }
}

