/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.internal.cloudwatch;

import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.metrics.AwsSdkMetrics;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.internal.cloudwatch.CloudWatchMetricConfig;
import software.amazon.awssdk.metrics.internal.cloudwatch.MetricCollectorSupport;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClientBuilder;

public class DefaultMetricCollectorFactory
implements MetricCollector.Factory {
    public MetricCollector getInstance() {
        AwsCredentialsProvider provider = AwsSdkMetrics.getCredentialProvider();
        Region region = Region.of((String)AwsSdkMetrics.getRegionName());
        Integer qSize = AwsSdkMetrics.getMetricQueueSize();
        Long timeoutMilli = AwsSdkMetrics.getQueuePollTimeoutMilli();
        CloudWatchMetricConfig config = new CloudWatchMetricConfig();
        if (qSize != null) {
            config.setMetricQueueSize(qSize);
        }
        if (timeoutMilli != null) {
            config.setQueuePollTimeoutMilli(timeoutMilli);
        }
        config.setCloudWatchClient((CloudWatchClient)((CloudWatchClientBuilder)((CloudWatchClientBuilder)CloudWatchClient.builder().credentialsProvider(provider)).region(region)).build());
        MetricCollectorSupport.startSingleton(config);
        return MetricCollectorSupport.getInstance();
    }
}

