/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use this processor to convert a value type associated with the specified key to the specified type. It's a casting
 * processor that changes the types of the specified fields. Values can be converted into one of the following
 * datatypes: <code>integer</code>, <code>double</code>, <code>string</code> and <code>boolean</code>.
 * </p>
 * <p>
 * For more information about this processor including examples, see <a href=
 * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-trimString"
 * > trimString</a> in the <i>CloudWatch Logs User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TypeConverter implements SdkPojo, Serializable, ToCopyableBuilder<TypeConverter.Builder, TypeConverter> {
    private static final SdkField<List<TypeConverterEntry>> ENTRIES_FIELD = SdkField
            .<List<TypeConverterEntry>> builder(MarshallingType.LIST)
            .memberName("entries")
            .getter(getter(TypeConverter::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TypeConverterEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TypeConverterEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<TypeConverterEntry> entries;

    private TypeConverter(BuilderImpl builder) {
        this.entries = builder.entries;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>TypeConverterEntry</code> objects, where each object contains the information about one field
     * to change the type of.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntries} method.
     * </p>
     * 
     * @return An array of <code>TypeConverterEntry</code> objects, where each object contains the information about one
     *         field to change the type of.
     */
    public final List<TypeConverterEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeConverter)) {
            return false;
        }
        TypeConverter other = (TypeConverter) obj;
        return hasEntries() == other.hasEntries() && Objects.equals(entries(), other.entries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TypeConverter").add("Entries", hasEntries() ? entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entries":
            return Optional.ofNullable(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entries", ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TypeConverter, T> g) {
        return obj -> g.apply((TypeConverter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TypeConverter> {
        /**
         * <p>
         * An array of <code>TypeConverterEntry</code> objects, where each object contains the information about one
         * field to change the type of.
         * </p>
         * 
         * @param entries
         *        An array of <code>TypeConverterEntry</code> objects, where each object contains the information about
         *        one field to change the type of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<TypeConverterEntry> entries);

        /**
         * <p>
         * An array of <code>TypeConverterEntry</code> objects, where each object contains the information about one
         * field to change the type of.
         * </p>
         * 
         * @param entries
         *        An array of <code>TypeConverterEntry</code> objects, where each object contains the information about
         *        one field to change the type of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(TypeConverterEntry... entries);

        /**
         * <p>
         * An array of <code>TypeConverterEntry</code> objects, where each object contains the information about one
         * field to change the type of.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.TypeConverterEntry.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.TypeConverterEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.TypeConverterEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #entries(List<TypeConverterEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.TypeConverterEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(java.util.Collection<TypeConverterEntry>)
         */
        Builder entries(Consumer<TypeConverterEntry.Builder>... entries);
    }

    static final class BuilderImpl implements Builder {
        private List<TypeConverterEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TypeConverter model) {
            entries(model.entries);
        }

        public final List<TypeConverterEntry.Builder> getEntries() {
            List<TypeConverterEntry.Builder> result = TypeConverterEntriesCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<TypeConverterEntry.BuilderImpl> entries) {
            this.entries = TypeConverterEntriesCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<TypeConverterEntry> entries) {
            this.entries = TypeConverterEntriesCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(TypeConverterEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<TypeConverterEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> TypeConverterEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TypeConverter build() {
            return new TypeConverter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
