/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The query string is not valid. Details about this error are displayed in a <code>QueryCompileError</code> object. For
 * more information, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_QueryCompileError.html"
 * >QueryCompileError</a>.
 * </p>
 * <p>
 * For more information about valid query syntax, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query
 * Syntax</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MalformedQueryException extends CloudWatchLogsException implements
        ToCopyableBuilder<MalformedQueryException.Builder, MalformedQueryException> {
    private static final SdkField<QueryCompileError> QUERY_COMPILE_ERROR_FIELD = SdkField
            .<QueryCompileError> builder(MarshallingType.SDK_POJO).memberName("queryCompileError")
            .getter(getter(MalformedQueryException::queryCompileError)).setter(setter(Builder::queryCompileError))
            .constructor(QueryCompileError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryCompileError").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_COMPILE_ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final QueryCompileError queryCompileError;

    private MalformedQueryException(BuilderImpl builder) {
        super(builder);
        this.queryCompileError = builder.queryCompileError;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the QueryCompileError property for this object.
     * 
     * @return The value of the QueryCompileError property for this object.
     */
    public QueryCompileError queryCompileError() {
        return queryCompileError;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queryCompileError", QUERY_COMPILE_ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MalformedQueryException, T> g) {
        return obj -> g.apply((MalformedQueryException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MalformedQueryException>, CloudWatchLogsException.Builder {
        /**
         * Sets the value of the QueryCompileError property for this object.
         *
         * @param queryCompileError
         *        The new value for the QueryCompileError property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryCompileError(QueryCompileError queryCompileError);

        /**
         * Sets the value of the QueryCompileError property for this object.
         *
         * This is a convenience method that creates an instance of the {@link QueryCompileError.Builder} avoiding the
         * need to create one manually via {@link QueryCompileError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryCompileError.Builder#build()} is called immediately and its
         * result is passed to {@link #queryCompileError(QueryCompileError)}.
         * 
         * @param queryCompileError
         *        a consumer that will call methods on {@link QueryCompileError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryCompileError(QueryCompileError)
         */
        default Builder queryCompileError(Consumer<QueryCompileError.Builder> queryCompileError) {
            return queryCompileError(QueryCompileError.builder().applyMutation(queryCompileError).build());
        }

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends CloudWatchLogsException.BuilderImpl implements Builder {
        private QueryCompileError queryCompileError;

        private BuilderImpl() {
        }

        private BuilderImpl(MalformedQueryException model) {
            super(model);
            queryCompileError(model.queryCompileError);
        }

        public final QueryCompileError.Builder getQueryCompileError() {
            return queryCompileError != null ? queryCompileError.toBuilder() : null;
        }

        public final void setQueryCompileError(QueryCompileError.BuilderImpl queryCompileError) {
            this.queryCompileError = queryCompileError != null ? queryCompileError.build() : null;
        }

        @Override
        public final Builder queryCompileError(QueryCompileError queryCompileError) {
            this.queryCompileError = queryCompileError;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public MalformedQueryException build() {
            return new MalformedQueryException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
