/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteQueryDefinitionResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<DeleteQueryDefinitionResponse.Builder, DeleteQueryDefinitionResponse> {
    private static final SdkField<Boolean> SUCCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("success").getter(getter(DeleteQueryDefinitionResponse::success)).setter(setter(Builder::success))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("success").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean success;

    private DeleteQueryDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.success = builder.success;
    }

    /**
     * <p>
     * A value of TRUE indicates that the operation succeeded. FALSE indicates that the operation failed.
     * </p>
     * 
     * @return A value of TRUE indicates that the operation succeeded. FALSE indicates that the operation failed.
     */
    public final Boolean success() {
        return success;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(success());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteQueryDefinitionResponse)) {
            return false;
        }
        DeleteQueryDefinitionResponse other = (DeleteQueryDefinitionResponse) obj;
        return Objects.equals(success(), other.success());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteQueryDefinitionResponse").add("Success", success()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "success":
            return Optional.ofNullable(clazz.cast(success()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("success", SUCCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteQueryDefinitionResponse, T> g) {
        return obj -> g.apply((DeleteQueryDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteQueryDefinitionResponse> {
        /**
         * <p>
         * A value of TRUE indicates that the operation succeeded. FALSE indicates that the operation failed.
         * </p>
         * 
         * @param success
         *        A value of TRUE indicates that the operation succeeded. FALSE indicates that the operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder success(Boolean success);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private Boolean success;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteQueryDefinitionResponse model) {
            super(model);
            success(model.success);
        }

        public final Boolean getSuccess() {
            return success;
        }

        public final void setSuccess(Boolean success) {
            this.success = success;
        }

        @Override
        public final Builder success(Boolean success) {
            this.success = success;
            return this;
        }

        @Override
        public DeleteQueryDefinitionResponse build() {
            return new DeleteQueryDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
