/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultStartLiveTailVisitorBuilder implements StartLiveTailResponseHandler.Visitor.Builder {
    private Consumer<StartLiveTailResponseStream> onDefault;

    private Consumer<LiveTailSessionStart> onSessionStart;

    private Consumer<LiveTailSessionUpdate> onSessionUpdate;

    @Override
    public StartLiveTailResponseHandler.Visitor.Builder onDefault(Consumer<StartLiveTailResponseStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public StartLiveTailResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public StartLiveTailResponseHandler.Visitor.Builder onSessionStart(Consumer<LiveTailSessionStart> c) {
        this.onSessionStart = c;
        return this;
    }

    @Override
    public StartLiveTailResponseHandler.Visitor.Builder onSessionUpdate(Consumer<LiveTailSessionUpdate> c) {
        this.onSessionUpdate = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements StartLiveTailResponseHandler.Visitor {
        private final Consumer<StartLiveTailResponseStream> onDefault;

        private final Consumer<LiveTailSessionStart> onSessionStart;

        private final Consumer<LiveTailSessionUpdate> onSessionUpdate;

        VisitorFromBuilder(DefaultStartLiveTailVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : StartLiveTailResponseHandler.Visitor.super::visitDefault;
            this.onSessionStart = builder.onSessionStart != null ? builder.onSessionStart
                    : StartLiveTailResponseHandler.Visitor.super::visitSessionStart;
            this.onSessionUpdate = builder.onSessionUpdate != null ? builder.onSessionUpdate
                    : StartLiveTailResponseHandler.Visitor.super::visitSessionUpdate;
        }

        @Override
        public void visitDefault(StartLiveTailResponseStream event) {
            onDefault.accept(event);
        }

        @Override
        public void visitSessionStart(LiveTailSessionStart event) {
            onSessionStart.accept(event);
        }

        @Override
        public void visitSessionUpdate(LiveTailSessionUpdate event) {
            onSessionUpdate.accept(event);
        }
    }
}
