/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.ConfigurationTemplate;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesResponse;

public class DescribeConfigurationTemplatesPublisher
implements SdkPublisher<DescribeConfigurationTemplatesResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final DescribeConfigurationTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeConfigurationTemplatesPublisher(CloudWatchLogsAsyncClient client, DescribeConfigurationTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeConfigurationTemplatesPublisher(CloudWatchLogsAsyncClient client, DescribeConfigurationTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeConfigurationTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeConfigurationTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfigurationTemplate> configurationTemplates() {
        Function<DescribeConfigurationTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationTemplates() != null) {
                return response.configurationTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeConfigurationTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeConfigurationTemplatesResponseFetcher
    implements AsyncPageFetcher<DescribeConfigurationTemplatesResponse> {
        private DescribeConfigurationTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConfigurationTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeConfigurationTemplatesResponse> nextPage(DescribeConfigurationTemplatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeConfigurationTemplatesPublisher.this.client.describeConfigurationTemplates(DescribeConfigurationTemplatesPublisher.this.firstRequest);
            }
            return DescribeConfigurationTemplatesPublisher.this.client.describeConfigurationTemplates((DescribeConfigurationTemplatesRequest)((Object)DescribeConfigurationTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

