/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLogAnomalyDetectorResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<GetLogAnomalyDetectorResponse.Builder, GetLogAnomalyDetectorResponse> {
    private static final SdkField<String> DETECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorName").getter(getter(GetLogAnomalyDetectorResponse::detectorName))
            .setter(setter(Builder::detectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorName").build()).build();

    private static final SdkField<List<String>> LOG_GROUP_ARN_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logGroupArnList")
            .getter(getter(GetLogAnomalyDetectorResponse::logGroupArnList))
            .setter(setter(Builder::logGroupArnList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupArnList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EVALUATION_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evaluationFrequency").getter(getter(GetLogAnomalyDetectorResponse::evaluationFrequencyAsString))
            .setter(setter(Builder::evaluationFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationFrequency").build())
            .build();

    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterPattern").getter(getter(GetLogAnomalyDetectorResponse::filterPattern))
            .setter(setter(Builder::filterPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()).build();

    private static final SdkField<String> ANOMALY_DETECTOR_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("anomalyDetectorStatus").getter(getter(GetLogAnomalyDetectorResponse::anomalyDetectorStatusAsString))
            .setter(setter(Builder::anomalyDetectorStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetectorStatus").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(GetLogAnomalyDetectorResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<Long> CREATION_TIME_STAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("creationTimeStamp").getter(getter(GetLogAnomalyDetectorResponse::creationTimeStamp))
            .setter(setter(Builder::creationTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimeStamp").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_STAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastModifiedTimeStamp").getter(getter(GetLogAnomalyDetectorResponse::lastModifiedTimeStamp))
            .setter(setter(Builder::lastModifiedTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimeStamp").build())
            .build();

    private static final SdkField<Long> ANOMALY_VISIBILITY_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("anomalyVisibilityTime").getter(getter(GetLogAnomalyDetectorResponse::anomalyVisibilityTime))
            .setter(setter(Builder::anomalyVisibilityTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyVisibilityTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_NAME_FIELD,
            LOG_GROUP_ARN_LIST_FIELD, EVALUATION_FREQUENCY_FIELD, FILTER_PATTERN_FIELD, ANOMALY_DETECTOR_STATUS_FIELD,
            KMS_KEY_ID_FIELD, CREATION_TIME_STAMP_FIELD, LAST_MODIFIED_TIME_STAMP_FIELD, ANOMALY_VISIBILITY_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("detectorName", DETECTOR_NAME_FIELD);
                    put("logGroupArnList", LOG_GROUP_ARN_LIST_FIELD);
                    put("evaluationFrequency", EVALUATION_FREQUENCY_FIELD);
                    put("filterPattern", FILTER_PATTERN_FIELD);
                    put("anomalyDetectorStatus", ANOMALY_DETECTOR_STATUS_FIELD);
                    put("kmsKeyId", KMS_KEY_ID_FIELD);
                    put("creationTimeStamp", CREATION_TIME_STAMP_FIELD);
                    put("lastModifiedTimeStamp", LAST_MODIFIED_TIME_STAMP_FIELD);
                    put("anomalyVisibilityTime", ANOMALY_VISIBILITY_TIME_FIELD);
                }
            });

    private final String detectorName;

    private final List<String> logGroupArnList;

    private final String evaluationFrequency;

    private final String filterPattern;

    private final String anomalyDetectorStatus;

    private final String kmsKeyId;

    private final Long creationTimeStamp;

    private final Long lastModifiedTimeStamp;

    private final Long anomalyVisibilityTime;

    private GetLogAnomalyDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.detectorName = builder.detectorName;
        this.logGroupArnList = builder.logGroupArnList;
        this.evaluationFrequency = builder.evaluationFrequency;
        this.filterPattern = builder.filterPattern;
        this.anomalyDetectorStatus = builder.anomalyDetectorStatus;
        this.kmsKeyId = builder.kmsKeyId;
        this.creationTimeStamp = builder.creationTimeStamp;
        this.lastModifiedTimeStamp = builder.lastModifiedTimeStamp;
        this.anomalyVisibilityTime = builder.anomalyVisibilityTime;
    }

    /**
     * <p>
     * The name of the log anomaly detector
     * </p>
     * 
     * @return The name of the log anomaly detector
     */
    public final String detectorName() {
        return detectorName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogGroupArnList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogGroupArnList() {
        return logGroupArnList != null && !(logGroupArnList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures, where each structure contains the ARN of a log group associated with this anomaly
     * detector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogGroupArnList} method.
     * </p>
     * 
     * @return An array of structures, where each structure contains the ARN of a log group associated with this anomaly
     *         detector.
     */
    public final List<String> logGroupArnList() {
        return logGroupArnList;
    }

    /**
     * <p>
     * Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the frequency
     * that the log group receives new logs. For example, if the log group receives new log events every 10 minutes,
     * then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be appropriate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #evaluationFrequency} will return {@link EvaluationFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #evaluationFrequencyAsString}.
     * </p>
     * 
     * @return Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the
     *         frequency that the log group receives new logs. For example, if the log group receives new log events
     *         every 10 minutes, then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be
     *         appropriate.
     * @see EvaluationFrequency
     */
    public final EvaluationFrequency evaluationFrequency() {
        return EvaluationFrequency.fromValue(evaluationFrequency);
    }

    /**
     * <p>
     * Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the frequency
     * that the log group receives new logs. For example, if the log group receives new log events every 10 minutes,
     * then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be appropriate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #evaluationFrequency} will return {@link EvaluationFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #evaluationFrequencyAsString}.
     * </p>
     * 
     * @return Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the
     *         frequency that the log group receives new logs. For example, if the log group receives new log events
     *         every 10 minutes, then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be
     *         appropriate.
     * @see EvaluationFrequency
     */
    public final String evaluationFrequencyAsString() {
        return evaluationFrequency;
    }

    /**
     * Returns the value of the FilterPattern property for this object.
     * 
     * @return The value of the FilterPattern property for this object.
     */
    public final String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * Specifies whether the anomaly detector is currently active. To change its status, use the <code>enabled</code>
     * parameter in the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateLogAnomalyDetector.html"
     * >UpdateLogAnomalyDetector</a> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #anomalyDetectorStatus} will return {@link AnomalyDetectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #anomalyDetectorStatusAsString}.
     * </p>
     * 
     * @return Specifies whether the anomaly detector is currently active. To change its status, use the
     *         <code>enabled</code> parameter in the <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateLogAnomalyDetector.html"
     *         >UpdateLogAnomalyDetector</a> operation.
     * @see AnomalyDetectorStatus
     */
    public final AnomalyDetectorStatus anomalyDetectorStatus() {
        return AnomalyDetectorStatus.fromValue(anomalyDetectorStatus);
    }

    /**
     * <p>
     * Specifies whether the anomaly detector is currently active. To change its status, use the <code>enabled</code>
     * parameter in the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateLogAnomalyDetector.html"
     * >UpdateLogAnomalyDetector</a> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #anomalyDetectorStatus} will return {@link AnomalyDetectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #anomalyDetectorStatusAsString}.
     * </p>
     * 
     * @return Specifies whether the anomaly detector is currently active. To change its status, use the
     *         <code>enabled</code> parameter in the <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateLogAnomalyDetector.html"
     *         >UpdateLogAnomalyDetector</a> operation.
     * @see AnomalyDetectorStatus
     */
    public final String anomalyDetectorStatusAsString() {
        return anomalyDetectorStatus;
    }

    /**
     * <p>
     * The ID of the KMS key assigned to this anomaly detector, if any.
     * </p>
     * 
     * @return The ID of the KMS key assigned to this anomaly detector, if any.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The date and time when this anomaly detector was created.
     * </p>
     * 
     * @return The date and time when this anomaly detector was created.
     */
    public final Long creationTimeStamp() {
        return creationTimeStamp;
    }

    /**
     * <p>
     * The date and time when this anomaly detector was most recently modified.
     * </p>
     * 
     * @return The date and time when this anomaly detector was most recently modified.
     */
    public final Long lastModifiedTimeStamp() {
        return lastModifiedTimeStamp;
    }

    /**
     * <p>
     * The number of days used as the life cycle of anomalies. After this time, anomalies are automatically baselined
     * and the anomaly detector model will treat new occurrences of similar event as normal.
     * </p>
     * 
     * @return The number of days used as the life cycle of anomalies. After this time, anomalies are automatically
     *         baselined and the anomaly detector model will treat new occurrences of similar event as normal.
     */
    public final Long anomalyVisibilityTime() {
        return anomalyVisibilityTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogGroupArnList() ? logGroupArnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyVisibilityTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogAnomalyDetectorResponse)) {
            return false;
        }
        GetLogAnomalyDetectorResponse other = (GetLogAnomalyDetectorResponse) obj;
        return Objects.equals(detectorName(), other.detectorName()) && hasLogGroupArnList() == other.hasLogGroupArnList()
                && Objects.equals(logGroupArnList(), other.logGroupArnList())
                && Objects.equals(evaluationFrequencyAsString(), other.evaluationFrequencyAsString())
                && Objects.equals(filterPattern(), other.filterPattern())
                && Objects.equals(anomalyDetectorStatusAsString(), other.anomalyDetectorStatusAsString())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(creationTimeStamp(), other.creationTimeStamp())
                && Objects.equals(lastModifiedTimeStamp(), other.lastModifiedTimeStamp())
                && Objects.equals(anomalyVisibilityTime(), other.anomalyVisibilityTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLogAnomalyDetectorResponse").add("DetectorName", detectorName())
                .add("LogGroupArnList", hasLogGroupArnList() ? logGroupArnList() : null)
                .add("EvaluationFrequency", evaluationFrequencyAsString()).add("FilterPattern", filterPattern())
                .add("AnomalyDetectorStatus", anomalyDetectorStatusAsString()).add("KmsKeyId", kmsKeyId())
                .add("CreationTimeStamp", creationTimeStamp()).add("LastModifiedTimeStamp", lastModifiedTimeStamp())
                .add("AnomalyVisibilityTime", anomalyVisibilityTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorName":
            return Optional.ofNullable(clazz.cast(detectorName()));
        case "logGroupArnList":
            return Optional.ofNullable(clazz.cast(logGroupArnList()));
        case "evaluationFrequency":
            return Optional.ofNullable(clazz.cast(evaluationFrequencyAsString()));
        case "filterPattern":
            return Optional.ofNullable(clazz.cast(filterPattern()));
        case "anomalyDetectorStatus":
            return Optional.ofNullable(clazz.cast(anomalyDetectorStatusAsString()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "creationTimeStamp":
            return Optional.ofNullable(clazz.cast(creationTimeStamp()));
        case "lastModifiedTimeStamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeStamp()));
        case "anomalyVisibilityTime":
            return Optional.ofNullable(clazz.cast(anomalyVisibilityTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetLogAnomalyDetectorResponse, T> g) {
        return obj -> g.apply((GetLogAnomalyDetectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLogAnomalyDetectorResponse> {
        /**
         * <p>
         * The name of the log anomaly detector
         * </p>
         * 
         * @param detectorName
         *        The name of the log anomaly detector
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorName(String detectorName);

        /**
         * <p>
         * An array of structures, where each structure contains the ARN of a log group associated with this anomaly
         * detector.
         * </p>
         * 
         * @param logGroupArnList
         *        An array of structures, where each structure contains the ARN of a log group associated with this
         *        anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupArnList(Collection<String> logGroupArnList);

        /**
         * <p>
         * An array of structures, where each structure contains the ARN of a log group associated with this anomaly
         * detector.
         * </p>
         * 
         * @param logGroupArnList
         *        An array of structures, where each structure contains the ARN of a log group associated with this
         *        anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupArnList(String... logGroupArnList);

        /**
         * <p>
         * Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the
         * frequency that the log group receives new logs. For example, if the log group receives new log events every
         * 10 minutes, then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be appropriate.
         * </p>
         * 
         * @param evaluationFrequency
         *        Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the
         *        frequency that the log group receives new logs. For example, if the log group receives new log events
         *        every 10 minutes, then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be
         *        appropriate.
         * @see EvaluationFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFrequency
         */
        Builder evaluationFrequency(String evaluationFrequency);

        /**
         * <p>
         * Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the
         * frequency that the log group receives new logs. For example, if the log group receives new log events every
         * 10 minutes, then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be appropriate.
         * </p>
         * 
         * @param evaluationFrequency
         *        Specifies how often the anomaly detector runs and look for anomalies. Set this value according to the
         *        frequency that the log group receives new logs. For example, if the log group receives new log events
         *        every 10 minutes, then setting <code>evaluationFrequency</code> to <code>FIFTEEN_MIN</code> might be
         *        appropriate.
         * @see EvaluationFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFrequency
         */
        Builder evaluationFrequency(EvaluationFrequency evaluationFrequency);

        /**
         * Sets the value of the FilterPattern property for this object.
         *
         * @param filterPattern
         *        The new value for the FilterPattern property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * Specifies whether the anomaly detector is currently active. To change its status, use the
         * <code>enabled</code> parameter in the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateLogAnomalyDetector.html"
         * >UpdateLogAnomalyDetector</a> operation.
         * </p>
         * 
         * @param anomalyDetectorStatus
         *        Specifies whether the anomaly detector is currently active. To change its status, use the
         *        <code>enabled</code> parameter in the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateLogAnomalyDetector.html"
         *        >UpdateLogAnomalyDetector</a> operation.
         * @see AnomalyDetectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalyDetectorStatus
         */
        Builder anomalyDetectorStatus(String anomalyDetectorStatus);

        /**
         * <p>
         * Specifies whether the anomaly detector is currently active. To change its status, use the
         * <code>enabled</code> parameter in the <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateLogAnomalyDetector.html"
         * >UpdateLogAnomalyDetector</a> operation.
         * </p>
         * 
         * @param anomalyDetectorStatus
         *        Specifies whether the anomaly detector is currently active. To change its status, use the
         *        <code>enabled</code> parameter in the <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateLogAnomalyDetector.html"
         *        >UpdateLogAnomalyDetector</a> operation.
         * @see AnomalyDetectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalyDetectorStatus
         */
        Builder anomalyDetectorStatus(AnomalyDetectorStatus anomalyDetectorStatus);

        /**
         * <p>
         * The ID of the KMS key assigned to this anomaly detector, if any.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key assigned to this anomaly detector, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The date and time when this anomaly detector was created.
         * </p>
         * 
         * @param creationTimeStamp
         *        The date and time when this anomaly detector was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeStamp(Long creationTimeStamp);

        /**
         * <p>
         * The date and time when this anomaly detector was most recently modified.
         * </p>
         * 
         * @param lastModifiedTimeStamp
         *        The date and time when this anomaly detector was most recently modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeStamp(Long lastModifiedTimeStamp);

        /**
         * <p>
         * The number of days used as the life cycle of anomalies. After this time, anomalies are automatically
         * baselined and the anomaly detector model will treat new occurrences of similar event as normal.
         * </p>
         * 
         * @param anomalyVisibilityTime
         *        The number of days used as the life cycle of anomalies. After this time, anomalies are automatically
         *        baselined and the anomaly detector model will treat new occurrences of similar event as normal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyVisibilityTime(Long anomalyVisibilityTime);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private String detectorName;

        private List<String> logGroupArnList = DefaultSdkAutoConstructList.getInstance();

        private String evaluationFrequency;

        private String filterPattern;

        private String anomalyDetectorStatus;

        private String kmsKeyId;

        private Long creationTimeStamp;

        private Long lastModifiedTimeStamp;

        private Long anomalyVisibilityTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogAnomalyDetectorResponse model) {
            super(model);
            detectorName(model.detectorName);
            logGroupArnList(model.logGroupArnList);
            evaluationFrequency(model.evaluationFrequency);
            filterPattern(model.filterPattern);
            anomalyDetectorStatus(model.anomalyDetectorStatus);
            kmsKeyId(model.kmsKeyId);
            creationTimeStamp(model.creationTimeStamp);
            lastModifiedTimeStamp(model.lastModifiedTimeStamp);
            anomalyVisibilityTime(model.anomalyVisibilityTime);
        }

        public final String getDetectorName() {
            return detectorName;
        }

        public final void setDetectorName(String detectorName) {
            this.detectorName = detectorName;
        }

        @Override
        public final Builder detectorName(String detectorName) {
            this.detectorName = detectorName;
            return this;
        }

        public final Collection<String> getLogGroupArnList() {
            if (logGroupArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return logGroupArnList;
        }

        public final void setLogGroupArnList(Collection<String> logGroupArnList) {
            this.logGroupArnList = LogGroupArnListCopier.copy(logGroupArnList);
        }

        @Override
        public final Builder logGroupArnList(Collection<String> logGroupArnList) {
            this.logGroupArnList = LogGroupArnListCopier.copy(logGroupArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupArnList(String... logGroupArnList) {
            logGroupArnList(Arrays.asList(logGroupArnList));
            return this;
        }

        public final String getEvaluationFrequency() {
            return evaluationFrequency;
        }

        public final void setEvaluationFrequency(String evaluationFrequency) {
            this.evaluationFrequency = evaluationFrequency;
        }

        @Override
        public final Builder evaluationFrequency(String evaluationFrequency) {
            this.evaluationFrequency = evaluationFrequency;
            return this;
        }

        @Override
        public final Builder evaluationFrequency(EvaluationFrequency evaluationFrequency) {
            this.evaluationFrequency(evaluationFrequency == null ? null : evaluationFrequency.toString());
            return this;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final String getAnomalyDetectorStatus() {
            return anomalyDetectorStatus;
        }

        public final void setAnomalyDetectorStatus(String anomalyDetectorStatus) {
            this.anomalyDetectorStatus = anomalyDetectorStatus;
        }

        @Override
        public final Builder anomalyDetectorStatus(String anomalyDetectorStatus) {
            this.anomalyDetectorStatus = anomalyDetectorStatus;
            return this;
        }

        @Override
        public final Builder anomalyDetectorStatus(AnomalyDetectorStatus anomalyDetectorStatus) {
            this.anomalyDetectorStatus(anomalyDetectorStatus == null ? null : anomalyDetectorStatus.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Long getCreationTimeStamp() {
            return creationTimeStamp;
        }

        public final void setCreationTimeStamp(Long creationTimeStamp) {
            this.creationTimeStamp = creationTimeStamp;
        }

        @Override
        public final Builder creationTimeStamp(Long creationTimeStamp) {
            this.creationTimeStamp = creationTimeStamp;
            return this;
        }

        public final Long getLastModifiedTimeStamp() {
            return lastModifiedTimeStamp;
        }

        public final void setLastModifiedTimeStamp(Long lastModifiedTimeStamp) {
            this.lastModifiedTimeStamp = lastModifiedTimeStamp;
        }

        @Override
        public final Builder lastModifiedTimeStamp(Long lastModifiedTimeStamp) {
            this.lastModifiedTimeStamp = lastModifiedTimeStamp;
            return this;
        }

        public final Long getAnomalyVisibilityTime() {
            return anomalyVisibilityTime;
        }

        public final void setAnomalyVisibilityTime(Long anomalyVisibilityTime) {
            this.anomalyVisibilityTime = anomalyVisibilityTime;
        }

        @Override
        public final Builder anomalyVisibilityTime(Long anomalyVisibilityTime) {
            this.anomalyVisibilityTime = anomalyVisibilityTime;
            return this;
        }

        @Override
        public GetLogAnomalyDetectorResponse build() {
            return new GetLogAnomalyDetectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
