/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDeliveryDestinationRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<PutDeliveryDestinationRequest.Builder, PutDeliveryDestinationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PutDeliveryDestinationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputFormat").getter(getter(PutDeliveryDestinationRequest::outputFormatAsString))
            .setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFormat").build()).build();

    private static final SdkField<DeliveryDestinationConfiguration> DELIVERY_DESTINATION_CONFIGURATION_FIELD = SdkField
            .<DeliveryDestinationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("deliveryDestinationConfiguration")
            .getter(getter(PutDeliveryDestinationRequest::deliveryDestinationConfiguration))
            .setter(setter(Builder::deliveryDestinationConfiguration))
            .constructor(DeliveryDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationConfiguration")
                    .build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(PutDeliveryDestinationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            OUTPUT_FORMAT_FIELD, DELIVERY_DESTINATION_CONFIGURATION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("outputFormat", OUTPUT_FORMAT_FIELD);
                    put("deliveryDestinationConfiguration", DELIVERY_DESTINATION_CONFIGURATION_FIELD);
                    put("tags", TAGS_FIELD);
                }
            });

    private final String name;

    private final String outputFormat;

    private final DeliveryDestinationConfiguration deliveryDestinationConfiguration;

    private final Map<String, String> tags;

    private PutDeliveryDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.outputFormat = builder.outputFormat;
        this.deliveryDestinationConfiguration = builder.deliveryDestinationConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A name for this delivery destination. This name must be unique for all delivery destinations in your account.
     * </p>
     * 
     * @return A name for this delivery destination. This name must be unique for all delivery destinations in your
     *         account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The format for the logs that this delivery destination will receive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The format for the logs that this delivery destination will receive.
     * @see OutputFormat
     */
    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(outputFormat);
    }

    /**
     * <p>
     * The format for the logs that this delivery destination will receive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The format for the logs that this delivery destination will receive.
     * @see OutputFormat
     */
    public final String outputFormatAsString() {
        return outputFormat;
    }

    /**
     * <p>
     * A structure that contains the ARN of the Amazon Web Services resource that will receive the logs.
     * </p>
     * 
     * @return A structure that contains the ARN of the Amazon Web Services resource that will receive the logs.
     */
    public final DeliveryDestinationConfiguration deliveryDestinationConfiguration() {
        return deliveryDestinationConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An optional list of key-value pairs to associate with the resource.
     * </p>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional list of key-value pairs to associate with the resource.</p>
     *         <p>
     *         For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDeliveryDestinationRequest)) {
            return false;
        }
        PutDeliveryDestinationRequest other = (PutDeliveryDestinationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(outputFormatAsString(), other.outputFormatAsString())
                && Objects.equals(deliveryDestinationConfiguration(), other.deliveryDestinationConfiguration())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDeliveryDestinationRequest").add("Name", name()).add("OutputFormat", outputFormatAsString())
                .add("DeliveryDestinationConfiguration", deliveryDestinationConfiguration())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "outputFormat":
            return Optional.ofNullable(clazz.cast(outputFormatAsString()));
        case "deliveryDestinationConfiguration":
            return Optional.ofNullable(clazz.cast(deliveryDestinationConfiguration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutDeliveryDestinationRequest, T> g) {
        return obj -> g.apply((PutDeliveryDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDeliveryDestinationRequest> {
        /**
         * <p>
         * A name for this delivery destination. This name must be unique for all delivery destinations in your account.
         * </p>
         * 
         * @param name
         *        A name for this delivery destination. This name must be unique for all delivery destinations in your
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The format for the logs that this delivery destination will receive.
         * </p>
         * 
         * @param outputFormat
         *        The format for the logs that this delivery destination will receive.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder outputFormat(String outputFormat);

        /**
         * <p>
         * The format for the logs that this delivery destination will receive.
         * </p>
         * 
         * @param outputFormat
         *        The format for the logs that this delivery destination will receive.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder outputFormat(OutputFormat outputFormat);

        /**
         * <p>
         * A structure that contains the ARN of the Amazon Web Services resource that will receive the logs.
         * </p>
         * 
         * @param deliveryDestinationConfiguration
         *        A structure that contains the ARN of the Amazon Web Services resource that will receive the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryDestinationConfiguration(DeliveryDestinationConfiguration deliveryDestinationConfiguration);

        /**
         * <p>
         * A structure that contains the ARN of the Amazon Web Services resource that will receive the logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeliveryDestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DeliveryDestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeliveryDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #deliveryDestinationConfiguration(DeliveryDestinationConfiguration)}.
         * 
         * @param deliveryDestinationConfiguration
         *        a consumer that will call methods on {@link DeliveryDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliveryDestinationConfiguration(DeliveryDestinationConfiguration)
         */
        default Builder deliveryDestinationConfiguration(
                Consumer<DeliveryDestinationConfiguration.Builder> deliveryDestinationConfiguration) {
            return deliveryDestinationConfiguration(DeliveryDestinationConfiguration.builder()
                    .applyMutation(deliveryDestinationConfiguration).build());
        }

        /**
         * <p>
         * An optional list of key-value pairs to associate with the resource.
         * </p>
         * <p>
         * For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a>
         * </p>
         * 
         * @param tags
         *        An optional list of key-value pairs to associate with the resource.</p>
         *        <p>
         *        For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String name;

        private String outputFormat;

        private DeliveryDestinationConfiguration deliveryDestinationConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutDeliveryDestinationRequest model) {
            super(model);
            name(model.name);
            outputFormat(model.outputFormat);
            deliveryDestinationConfiguration(model.deliveryDestinationConfiguration);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final DeliveryDestinationConfiguration.Builder getDeliveryDestinationConfiguration() {
            return deliveryDestinationConfiguration != null ? deliveryDestinationConfiguration.toBuilder() : null;
        }

        public final void setDeliveryDestinationConfiguration(
                DeliveryDestinationConfiguration.BuilderImpl deliveryDestinationConfiguration) {
            this.deliveryDestinationConfiguration = deliveryDestinationConfiguration != null ? deliveryDestinationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder deliveryDestinationConfiguration(DeliveryDestinationConfiguration deliveryDestinationConfiguration) {
            this.deliveryDestinationConfiguration = deliveryDestinationConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDeliveryDestinationRequest build() {
            return new PutDeliveryDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
