/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If you are suppressing an anomaly temporariliy, this structure defines how long the suppression period is to be.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuppressionPeriod implements SdkPojo, Serializable,
        ToCopyableBuilder<SuppressionPeriod.Builder, SuppressionPeriod> {
    private static final SdkField<Integer> VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("value")
            .getter(getter(SuppressionPeriod::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> SUPPRESSION_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suppressionUnit").getter(getter(SuppressionPeriod::suppressionUnitAsString))
            .setter(setter(Builder::suppressionUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressionUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD,
            SUPPRESSION_UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("value", VALUE_FIELD);
                    put("suppressionUnit", SUPPRESSION_UNIT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer value;

    private final String suppressionUnit;

    private SuppressionPeriod(BuilderImpl builder) {
        this.value = builder.value;
        this.suppressionUnit = builder.suppressionUnit;
    }

    /**
     * <p>
     * Specifies the number of seconds, minutes or hours to suppress this anomaly. There is no maximum.
     * </p>
     * 
     * @return Specifies the number of seconds, minutes or hours to suppress this anomaly. There is no maximum.
     */
    public final Integer value() {
        return value;
    }

    /**
     * <p>
     * Specifies whether the value of <code>value</code> is in seconds, minutes, or hours.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #suppressionUnit}
     * will return {@link SuppressionUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #suppressionUnitAsString}.
     * </p>
     * 
     * @return Specifies whether the value of <code>value</code> is in seconds, minutes, or hours.
     * @see SuppressionUnit
     */
    public final SuppressionUnit suppressionUnit() {
        return SuppressionUnit.fromValue(suppressionUnit);
    }

    /**
     * <p>
     * Specifies whether the value of <code>value</code> is in seconds, minutes, or hours.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #suppressionUnit}
     * will return {@link SuppressionUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #suppressionUnitAsString}.
     * </p>
     * 
     * @return Specifies whether the value of <code>value</code> is in seconds, minutes, or hours.
     * @see SuppressionUnit
     */
    public final String suppressionUnitAsString() {
        return suppressionUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(suppressionUnitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuppressionPeriod)) {
            return false;
        }
        SuppressionPeriod other = (SuppressionPeriod) obj;
        return Objects.equals(value(), other.value())
                && Objects.equals(suppressionUnitAsString(), other.suppressionUnitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuppressionPeriod").add("Value", value()).add("SuppressionUnit", suppressionUnitAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "suppressionUnit":
            return Optional.ofNullable(clazz.cast(suppressionUnitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SuppressionPeriod, T> g) {
        return obj -> g.apply((SuppressionPeriod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuppressionPeriod> {
        /**
         * <p>
         * Specifies the number of seconds, minutes or hours to suppress this anomaly. There is no maximum.
         * </p>
         * 
         * @param value
         *        Specifies the number of seconds, minutes or hours to suppress this anomaly. There is no maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Integer value);

        /**
         * <p>
         * Specifies whether the value of <code>value</code> is in seconds, minutes, or hours.
         * </p>
         * 
         * @param suppressionUnit
         *        Specifies whether the value of <code>value</code> is in seconds, minutes, or hours.
         * @see SuppressionUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuppressionUnit
         */
        Builder suppressionUnit(String suppressionUnit);

        /**
         * <p>
         * Specifies whether the value of <code>value</code> is in seconds, minutes, or hours.
         * </p>
         * 
         * @param suppressionUnit
         *        Specifies whether the value of <code>value</code> is in seconds, minutes, or hours.
         * @see SuppressionUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuppressionUnit
         */
        Builder suppressionUnit(SuppressionUnit suppressionUnit);
    }

    static final class BuilderImpl implements Builder {
        private Integer value;

        private String suppressionUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(SuppressionPeriod model) {
            value(model.value);
            suppressionUnit(model.suppressionUnit);
        }

        public final Integer getValue() {
            return value;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        public final String getSuppressionUnit() {
            return suppressionUnit;
        }

        public final void setSuppressionUnit(String suppressionUnit) {
            this.suppressionUnit = suppressionUnit;
        }

        @Override
        public final Builder suppressionUnit(String suppressionUnit) {
            this.suppressionUnit = suppressionUnit;
            return this;
        }

        @Override
        public final Builder suppressionUnit(SuppressionUnit suppressionUnit) {
            this.suppressionUnit(suppressionUnit == null ? null : suppressionUnit.toString());
            return this;
        }

        @Override
        public SuppressionPeriod build() {
            return new SuppressionPeriod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
