/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about one pattern token related to an anomaly.
 * </p>
 * <p>
 * For more information about patterns and tokens, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateLogAnomalyDetector.html"
 * >CreateLogAnomalyDetector</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PatternToken implements SdkPojo, Serializable, ToCopyableBuilder<PatternToken.Builder, PatternToken> {
    private static final SdkField<Integer> DYNAMIC_TOKEN_POSITION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("dynamicTokenPosition").getter(getter(PatternToken::dynamicTokenPosition))
            .setter(setter(Builder::dynamicTokenPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicTokenPosition").build())
            .build();

    private static final SdkField<Boolean> IS_DYNAMIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isDynamic").getter(getter(PatternToken::isDynamic)).setter(setter(Builder::isDynamic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDynamic").build()).build();

    private static final SdkField<String> TOKEN_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenString").getter(getter(PatternToken::tokenString)).setter(setter(Builder::tokenString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenString").build()).build();

    private static final SdkField<Map<String, Long>> ENUMERATIONS_FIELD = SdkField
            .<Map<String, Long>> builder(MarshallingType.MAP)
            .memberName("enumerations")
            .getter(getter(PatternToken::enumerations))
            .setter(setter(Builder::enumerations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enumerations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMIC_TOKEN_POSITION_FIELD,
            IS_DYNAMIC_FIELD, TOKEN_STRING_FIELD, ENUMERATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer dynamicTokenPosition;

    private final Boolean isDynamic;

    private final String tokenString;

    private final Map<String, Long> enumerations;

    private PatternToken(BuilderImpl builder) {
        this.dynamicTokenPosition = builder.dynamicTokenPosition;
        this.isDynamic = builder.isDynamic;
        this.tokenString = builder.tokenString;
        this.enumerations = builder.enumerations;
    }

    /**
     * <p>
     * For a dynamic token, this indicates where in the pattern that this token appears, related to other dynamic
     * tokens. The dynamic token that appears first has a value of <code>1</code>, the one that appears second is
     * <code>2</code>, and so on.
     * </p>
     * 
     * @return For a dynamic token, this indicates where in the pattern that this token appears, related to other
     *         dynamic tokens. The dynamic token that appears first has a value of <code>1</code>, the one that appears
     *         second is <code>2</code>, and so on.
     */
    public final Integer dynamicTokenPosition() {
        return dynamicTokenPosition;
    }

    /**
     * <p>
     * Specifies whether this is a dynamic token.
     * </p>
     * 
     * @return Specifies whether this is a dynamic token.
     */
    public final Boolean isDynamic() {
        return isDynamic;
    }

    /**
     * <p>
     * The string represented by this token. If this is a dynamic token, the value will be <code>&lt;*&gt;</code>
     * </p>
     * 
     * @return The string represented by this token. If this is a dynamic token, the value will be
     *         <code>&lt;*&gt;</code>
     */
    public final String tokenString() {
        return tokenString;
    }

    /**
     * For responses, this returns true if the service returned a value for the Enumerations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnumerations() {
        return enumerations != null && !(enumerations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Contains the values found for a dynamic token, and the number of times each value was found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnumerations} method.
     * </p>
     * 
     * @return Contains the values found for a dynamic token, and the number of times each value was found.
     */
    public final Map<String, Long> enumerations() {
        return enumerations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dynamicTokenPosition());
        hashCode = 31 * hashCode + Objects.hashCode(isDynamic());
        hashCode = 31 * hashCode + Objects.hashCode(tokenString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnumerations() ? enumerations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatternToken)) {
            return false;
        }
        PatternToken other = (PatternToken) obj;
        return Objects.equals(dynamicTokenPosition(), other.dynamicTokenPosition())
                && Objects.equals(isDynamic(), other.isDynamic()) && Objects.equals(tokenString(), other.tokenString())
                && hasEnumerations() == other.hasEnumerations() && Objects.equals(enumerations(), other.enumerations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PatternToken").add("DynamicTokenPosition", dynamicTokenPosition()).add("IsDynamic", isDynamic())
                .add("TokenString", tokenString()).add("Enumerations", hasEnumerations() ? enumerations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dynamicTokenPosition":
            return Optional.ofNullable(clazz.cast(dynamicTokenPosition()));
        case "isDynamic":
            return Optional.ofNullable(clazz.cast(isDynamic()));
        case "tokenString":
            return Optional.ofNullable(clazz.cast(tokenString()));
        case "enumerations":
            return Optional.ofNullable(clazz.cast(enumerations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatternToken, T> g) {
        return obj -> g.apply((PatternToken) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PatternToken> {
        /**
         * <p>
         * For a dynamic token, this indicates where in the pattern that this token appears, related to other dynamic
         * tokens. The dynamic token that appears first has a value of <code>1</code>, the one that appears second is
         * <code>2</code>, and so on.
         * </p>
         * 
         * @param dynamicTokenPosition
         *        For a dynamic token, this indicates where in the pattern that this token appears, related to other
         *        dynamic tokens. The dynamic token that appears first has a value of <code>1</code>, the one that
         *        appears second is <code>2</code>, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicTokenPosition(Integer dynamicTokenPosition);

        /**
         * <p>
         * Specifies whether this is a dynamic token.
         * </p>
         * 
         * @param isDynamic
         *        Specifies whether this is a dynamic token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDynamic(Boolean isDynamic);

        /**
         * <p>
         * The string represented by this token. If this is a dynamic token, the value will be <code>&lt;*&gt;</code>
         * </p>
         * 
         * @param tokenString
         *        The string represented by this token. If this is a dynamic token, the value will be
         *        <code>&lt;*&gt;</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenString(String tokenString);

        /**
         * <p>
         * Contains the values found for a dynamic token, and the number of times each value was found.
         * </p>
         * 
         * @param enumerations
         *        Contains the values found for a dynamic token, and the number of times each value was found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumerations(Map<String, Long> enumerations);
    }

    static final class BuilderImpl implements Builder {
        private Integer dynamicTokenPosition;

        private Boolean isDynamic;

        private String tokenString;

        private Map<String, Long> enumerations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PatternToken model) {
            dynamicTokenPosition(model.dynamicTokenPosition);
            isDynamic(model.isDynamic);
            tokenString(model.tokenString);
            enumerations(model.enumerations);
        }

        public final Integer getDynamicTokenPosition() {
            return dynamicTokenPosition;
        }

        public final void setDynamicTokenPosition(Integer dynamicTokenPosition) {
            this.dynamicTokenPosition = dynamicTokenPosition;
        }

        @Override
        public final Builder dynamicTokenPosition(Integer dynamicTokenPosition) {
            this.dynamicTokenPosition = dynamicTokenPosition;
            return this;
        }

        public final Boolean getIsDynamic() {
            return isDynamic;
        }

        public final void setIsDynamic(Boolean isDynamic) {
            this.isDynamic = isDynamic;
        }

        @Override
        public final Builder isDynamic(Boolean isDynamic) {
            this.isDynamic = isDynamic;
            return this;
        }

        public final String getTokenString() {
            return tokenString;
        }

        public final void setTokenString(String tokenString) {
            this.tokenString = tokenString;
        }

        @Override
        public final Builder tokenString(String tokenString) {
            this.tokenString = tokenString;
            return this;
        }

        public final Map<String, Long> getEnumerations() {
            if (enumerations instanceof SdkAutoConstructMap) {
                return null;
            }
            return enumerations;
        }

        public final void setEnumerations(Map<String, Long> enumerations) {
            this.enumerations = EnumerationsCopier.copy(enumerations);
        }

        @Override
        public final Builder enumerations(Map<String, Long> enumerations) {
            this.enumerations = EnumerationsCopier.copy(enumerations);
            return this;
        }

        @Override
        public PatternToken build() {
            return new PatternToken(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
