/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest;

public class SetAlarmStateRequestMarshaller
implements Marshaller<Request<SetAlarmStateRequest>, SetAlarmStateRequest> {
    public Request<SetAlarmStateRequest> marshall(SetAlarmStateRequest setAlarmStateRequest) {
        if (setAlarmStateRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setAlarmStateRequest, "CloudWatchClient");
        request.addParameter("Action", "SetAlarmState");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setAlarmStateRequest.alarmName() != null) {
            request.addParameter("AlarmName", StringConversion.fromString((String)setAlarmStateRequest.alarmName()));
        }
        if (setAlarmStateRequest.stateValueAsString() != null) {
            request.addParameter("StateValue", StringConversion.fromString((String)setAlarmStateRequest.stateValueAsString()));
        }
        if (setAlarmStateRequest.stateReason() != null) {
            request.addParameter("StateReason", StringConversion.fromString((String)setAlarmStateRequest.stateReason()));
        }
        if (setAlarmStateRequest.stateReasonData() != null) {
            request.addParameter("StateReasonData", StringConversion.fromString((String)setAlarmStateRequest.stateReasonData()));
        }
        return request;
    }
}

