/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest;

public class GetDashboardRequestMarshaller
implements Marshaller<Request<GetDashboardRequest>, GetDashboardRequest> {
    public Request<GetDashboardRequest> marshall(GetDashboardRequest getDashboardRequest) {
        if (getDashboardRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getDashboardRequest, "CloudWatchClient");
        request.addParameter("Action", "GetDashboard");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getDashboardRequest.dashboardName() != null) {
            request.addParameter("DashboardName", StringConversion.fromString((String)getDashboardRequest.dashboardName()));
        }
        return request;
    }
}

