/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest;

public class DisableAlarmActionsRequestMarshaller
implements Marshaller<Request<DisableAlarmActionsRequest>, DisableAlarmActionsRequest> {
    public Request<DisableAlarmActionsRequest> marshall(DisableAlarmActionsRequest disableAlarmActionsRequest) {
        if (disableAlarmActionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)disableAlarmActionsRequest, "CloudWatchClient");
        request.addParameter("Action", "DisableAlarmActions");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (disableAlarmActionsRequest.alarmNames().isEmpty() && !(disableAlarmActionsRequest.alarmNames() instanceof SdkAutoConstructList)) {
            request.addParameter("AlarmNames", "");
        } else if (!disableAlarmActionsRequest.alarmNames().isEmpty() && !(disableAlarmActionsRequest.alarmNames() instanceof SdkAutoConstructList)) {
            List<String> alarmNamesList = disableAlarmActionsRequest.alarmNames();
            int alarmNamesListIndex = 1;
            for (String alarmNamesListValue : alarmNamesList) {
                if (alarmNamesListValue != null) {
                    request.addParameter("AlarmNames.member." + alarmNamesListIndex, StringConversion.fromString((String)alarmNamesListValue));
                }
                ++alarmNamesListIndex;
            }
        }
        return request;
    }
}

