/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;

public class DescribeAlarmsRequestMarshaller
implements Marshaller<Request<DescribeAlarmsRequest>, DescribeAlarmsRequest> {
    public Request<DescribeAlarmsRequest> marshall(DescribeAlarmsRequest describeAlarmsRequest) {
        if (describeAlarmsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeAlarmsRequest, "CloudWatchClient");
        request.addParameter("Action", "DescribeAlarms");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAlarmsRequest.alarmNames().isEmpty() && !(describeAlarmsRequest.alarmNames() instanceof SdkAutoConstructList)) {
            request.addParameter("AlarmNames", "");
        } else if (!describeAlarmsRequest.alarmNames().isEmpty() && !(describeAlarmsRequest.alarmNames() instanceof SdkAutoConstructList)) {
            List<String> alarmNamesList = describeAlarmsRequest.alarmNames();
            int alarmNamesListIndex = 1;
            for (String alarmNamesListValue : alarmNamesList) {
                if (alarmNamesListValue != null) {
                    request.addParameter("AlarmNames.member." + alarmNamesListIndex, StringConversion.fromString((String)alarmNamesListValue));
                }
                ++alarmNamesListIndex;
            }
        }
        if (describeAlarmsRequest.alarmNamePrefix() != null) {
            request.addParameter("AlarmNamePrefix", StringConversion.fromString((String)describeAlarmsRequest.alarmNamePrefix()));
        }
        if (describeAlarmsRequest.stateValueAsString() != null) {
            request.addParameter("StateValue", StringConversion.fromString((String)describeAlarmsRequest.stateValueAsString()));
        }
        if (describeAlarmsRequest.actionPrefix() != null) {
            request.addParameter("ActionPrefix", StringConversion.fromString((String)describeAlarmsRequest.actionPrefix()));
        }
        if (describeAlarmsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeAlarmsRequest.maxRecords()));
        }
        if (describeAlarmsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeAlarmsRequest.nextToken()));
        }
        return request;
    }
}

