/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionsCopier;
import software.amazon.awssdk.services.cloudwatch.model.ResourceListCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.Statistic;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMetricAlarmRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, PutMetricAlarmRequest> {
    private final String alarmName;
    private final String alarmDescription;
    private final Boolean actionsEnabled;
    private final List<String> okActions;
    private final List<String> alarmActions;
    private final List<String> insufficientDataActions;
    private final String metricName;
    private final String namespace;
    private final String statistic;
    private final String extendedStatistic;
    private final List<Dimension> dimensions;
    private final Integer period;
    private final String unit;
    private final Integer evaluationPeriods;
    private final Integer datapointsToAlarm;
    private final Double threshold;
    private final String comparisonOperator;
    private final String treatMissingData;
    private final String evaluateLowSampleCountPercentile;

    private PutMetricAlarmRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.alarmDescription = builder.alarmDescription;
        this.actionsEnabled = builder.actionsEnabled;
        this.okActions = builder.okActions;
        this.alarmActions = builder.alarmActions;
        this.insufficientDataActions = builder.insufficientDataActions;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.statistic = builder.statistic;
        this.extendedStatistic = builder.extendedStatistic;
        this.dimensions = builder.dimensions;
        this.period = builder.period;
        this.unit = builder.unit;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.datapointsToAlarm = builder.datapointsToAlarm;
        this.threshold = builder.threshold;
        this.comparisonOperator = builder.comparisonOperator;
        this.treatMissingData = builder.treatMissingData;
        this.evaluateLowSampleCountPercentile = builder.evaluateLowSampleCountPercentile;
    }

    public String alarmName() {
        return this.alarmName;
    }

    public String alarmDescription() {
        return this.alarmDescription;
    }

    public Boolean actionsEnabled() {
        return this.actionsEnabled;
    }

    public List<String> okActions() {
        return this.okActions;
    }

    public List<String> alarmActions() {
        return this.alarmActions;
    }

    public List<String> insufficientDataActions() {
        return this.insufficientDataActions;
    }

    public String metricName() {
        return this.metricName;
    }

    public String namespace() {
        return this.namespace;
    }

    public Statistic statistic() {
        return Statistic.fromValue(this.statistic);
    }

    public String statisticAsString() {
        return this.statistic;
    }

    public String extendedStatistic() {
        return this.extendedStatistic;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Integer period() {
        return this.period;
    }

    public StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public String unitAsString() {
        return this.unit;
    }

    public Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public Integer datapointsToAlarm() {
        return this.datapointsToAlarm;
    }

    public Double threshold() {
        return this.threshold;
    }

    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public String treatMissingData() {
        return this.treatMissingData;
    }

    public String evaluateLowSampleCountPercentile() {
        return this.evaluateLowSampleCountPercentile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.okActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.insufficientDataActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedStatistic());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(this.datapointsToAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatMissingData());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluateLowSampleCountPercentile());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricAlarmRequest)) {
            return false;
        }
        PutMetricAlarmRequest other = (PutMetricAlarmRequest)((Object)obj);
        return Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.alarmDescription(), other.alarmDescription()) && Objects.equals(this.actionsEnabled(), other.actionsEnabled()) && Objects.equals(this.okActions(), other.okActions()) && Objects.equals(this.alarmActions(), other.alarmActions()) && Objects.equals(this.insufficientDataActions(), other.insufficientDataActions()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && Objects.equals(this.extendedStatistic(), other.extendedStatistic()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.evaluationPeriods(), other.evaluationPeriods()) && Objects.equals(this.datapointsToAlarm(), other.datapointsToAlarm()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.treatMissingData(), other.treatMissingData()) && Objects.equals(this.evaluateLowSampleCountPercentile(), other.evaluateLowSampleCountPercentile());
    }

    public String toString() {
        return ToString.builder((String)"PutMetricAlarmRequest").add("AlarmName", (Object)this.alarmName()).add("AlarmDescription", (Object)this.alarmDescription()).add("ActionsEnabled", (Object)this.actionsEnabled()).add("OKActions", this.okActions()).add("AlarmActions", this.alarmActions()).add("InsufficientDataActions", this.insufficientDataActions()).add("MetricName", (Object)this.metricName()).add("Namespace", (Object)this.namespace()).add("Statistic", (Object)this.statisticAsString()).add("ExtendedStatistic", (Object)this.extendedStatistic()).add("Dimensions", this.dimensions()).add("Period", (Object)this.period()).add("Unit", (Object)this.unitAsString()).add("EvaluationPeriods", (Object)this.evaluationPeriods()).add("DatapointsToAlarm", (Object)this.datapointsToAlarm()).add("Threshold", (Object)this.threshold()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("TreatMissingData", (Object)this.treatMissingData()).add("EvaluateLowSampleCountPercentile", (Object)this.evaluateLowSampleCountPercentile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmName": {
                return Optional.ofNullable(clazz.cast(this.alarmName()));
            }
            case "AlarmDescription": {
                return Optional.ofNullable(clazz.cast(this.alarmDescription()));
            }
            case "ActionsEnabled": {
                return Optional.ofNullable(clazz.cast(this.actionsEnabled()));
            }
            case "OKActions": {
                return Optional.ofNullable(clazz.cast(this.okActions()));
            }
            case "AlarmActions": {
                return Optional.ofNullable(clazz.cast(this.alarmActions()));
            }
            case "InsufficientDataActions": {
                return Optional.ofNullable(clazz.cast(this.insufficientDataActions()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "Statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "ExtendedStatistic": {
                return Optional.ofNullable(clazz.cast(this.extendedStatistic()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "EvaluationPeriods": {
                return Optional.ofNullable(clazz.cast(this.evaluationPeriods()));
            }
            case "DatapointsToAlarm": {
                return Optional.ofNullable(clazz.cast(this.datapointsToAlarm()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "TreatMissingData": {
                return Optional.ofNullable(clazz.cast(this.treatMissingData()));
            }
            case "EvaluateLowSampleCountPercentile": {
                return Optional.ofNullable(clazz.cast(this.evaluateLowSampleCountPercentile()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String alarmName;
        private String alarmDescription;
        private Boolean actionsEnabled;
        private List<String> okActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> alarmActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> insufficientDataActions = DefaultSdkAutoConstructList.getInstance();
        private String metricName;
        private String namespace;
        private String statistic;
        private String extendedStatistic;
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private Integer period;
        private String unit;
        private Integer evaluationPeriods;
        private Integer datapointsToAlarm;
        private Double threshold;
        private String comparisonOperator;
        private String treatMissingData;
        private String evaluateLowSampleCountPercentile;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricAlarmRequest model) {
            super(model);
            this.alarmName(model.alarmName);
            this.alarmDescription(model.alarmDescription);
            this.actionsEnabled(model.actionsEnabled);
            this.okActions(model.okActions);
            this.alarmActions(model.alarmActions);
            this.insufficientDataActions(model.insufficientDataActions);
            this.metricName(model.metricName);
            this.namespace(model.namespace);
            this.statistic(model.statistic);
            this.extendedStatistic(model.extendedStatistic);
            this.dimensions(model.dimensions);
            this.period(model.period);
            this.unit(model.unit);
            this.evaluationPeriods(model.evaluationPeriods);
            this.datapointsToAlarm(model.datapointsToAlarm);
            this.threshold(model.threshold);
            this.comparisonOperator(model.comparisonOperator);
            this.treatMissingData(model.treatMissingData);
            this.evaluateLowSampleCountPercentile(model.evaluateLowSampleCountPercentile);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getAlarmDescription() {
            return this.alarmDescription;
        }

        @Override
        public final Builder alarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        public final void setAlarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
        }

        public final Boolean getActionsEnabled() {
            return this.actionsEnabled;
        }

        @Override
        public final Builder actionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        public final void setActionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
        }

        public final Collection<String> getOKActions() {
            return this.okActions;
        }

        @Override
        public final Builder okActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder okActions(String ... okActions) {
            this.okActions(Arrays.asList(okActions));
            return this;
        }

        public final void setOKActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
        }

        public final Collection<String> getAlarmActions() {
            return this.alarmActions;
        }

        @Override
        public final Builder alarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmActions(String ... alarmActions) {
            this.alarmActions(Arrays.asList(alarmActions));
            return this;
        }

        public final void setAlarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
        }

        public final Collection<String> getInsufficientDataActions() {
            return this.insufficientDataActions;
        }

        @Override
        public final Builder insufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insufficientDataActions(String ... insufficientDataActions) {
            this.insufficientDataActions(Arrays.asList(insufficientDataActions));
            return this;
        }

        public final void setInsufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final String getExtendedStatistic() {
            return this.extendedStatistic;
        }

        @Override
        public final Builder extendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
            return this;
        }

        public final void setExtendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
        }

        public final Collection<Dimension.Builder> getDimensions() {
            return this.dimensions != null ? (Collection)this.dimensions.stream().map(Dimension::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (Dimension)((Dimension.Builder)Dimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final Integer getDatapointsToAlarm() {
            return this.datapointsToAlarm;
        }

        @Override
        public final Builder datapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        public final void setDatapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final String getTreatMissingData() {
            return this.treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        public final String getEvaluateLowSampleCountPercentile() {
            return this.evaluateLowSampleCountPercentile;
        }

        @Override
        public final Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
            return this;
        }

        public final void setEvaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetricAlarmRequest build() {
            return new PutMetricAlarmRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    CopyableBuilder<Builder, PutMetricAlarmRequest> {
        public Builder alarmName(String var1);

        public Builder alarmDescription(String var1);

        public Builder actionsEnabled(Boolean var1);

        public Builder okActions(Collection<String> var1);

        public Builder okActions(String ... var1);

        public Builder alarmActions(Collection<String> var1);

        public Builder alarmActions(String ... var1);

        public Builder insufficientDataActions(Collection<String> var1);

        public Builder insufficientDataActions(String ... var1);

        public Builder metricName(String var1);

        public Builder namespace(String var1);

        public Builder statistic(String var1);

        public Builder statistic(Statistic var1);

        public Builder extendedStatistic(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder dimensions(Consumer<Dimension.Builder> ... var1);

        public Builder period(Integer var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder datapointsToAlarm(Integer var1);

        public Builder threshold(Double var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder treatMissingData(String var1);

        public Builder evaluateLowSampleCountPercentile(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

