/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchException;
import software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage;
import software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessagesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashboardInvalidInputErrorException
extends CloudWatchException
implements ToCopyableBuilder<Builder, DashboardInvalidInputErrorException> {
    private final List<DashboardValidationMessage> dashboardValidationMessages;

    private DashboardInvalidInputErrorException(BuilderImpl builder) {
        super(builder);
        this.dashboardValidationMessages = builder.dashboardValidationMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public List<DashboardValidationMessage> dashboardValidationMessages() {
        return this.dashboardValidationMessages;
    }

    static final class BuilderImpl
    extends CloudWatchException.BuilderImpl
    implements Builder {
        private List<DashboardValidationMessage> dashboardValidationMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardInvalidInputErrorException model) {
            super(model);
            this.dashboardValidationMessages(model.dashboardValidationMessages);
        }

        public final Collection<DashboardValidationMessage.Builder> getDashboardValidationMessages() {
            return this.dashboardValidationMessages != null ? (Collection)this.dashboardValidationMessages.stream().map(DashboardValidationMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dashboardValidationMessages(Collection<DashboardValidationMessage> dashboardValidationMessages) {
            this.dashboardValidationMessages = DashboardValidationMessagesCopier.copy(dashboardValidationMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardValidationMessages(DashboardValidationMessage ... dashboardValidationMessages) {
            this.dashboardValidationMessages(Arrays.asList(dashboardValidationMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardValidationMessages(Consumer<DashboardValidationMessage.Builder> ... dashboardValidationMessages) {
            this.dashboardValidationMessages(Stream.of(dashboardValidationMessages).map(c -> (DashboardValidationMessage)((DashboardValidationMessage.Builder)DashboardValidationMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDashboardValidationMessages(Collection<DashboardValidationMessage.BuilderImpl> dashboardValidationMessages) {
            this.dashboardValidationMessages = DashboardValidationMessagesCopier.copyFromBuilder(dashboardValidationMessages);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public DashboardInvalidInputErrorException build() {
            return new DashboardInvalidInputErrorException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DashboardInvalidInputErrorException>,
    CloudWatchException.Builder {
        public Builder dashboardValidationMessages(Collection<DashboardValidationMessage> var1);

        public Builder dashboardValidationMessages(DashboardValidationMessage ... var1);

        public Builder dashboardValidationMessages(Consumer<DashboardValidationMessage.Builder> ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

