/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * PutMetricAlarmRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutMetricAlarmRequestMarshaller implements Marshaller<Request<PutMetricAlarmRequest>, PutMetricAlarmRequest> {

    public Request<PutMetricAlarmRequest> marshall(PutMetricAlarmRequest putMetricAlarmRequest) {

        if (putMetricAlarmRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<PutMetricAlarmRequest> request = new DefaultRequest<PutMetricAlarmRequest>(putMetricAlarmRequest,
                "CloudWatchClient");
        request.addParameter("Action", "PutMetricAlarm");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (putMetricAlarmRequest.alarmName() != null) {
            request.addParameter("AlarmName", StringConversion.fromString(putMetricAlarmRequest.alarmName()));
        }

        if (putMetricAlarmRequest.alarmDescription() != null) {
            request.addParameter("AlarmDescription", StringConversion.fromString(putMetricAlarmRequest.alarmDescription()));
        }

        if (putMetricAlarmRequest.actionsEnabled() != null) {
            request.addParameter("ActionsEnabled", StringConversion.fromBoolean(putMetricAlarmRequest.actionsEnabled()));
        }

        if (putMetricAlarmRequest.okActions().isEmpty()
                && !(putMetricAlarmRequest.okActions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("OKActions", "");
        } else if (!putMetricAlarmRequest.okActions().isEmpty()
                && !(putMetricAlarmRequest.okActions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> oKActionsList = putMetricAlarmRequest.okActions();
            int oKActionsListIndex = 1;

            for (String oKActionsListValue : oKActionsList) {
                if (oKActionsListValue != null) {
                    request.addParameter("OKActions.member." + oKActionsListIndex,
                            StringConversion.fromString(oKActionsListValue));
                }
                oKActionsListIndex++;
            }
        }

        if (putMetricAlarmRequest.alarmActions().isEmpty()
                && !(putMetricAlarmRequest.alarmActions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("AlarmActions", "");
        } else if (!putMetricAlarmRequest.alarmActions().isEmpty()
                && !(putMetricAlarmRequest.alarmActions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> alarmActionsList = putMetricAlarmRequest.alarmActions();
            int alarmActionsListIndex = 1;

            for (String alarmActionsListValue : alarmActionsList) {
                if (alarmActionsListValue != null) {
                    request.addParameter("AlarmActions.member." + alarmActionsListIndex,
                            StringConversion.fromString(alarmActionsListValue));
                }
                alarmActionsListIndex++;
            }
        }

        if (putMetricAlarmRequest.insufficientDataActions().isEmpty()
                && !(putMetricAlarmRequest.insufficientDataActions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("InsufficientDataActions", "");
        } else if (!putMetricAlarmRequest.insufficientDataActions().isEmpty()
                && !(putMetricAlarmRequest.insufficientDataActions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> insufficientDataActionsList = putMetricAlarmRequest.insufficientDataActions();
            int insufficientDataActionsListIndex = 1;

            for (String insufficientDataActionsListValue : insufficientDataActionsList) {
                if (insufficientDataActionsListValue != null) {
                    request.addParameter("InsufficientDataActions.member." + insufficientDataActionsListIndex,
                            StringConversion.fromString(insufficientDataActionsListValue));
                }
                insufficientDataActionsListIndex++;
            }
        }

        if (putMetricAlarmRequest.metricName() != null) {
            request.addParameter("MetricName", StringConversion.fromString(putMetricAlarmRequest.metricName()));
        }

        if (putMetricAlarmRequest.namespace() != null) {
            request.addParameter("Namespace", StringConversion.fromString(putMetricAlarmRequest.namespace()));
        }

        if (putMetricAlarmRequest.statisticAsString() != null) {
            request.addParameter("Statistic", StringConversion.fromString(putMetricAlarmRequest.statisticAsString()));
        }

        if (putMetricAlarmRequest.extendedStatistic() != null) {
            request.addParameter("ExtendedStatistic", StringConversion.fromString(putMetricAlarmRequest.extendedStatistic()));
        }

        if (putMetricAlarmRequest.dimensions().isEmpty()
                && !(putMetricAlarmRequest.dimensions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Dimensions", "");
        } else if (!putMetricAlarmRequest.dimensions().isEmpty()
                && !(putMetricAlarmRequest.dimensions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Dimension> dimensionsList = putMetricAlarmRequest.dimensions();
            int dimensionsListIndex = 1;

            for (Dimension dimensionsListValue : dimensionsList) {

                if (dimensionsListValue.name() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name",
                            StringConversion.fromString(dimensionsListValue.name()));
                }

                if (dimensionsListValue.value() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value",
                            StringConversion.fromString(dimensionsListValue.value()));
                }
                dimensionsListIndex++;
            }
        }

        if (putMetricAlarmRequest.period() != null) {
            request.addParameter("Period", StringConversion.fromInteger(putMetricAlarmRequest.period()));
        }

        if (putMetricAlarmRequest.unitAsString() != null) {
            request.addParameter("Unit", StringConversion.fromString(putMetricAlarmRequest.unitAsString()));
        }

        if (putMetricAlarmRequest.evaluationPeriods() != null) {
            request.addParameter("EvaluationPeriods", StringConversion.fromInteger(putMetricAlarmRequest.evaluationPeriods()));
        }

        if (putMetricAlarmRequest.datapointsToAlarm() != null) {
            request.addParameter("DatapointsToAlarm", StringConversion.fromInteger(putMetricAlarmRequest.datapointsToAlarm()));
        }

        if (putMetricAlarmRequest.threshold() != null) {
            request.addParameter("Threshold", StringConversion.fromDouble(putMetricAlarmRequest.threshold()));
        }

        if (putMetricAlarmRequest.comparisonOperatorAsString() != null) {
            request.addParameter("ComparisonOperator",
                    StringConversion.fromString(putMetricAlarmRequest.comparisonOperatorAsString()));
        }

        if (putMetricAlarmRequest.treatMissingData() != null) {
            request.addParameter("TreatMissingData", StringConversion.fromString(putMetricAlarmRequest.treatMissingData()));
        }

        if (putMetricAlarmRequest.evaluateLowSampleCountPercentile() != null) {
            request.addParameter("EvaluateLowSampleCountPercentile",
                    StringConversion.fromString(putMetricAlarmRequest.evaluateLowSampleCountPercentile()));
        }

        return request;
    }

}
