/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * GetMetricDataRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetMetricDataRequestMarshaller implements Marshaller<Request<GetMetricDataRequest>, GetMetricDataRequest> {

    public Request<GetMetricDataRequest> marshall(GetMetricDataRequest getMetricDataRequest) {

        if (getMetricDataRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<GetMetricDataRequest> request = new DefaultRequest<GetMetricDataRequest>(getMetricDataRequest, "CloudWatchClient");
        request.addParameter("Action", "GetMetricData");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (getMetricDataRequest.metricDataQueries().isEmpty()
                && !(getMetricDataRequest.metricDataQueries() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("MetricDataQueries", "");
        } else if (!getMetricDataRequest.metricDataQueries().isEmpty()
                && !(getMetricDataRequest.metricDataQueries() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<MetricDataQuery> metricDataQueriesList = getMetricDataRequest.metricDataQueries();
            int metricDataQueriesListIndex = 1;

            for (MetricDataQuery metricDataQueriesListValue : metricDataQueriesList) {

                if (metricDataQueriesListValue.id() != null) {
                    request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".Id",
                            StringConversion.fromString(metricDataQueriesListValue.id()));
                }

                MetricStat metricStat = metricDataQueriesListValue.metricStat();
                if (metricStat != null) {

                    Metric metric = metricStat.metric();
                    if (metric != null) {

                        if (metric.namespace() != null) {
                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex
                                    + ".MetricStat.Metric.Namespace", StringConversion.fromString(metric.namespace()));
                        }

                        if (metric.metricName() != null) {
                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex
                                    + ".MetricStat.Metric.MetricName", StringConversion.fromString(metric.metricName()));
                        }

                        if (metric.dimensions().isEmpty()
                                && !(metric.dimensions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex
                                    + ".MetricStat.Metric.Dimensions", "");
                        } else if (!metric.dimensions().isEmpty()
                                && !(metric.dimensions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                            java.util.List<Dimension> dimensionsList = metric.dimensions();
                            int dimensionsListIndex = 1;

                            for (Dimension dimensionsListValue : dimensionsList) {

                                if (dimensionsListValue.name() != null) {
                                    request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex
                                            + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Name",
                                            StringConversion.fromString(dimensionsListValue.name()));
                                }

                                if (dimensionsListValue.value() != null) {
                                    request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex
                                            + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Value",
                                            StringConversion.fromString(dimensionsListValue.value()));
                                }
                                dimensionsListIndex++;
                            }
                        }
                    }

                    if (metricStat.period() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Period",
                                StringConversion.fromInteger(metricStat.period()));
                    }

                    if (metricStat.stat() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Stat",
                                StringConversion.fromString(metricStat.stat()));
                    }

                    if (metricStat.unitAsString() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Unit",
                                StringConversion.fromString(metricStat.unitAsString()));
                    }
                }

                if (metricDataQueriesListValue.expression() != null) {
                    request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".Expression",
                            StringConversion.fromString(metricDataQueriesListValue.expression()));
                }

                if (metricDataQueriesListValue.label() != null) {
                    request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".Label",
                            StringConversion.fromString(metricDataQueriesListValue.label()));
                }

                if (metricDataQueriesListValue.returnData() != null) {
                    request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".ReturnData",
                            StringConversion.fromBoolean(metricDataQueriesListValue.returnData()));
                }
                metricDataQueriesListIndex++;
            }
        }

        if (getMetricDataRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant(getMetricDataRequest.startTime()));
        }

        if (getMetricDataRequest.endTime() != null) {
            request.addParameter("EndTime", StringConversion.fromInstant(getMetricDataRequest.endTime()));
        }

        if (getMetricDataRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString(getMetricDataRequest.nextToken()));
        }

        if (getMetricDataRequest.scanByAsString() != null) {
            request.addParameter("ScanBy", StringConversion.fromString(getMetricDataRequest.scanByAsString()));
        }

        if (getMetricDataRequest.maxDatapoints() != null) {
            request.addParameter("MaxDatapoints", StringConversion.fromInteger(getMetricDataRequest.maxDatapoints()));
        }

        return request;
    }

}
