/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDashboardsResponse extends CloudWatchResponse implements
        ToCopyableBuilder<ListDashboardsResponse.Builder, ListDashboardsResponse> {
    private final List<DashboardEntry> dashboardEntries;

    private final String nextToken;

    private ListDashboardsResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardEntries = builder.dashboardEntries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of matching dashboards.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of matching dashboards.
     */
    public List<DashboardEntry> dashboardEntries() {
        return dashboardEntries;
    }

    /**
     * <p>
     * The token that marks the start of the next batch of returned results.
     * </p>
     * 
     * @return The token that marks the start of the next batch of returned results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboardEntries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDashboardsResponse)) {
            return false;
        }
        ListDashboardsResponse other = (ListDashboardsResponse) obj;
        return Objects.equals(dashboardEntries(), other.dashboardEntries()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListDashboardsResponse").add("DashboardEntries", dashboardEntries())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardEntries":
            return Optional.ofNullable(clazz.cast(dashboardEntries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchResponse.Builder, CopyableBuilder<Builder, ListDashboardsResponse> {
        /**
         * <p>
         * The list of matching dashboards.
         * </p>
         * 
         * @param dashboardEntries
         *        The list of matching dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardEntries(Collection<DashboardEntry> dashboardEntries);

        /**
         * <p>
         * The list of matching dashboards.
         * </p>
         * 
         * @param dashboardEntries
         *        The list of matching dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardEntries(DashboardEntry... dashboardEntries);

        /**
         * <p>
         * The list of matching dashboards.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DashboardEntry>.Builder} avoiding the need
         * to create one manually via {@link List<DashboardEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DashboardEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #dashboardEntries(List<DashboardEntry>)}.
         * 
         * @param dashboardEntries
         *        a consumer that will call methods on {@link List<DashboardEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboardEntries(List<DashboardEntry>)
         */
        Builder dashboardEntries(Consumer<DashboardEntry.Builder>... dashboardEntries);

        /**
         * <p>
         * The token that marks the start of the next batch of returned results.
         * </p>
         * 
         * @param nextToken
         *        The token that marks the start of the next batch of returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<DashboardEntry> dashboardEntries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDashboardsResponse model) {
            super(model);
            dashboardEntries(model.dashboardEntries);
            nextToken(model.nextToken);
        }

        public final Collection<DashboardEntry.Builder> getDashboardEntries() {
            return dashboardEntries != null ? dashboardEntries.stream().map(DashboardEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dashboardEntries(Collection<DashboardEntry> dashboardEntries) {
            this.dashboardEntries = DashboardEntriesCopier.copy(dashboardEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardEntries(DashboardEntry... dashboardEntries) {
            dashboardEntries(Arrays.asList(dashboardEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardEntries(Consumer<DashboardEntry.Builder>... dashboardEntries) {
            dashboardEntries(Stream.of(dashboardEntries).map(c -> DashboardEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDashboardEntries(Collection<DashboardEntry.BuilderImpl> dashboardEntries) {
            this.dashboardEntries = DashboardEntriesCopier.copyFromBuilder(dashboardEntries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDashboardsResponse build() {
            return new ListDashboardsResponse(this);
        }
    }
}
