/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest;

public class ListDashboardsRequestMarshaller
implements Marshaller<Request<ListDashboardsRequest>, ListDashboardsRequest> {
    public Request<ListDashboardsRequest> marshall(ListDashboardsRequest listDashboardsRequest) {
        if (listDashboardsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)listDashboardsRequest, "CloudWatchClient");
        request.addParameter("Action", "ListDashboards");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listDashboardsRequest.dashboardNamePrefix() != null) {
            request.addParameter("DashboardNamePrefix", StringUtils.fromString((String)listDashboardsRequest.dashboardNamePrefix()));
        }
        if (listDashboardsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listDashboardsRequest.nextToken()));
        }
        return request;
    }
}

