/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;

public class GetMetricStatisticsRequestMarshaller
implements Marshaller<Request<GetMetricStatisticsRequest>, GetMetricStatisticsRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<GetMetricStatisticsRequest> marshall(GetMetricStatisticsRequest getMetricStatisticsRequest) {
        List<String> extendedStatisticsList;
        List<String> statisticsList;
        List<Dimension> dimensionsList;
        if (getMetricStatisticsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getMetricStatisticsRequest, "CloudWatchClient");
        request.addParameter("Action", "GetMetricStatistics");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getMetricStatisticsRequest.namespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)getMetricStatisticsRequest.namespace()));
        }
        if (getMetricStatisticsRequest.metricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString((String)getMetricStatisticsRequest.metricName()));
        }
        if ((dimensionsList = getMetricStatisticsRequest.dimensions()) != null) {
            if (!dimensionsList.isEmpty()) {
                int dimensionsListIndex = 1;
                for (Dimension dimension : dimensionsList) {
                    if (dimension.name() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimension.name()));
                    }
                    if (dimension.value() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimension.value()));
                    }
                    ++dimensionsListIndex;
                }
            } else {
                request.addParameter("Dimensions", "");
            }
        }
        if (getMetricStatisticsRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromInstant((Instant)getMetricStatisticsRequest.startTime()));
        }
        if (getMetricStatisticsRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromInstant((Instant)getMetricStatisticsRequest.endTime()));
        }
        if (getMetricStatisticsRequest.period() != null) {
            request.addParameter("Period", StringUtils.fromInteger((Integer)getMetricStatisticsRequest.period()));
        }
        if ((statisticsList = getMetricStatisticsRequest.statisticsAsStrings()) != null) {
            if (!statisticsList.isEmpty()) {
                int statisticsListIndex = 1;
                for (String statisticsListValue : statisticsList) {
                    if (statisticsListValue != null) {
                        request.addParameter("Statistics.member." + statisticsListIndex, StringUtils.fromString((String)statisticsListValue));
                    }
                    ++statisticsListIndex;
                }
            } else {
                request.addParameter("Statistics", "");
            }
        }
        if ((extendedStatisticsList = getMetricStatisticsRequest.extendedStatistics()) != null) {
            if (!extendedStatisticsList.isEmpty()) {
                boolean bl = true;
                for (String extendedStatisticsListValue : extendedStatisticsList) {
                    void var6_12;
                    if (extendedStatisticsListValue != null) {
                        request.addParameter("ExtendedStatistics.member." + (int)var6_12, StringUtils.fromString((String)extendedStatisticsListValue));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("ExtendedStatistics", "");
            }
        }
        if (getMetricStatisticsRequest.unitAsString() != null) {
            request.addParameter("Unit", StringUtils.fromString((String)getMetricStatisticsRequest.unitAsString()));
        }
        return request;
    }
}

