/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudwatch.model.AlarmNamesCopier;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DisableAlarmActionsRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, DisableAlarmActionsRequest> {
    private final List<String> alarmNames;

    private DisableAlarmActionsRequest(BuilderImpl builder) {
        super(builder);
        this.alarmNames = builder.alarmNames;
    }

    public List<String> alarmNames() {
        return this.alarmNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableAlarmActionsRequest)) {
            return false;
        }
        DisableAlarmActionsRequest other = (DisableAlarmActionsRequest)((Object)obj);
        return Objects.equals(this.alarmNames(), other.alarmNames());
    }

    public String toString() {
        return ToString.builder((String)"DisableAlarmActionsRequest").add("AlarmNames", this.alarmNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmNames": {
                return Optional.of(clazz.cast(this.alarmNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private List<String> alarmNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableAlarmActionsRequest model) {
            super(model);
            this.alarmNames(model.alarmNames);
        }

        public final Collection<String> getAlarmNames() {
            return this.alarmNames;
        }

        @Override
        public final Builder alarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmNames(String ... alarmNames) {
            this.alarmNames(Arrays.asList(alarmNames));
            return this;
        }

        public final void setAlarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DisableAlarmActionsRequest build() {
            return new DisableAlarmActionsRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    CopyableBuilder<Builder, DisableAlarmActionsRequest> {
        public Builder alarmNames(Collection<String> var1);

        public Builder alarmNames(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

