/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * PutDashboardRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutDashboardRequestMarshaller implements Marshaller<Request<PutDashboardRequest>, PutDashboardRequest> {

    public Request<PutDashboardRequest> marshall(PutDashboardRequest putDashboardRequest) {

        if (putDashboardRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutDashboardRequest> request = new DefaultRequest<PutDashboardRequest>(putDashboardRequest, "CloudWatchClient");
        request.addParameter("Action", "PutDashboard");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (putDashboardRequest.dashboardName() != null) {
            request.addParameter("DashboardName", StringUtils.fromString(putDashboardRequest.dashboardName()));
        }

        if (putDashboardRequest.dashboardBody() != null) {
            request.addParameter("DashboardBody", StringUtils.fromString(putDashboardRequest.dashboardBody()));
        }

        return request;
    }

}
