/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudwatch.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeAlarmsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeAlarmsRequestMarshaller implements Marshaller<Request<DescribeAlarmsRequest>, DescribeAlarmsRequest> {

    public Request<DescribeAlarmsRequest> marshall(DescribeAlarmsRequest describeAlarmsRequest) {

        if (describeAlarmsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeAlarmsRequest> request = new DefaultRequest<DescribeAlarmsRequest>(describeAlarmsRequest,
                "CloudWatchClient");
        request.addParameter("Action", "DescribeAlarms");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> alarmNamesList = describeAlarmsRequest.alarmNames();

        if (alarmNamesList != null) {
            if (!alarmNamesList.isEmpty()) {
                int alarmNamesListIndex = 1;

                for (String alarmNamesListValue : alarmNamesList) {
                    if (alarmNamesListValue != null) {
                        request.addParameter("AlarmNames.member." + alarmNamesListIndex,
                                StringUtils.fromString(alarmNamesListValue));
                    }
                    alarmNamesListIndex++;
                }
            } else {
                request.addParameter("AlarmNames", "");
            }
        }

        if (describeAlarmsRequest.alarmNamePrefix() != null) {
            request.addParameter("AlarmNamePrefix", StringUtils.fromString(describeAlarmsRequest.alarmNamePrefix()));
        }

        if (describeAlarmsRequest.stateValueAsString() != null) {
            request.addParameter("StateValue", StringUtils.fromString(describeAlarmsRequest.stateValueAsString()));
        }

        if (describeAlarmsRequest.actionPrefix() != null) {
            request.addParameter("ActionPrefix", StringUtils.fromString(describeAlarmsRequest.actionPrefix()));
        }

        if (describeAlarmsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeAlarmsRequest.maxRecords()));
        }

        if (describeAlarmsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeAlarmsRequest.nextToken()));
        }

        return request;
    }

}
