/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutDashboardResponse extends CloudWatchResponse implements
        ToCopyableBuilder<PutDashboardResponse.Builder, PutDashboardResponse> {
    private final List<DashboardValidationMessage> dashboardValidationMessages;

    private PutDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardValidationMessages = builder.dashboardValidationMessages;
    }

    /**
     * <p>
     * If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or modified,
     * this result is empty.
     * </p>
     * <p>
     * If this result includes only warning messages, then the input was valid enough for the dashboard to be created or
     * modified, but some elements of the dashboard may not render.
     * </p>
     * <p>
     * If this result includes error messages, the input was not valid and the operation failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or
     *         modified, this result is empty.</p>
     *         <p>
     *         If this result includes only warning messages, then the input was valid enough for the dashboard to be
     *         created or modified, but some elements of the dashboard may not render.
     *         </p>
     *         <p>
     *         If this result includes error messages, the input was not valid and the operation failed.
     */
    public List<DashboardValidationMessage> dashboardValidationMessages() {
        return dashboardValidationMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboardValidationMessages());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDashboardResponse)) {
            return false;
        }
        PutDashboardResponse other = (PutDashboardResponse) obj;
        return Objects.equals(dashboardValidationMessages(), other.dashboardValidationMessages());
    }

    @Override
    public String toString() {
        return ToString.builder("PutDashboardResponse").add("DashboardValidationMessages", dashboardValidationMessages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardValidationMessages":
            return Optional.of(clazz.cast(dashboardValidationMessages()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchResponse.Builder, CopyableBuilder<Builder, PutDashboardResponse> {
        /**
         * <p>
         * If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or
         * modified, this result is empty.
         * </p>
         * <p>
         * If this result includes only warning messages, then the input was valid enough for the dashboard to be
         * created or modified, but some elements of the dashboard may not render.
         * </p>
         * <p>
         * If this result includes error messages, the input was not valid and the operation failed.
         * </p>
         * 
         * @param dashboardValidationMessages
         *        If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or
         *        modified, this result is empty.</p>
         *        <p>
         *        If this result includes only warning messages, then the input was valid enough for the dashboard to be
         *        created or modified, but some elements of the dashboard may not render.
         *        </p>
         *        <p>
         *        If this result includes error messages, the input was not valid and the operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardValidationMessages(Collection<DashboardValidationMessage> dashboardValidationMessages);

        /**
         * <p>
         * If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or
         * modified, this result is empty.
         * </p>
         * <p>
         * If this result includes only warning messages, then the input was valid enough for the dashboard to be
         * created or modified, but some elements of the dashboard may not render.
         * </p>
         * <p>
         * If this result includes error messages, the input was not valid and the operation failed.
         * </p>
         * 
         * @param dashboardValidationMessages
         *        If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or
         *        modified, this result is empty.</p>
         *        <p>
         *        If this result includes only warning messages, then the input was valid enough for the dashboard to be
         *        created or modified, but some elements of the dashboard may not render.
         *        </p>
         *        <p>
         *        If this result includes error messages, the input was not valid and the operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardValidationMessages(DashboardValidationMessage... dashboardValidationMessages);

        /**
         * <p>
         * If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or
         * modified, this result is empty.
         * </p>
         * <p>
         * If this result includes only warning messages, then the input was valid enough for the dashboard to be
         * created or modified, but some elements of the dashboard may not render.
         * </p>
         * <p>
         * If this result includes error messages, the input was not valid and the operation failed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DashboardValidationMessage>.Builder}
         * avoiding the need to create one manually via {@link List<DashboardValidationMessage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DashboardValidationMessage>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #dashboardValidationMessages(List<DashboardValidationMessage>)}.
         * 
         * @param dashboardValidationMessages
         *        a consumer that will call methods on {@link List<DashboardValidationMessage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboardValidationMessages(List<DashboardValidationMessage>)
         */
        Builder dashboardValidationMessages(Consumer<DashboardValidationMessage.Builder>... dashboardValidationMessages);
    }

    static final class BuilderImpl extends CloudWatchResponse.BuilderImpl implements Builder {
        private List<DashboardValidationMessage> dashboardValidationMessages;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDashboardResponse model) {
            super(model);
            dashboardValidationMessages(model.dashboardValidationMessages);
        }

        public final Collection<DashboardValidationMessage.Builder> getDashboardValidationMessages() {
            return dashboardValidationMessages != null ? dashboardValidationMessages.stream()
                    .map(DashboardValidationMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dashboardValidationMessages(Collection<DashboardValidationMessage> dashboardValidationMessages) {
            this.dashboardValidationMessages = DashboardValidationMessagesCopier.copy(dashboardValidationMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardValidationMessages(DashboardValidationMessage... dashboardValidationMessages) {
            dashboardValidationMessages(Arrays.asList(dashboardValidationMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardValidationMessages(
                Consumer<DashboardValidationMessage.Builder>... dashboardValidationMessages) {
            dashboardValidationMessages(Stream.of(dashboardValidationMessages)
                    .map(c -> DashboardValidationMessage.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDashboardValidationMessages(
                Collection<DashboardValidationMessage.BuilderImpl> dashboardValidationMessages) {
            this.dashboardValidationMessages = DashboardValidationMessagesCopier.copyFromBuilder(dashboardValidationMessages);
        }

        @Override
        public PutDashboardResponse build() {
            return new PutDashboardResponse(this);
        }
    }
}
