/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtraildata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAuditEventsResponse extends CloudTrailDataResponse implements
        ToCopyableBuilder<PutAuditEventsResponse.Builder, PutAuditEventsResponse> {
    private static final SdkField<List<ResultErrorEntry>> FAILED_FIELD = SdkField
            .<List<ResultErrorEntry>> builder(MarshallingType.LIST)
            .memberName("failed")
            .getter(getter(PutAuditEventsResponse::failed))
            .setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResultErrorEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResultErrorEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AuditEventResultEntry>> SUCCESSFUL_FIELD = SdkField
            .<List<AuditEventResultEntry>> builder(MarshallingType.LIST)
            .memberName("successful")
            .getter(getter(PutAuditEventsResponse::successful))
            .setter(setter(Builder::successful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuditEventResultEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditEventResultEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FAILED_FIELD, SUCCESSFUL_FIELD));

    private final List<ResultErrorEntry> failed;

    private final List<AuditEventResultEntry> successful;

    private PutAuditEventsResponse(BuilderImpl builder) {
        super(builder);
        this.failed = builder.failed;
        this.successful = builder.successful;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failed property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailed() {
        return failed != null && !(failed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists events in the provided event payload that could not be ingested into CloudTrail, and includes the error
     * code and error message returned for events that could not be ingested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailed} method.
     * </p>
     * 
     * @return Lists events in the provided event payload that could not be ingested into CloudTrail, and includes the
     *         error code and error message returned for events that could not be ingested.
     */
    public final List<ResultErrorEntry> failed() {
        return failed;
    }

    /**
     * For responses, this returns true if the service returned a value for the Successful property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSuccessful() {
        return successful != null && !(successful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists events in the provided event payload that were successfully ingested into CloudTrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessful} method.
     * </p>
     * 
     * @return Lists events in the provided event payload that were successfully ingested into CloudTrail.
     */
    public final List<AuditEventResultEntry> successful() {
        return successful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailed() ? failed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessful() ? successful() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAuditEventsResponse)) {
            return false;
        }
        PutAuditEventsResponse other = (PutAuditEventsResponse) obj;
        return hasFailed() == other.hasFailed() && Objects.equals(failed(), other.failed())
                && hasSuccessful() == other.hasSuccessful() && Objects.equals(successful(), other.successful());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAuditEventsResponse").add("Failed", hasFailed() ? failed() : null)
                .add("Successful", hasSuccessful() ? successful() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "successful":
            return Optional.ofNullable(clazz.cast(successful()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAuditEventsResponse, T> g) {
        return obj -> g.apply((PutAuditEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutAuditEventsResponse> {
        /**
         * <p>
         * Lists events in the provided event payload that could not be ingested into CloudTrail, and includes the error
         * code and error message returned for events that could not be ingested.
         * </p>
         * 
         * @param failed
         *        Lists events in the provided event payload that could not be ingested into CloudTrail, and includes
         *        the error code and error message returned for events that could not be ingested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Collection<ResultErrorEntry> failed);

        /**
         * <p>
         * Lists events in the provided event payload that could not be ingested into CloudTrail, and includes the error
         * code and error message returned for events that could not be ingested.
         * </p>
         * 
         * @param failed
         *        Lists events in the provided event payload that could not be ingested into CloudTrail, and includes
         *        the error code and error message returned for events that could not be ingested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(ResultErrorEntry... failed);

        /**
         * <p>
         * Lists events in the provided event payload that could not be ingested into CloudTrail, and includes the error
         * code and error message returned for events that could not be ingested.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtraildata.model.ResultErrorEntry.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudtraildata.model.ResultErrorEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtraildata.model.ResultErrorEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #failed(List<ResultErrorEntry>)}.
         * 
         * @param failed
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtraildata.model.ResultErrorEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failed(java.util.Collection<ResultErrorEntry>)
         */
        Builder failed(Consumer<ResultErrorEntry.Builder>... failed);

        /**
         * <p>
         * Lists events in the provided event payload that were successfully ingested into CloudTrail.
         * </p>
         * 
         * @param successful
         *        Lists events in the provided event payload that were successfully ingested into CloudTrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<AuditEventResultEntry> successful);

        /**
         * <p>
         * Lists events in the provided event payload that were successfully ingested into CloudTrail.
         * </p>
         * 
         * @param successful
         *        Lists events in the provided event payload that were successfully ingested into CloudTrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(AuditEventResultEntry... successful);

        /**
         * <p>
         * Lists events in the provided event payload that were successfully ingested into CloudTrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtraildata.model.AuditEventResultEntry.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cloudtraildata.model.AuditEventResultEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtraildata.model.AuditEventResultEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #successful(List<AuditEventResultEntry>)}.
         * 
         * @param successful
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtraildata.model.AuditEventResultEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successful(java.util.Collection<AuditEventResultEntry>)
         */
        Builder successful(Consumer<AuditEventResultEntry.Builder>... successful);
    }

    static final class BuilderImpl extends CloudTrailDataResponse.BuilderImpl implements Builder {
        private List<ResultErrorEntry> failed = DefaultSdkAutoConstructList.getInstance();

        private List<AuditEventResultEntry> successful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutAuditEventsResponse model) {
            super(model);
            failed(model.failed);
            successful(model.successful);
        }

        public final List<ResultErrorEntry.Builder> getFailed() {
            List<ResultErrorEntry.Builder> result = ResultErrorEntriesCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<ResultErrorEntry.BuilderImpl> failed) {
            this.failed = ResultErrorEntriesCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<ResultErrorEntry> failed) {
            this.failed = ResultErrorEntriesCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(ResultErrorEntry... failed) {
            failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<ResultErrorEntry.Builder>... failed) {
            failed(Stream.of(failed).map(c -> ResultErrorEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AuditEventResultEntry.Builder> getSuccessful() {
            List<AuditEventResultEntry.Builder> result = AuditEventResultEntriesCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<AuditEventResultEntry.BuilderImpl> successful) {
            this.successful = AuditEventResultEntriesCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<AuditEventResultEntry> successful) {
            this.successful = AuditEventResultEntriesCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(AuditEventResultEntry... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<AuditEventResultEntry.Builder>... successful) {
            successful(Stream.of(successful).map(c -> AuditEventResultEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutAuditEventsResponse build() {
            return new PutAuditEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
