/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeliveryStatus;
import software.amazon.awssdk.services.cloudtrail.model.QueryStatisticsForDescribeQuery;
import software.amazon.awssdk.services.cloudtrail.model.QueryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeQueryResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, DescribeQueryResponse> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(DescribeQueryResponse.getter(DescribeQueryResponse::queryId)).setter(DescribeQueryResponse.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(DescribeQueryResponse.getter(DescribeQueryResponse::queryString)).setter(DescribeQueryResponse.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<String> QUERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryStatus").getter(DescribeQueryResponse.getter(DescribeQueryResponse::queryStatusAsString)).setter(DescribeQueryResponse.setter(Builder::queryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatus").build()}).build();
    private static final SdkField<QueryStatisticsForDescribeQuery> QUERY_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryStatistics").getter(DescribeQueryResponse.getter(DescribeQueryResponse::queryStatistics)).setter(DescribeQueryResponse.setter(Builder::queryStatistics)).constructor(QueryStatisticsForDescribeQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatistics").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(DescribeQueryResponse.getter(DescribeQueryResponse::errorMessage)).setter(DescribeQueryResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> DELIVERY_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryS3Uri").getter(DescribeQueryResponse.getter(DescribeQueryResponse::deliveryS3Uri)).setter(DescribeQueryResponse.setter(Builder::deliveryS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3Uri").build()}).build();
    private static final SdkField<String> DELIVERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryStatus").getter(DescribeQueryResponse.getter(DescribeQueryResponse::deliveryStatusAsString)).setter(DescribeQueryResponse.setter(Builder::deliveryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStatus").build()}).build();
    private static final SdkField<String> PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prompt").getter(DescribeQueryResponse.getter(DescribeQueryResponse::prompt)).setter(DescribeQueryResponse.setter(Builder::prompt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prompt").build()}).build();
    private static final SdkField<String> EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStoreOwnerAccountId").getter(DescribeQueryResponse.getter(DescribeQueryResponse::eventDataStoreOwnerAccountId)).setter(DescribeQueryResponse.setter(Builder::eventDataStoreOwnerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreOwnerAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, QUERY_STRING_FIELD, QUERY_STATUS_FIELD, QUERY_STATISTICS_FIELD, ERROR_MESSAGE_FIELD, DELIVERY_S3_URI_FIELD, DELIVERY_STATUS_FIELD, PROMPT_FIELD, EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeQueryResponse.memberNameToFieldInitializer();
    private final String queryId;
    private final String queryString;
    private final String queryStatus;
    private final QueryStatisticsForDescribeQuery queryStatistics;
    private final String errorMessage;
    private final String deliveryS3Uri;
    private final String deliveryStatus;
    private final String prompt;
    private final String eventDataStoreOwnerAccountId;

    private DescribeQueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.queryString = builder.queryString;
        this.queryStatus = builder.queryStatus;
        this.queryStatistics = builder.queryStatistics;
        this.errorMessage = builder.errorMessage;
        this.deliveryS3Uri = builder.deliveryS3Uri;
        this.deliveryStatus = builder.deliveryStatus;
        this.prompt = builder.prompt;
        this.eventDataStoreOwnerAccountId = builder.eventDataStoreOwnerAccountId;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final QueryStatus queryStatus() {
        return QueryStatus.fromValue(this.queryStatus);
    }

    public final String queryStatusAsString() {
        return this.queryStatus;
    }

    public final QueryStatisticsForDescribeQuery queryStatistics() {
        return this.queryStatistics;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String deliveryS3Uri() {
        return this.deliveryS3Uri;
    }

    public final DeliveryStatus deliveryStatus() {
        return DeliveryStatus.fromValue(this.deliveryStatus);
    }

    public final String deliveryStatusAsString() {
        return this.deliveryStatus;
    }

    public final String prompt() {
        return this.prompt;
    }

    public final String eventDataStoreOwnerAccountId() {
        return this.eventDataStoreOwnerAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.prompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStoreOwnerAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeQueryResponse)) {
            return false;
        }
        DescribeQueryResponse other = (DescribeQueryResponse)((Object)obj);
        return Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.queryStatusAsString(), other.queryStatusAsString()) && Objects.equals(this.queryStatistics(), other.queryStatistics()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.deliveryS3Uri(), other.deliveryS3Uri()) && Objects.equals(this.deliveryStatusAsString(), other.deliveryStatusAsString()) && Objects.equals(this.prompt(), other.prompt()) && Objects.equals(this.eventDataStoreOwnerAccountId(), other.eventDataStoreOwnerAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeQueryResponse").add("QueryId", (Object)this.queryId()).add("QueryString", (Object)this.queryString()).add("QueryStatus", (Object)this.queryStatusAsString()).add("QueryStatistics", (Object)this.queryStatistics()).add("ErrorMessage", (Object)this.errorMessage()).add("DeliveryS3Uri", (Object)this.deliveryS3Uri()).add("DeliveryStatus", (Object)this.deliveryStatusAsString()).add("Prompt", (Object)this.prompt()).add("EventDataStoreOwnerAccountId", (Object)this.eventDataStoreOwnerAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "QueryStatus": {
                return Optional.ofNullable(clazz.cast(this.queryStatusAsString()));
            }
            case "QueryStatistics": {
                return Optional.ofNullable(clazz.cast(this.queryStatistics()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "DeliveryS3Uri": {
                return Optional.ofNullable(clazz.cast(this.deliveryS3Uri()));
            }
            case "DeliveryStatus": {
                return Optional.ofNullable(clazz.cast(this.deliveryStatusAsString()));
            }
            case "Prompt": {
                return Optional.ofNullable(clazz.cast(this.prompt()));
            }
            case "EventDataStoreOwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.eventDataStoreOwnerAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("QueryString", QUERY_STRING_FIELD);
        map.put("QueryStatus", QUERY_STATUS_FIELD);
        map.put("QueryStatistics", QUERY_STATISTICS_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("DeliveryS3Uri", DELIVERY_S3_URI_FIELD);
        map.put("DeliveryStatus", DELIVERY_STATUS_FIELD);
        map.put("Prompt", PROMPT_FIELD);
        map.put("EventDataStoreOwnerAccountId", EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeQueryResponse, T> g) {
        return obj -> g.apply((DescribeQueryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String queryId;
        private String queryString;
        private String queryStatus;
        private QueryStatisticsForDescribeQuery queryStatistics;
        private String errorMessage;
        private String deliveryS3Uri;
        private String deliveryStatus;
        private String prompt;
        private String eventDataStoreOwnerAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeQueryResponse model) {
            super(model);
            this.queryId(model.queryId);
            this.queryString(model.queryString);
            this.queryStatus(model.queryStatus);
            this.queryStatistics(model.queryStatistics);
            this.errorMessage(model.errorMessage);
            this.deliveryS3Uri(model.deliveryS3Uri);
            this.deliveryStatus(model.deliveryStatus);
            this.prompt(model.prompt);
            this.eventDataStoreOwnerAccountId(model.eventDataStoreOwnerAccountId);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getQueryStatus() {
            return this.queryStatus;
        }

        public final void setQueryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
        }

        @Override
        public final Builder queryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
            return this;
        }

        @Override
        public final Builder queryStatus(QueryStatus queryStatus) {
            this.queryStatus(queryStatus == null ? null : queryStatus.toString());
            return this;
        }

        public final QueryStatisticsForDescribeQuery.Builder getQueryStatistics() {
            return this.queryStatistics != null ? this.queryStatistics.toBuilder() : null;
        }

        public final void setQueryStatistics(QueryStatisticsForDescribeQuery.BuilderImpl queryStatistics) {
            this.queryStatistics = queryStatistics != null ? queryStatistics.build() : null;
        }

        @Override
        public final Builder queryStatistics(QueryStatisticsForDescribeQuery queryStatistics) {
            this.queryStatistics = queryStatistics;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getDeliveryS3Uri() {
            return this.deliveryS3Uri;
        }

        public final void setDeliveryS3Uri(String deliveryS3Uri) {
            this.deliveryS3Uri = deliveryS3Uri;
        }

        @Override
        public final Builder deliveryS3Uri(String deliveryS3Uri) {
            this.deliveryS3Uri = deliveryS3Uri;
            return this;
        }

        public final String getDeliveryStatus() {
            return this.deliveryStatus;
        }

        public final void setDeliveryStatus(String deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
        }

        @Override
        public final Builder deliveryStatus(String deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
            return this;
        }

        @Override
        public final Builder deliveryStatus(DeliveryStatus deliveryStatus) {
            this.deliveryStatus(deliveryStatus == null ? null : deliveryStatus.toString());
            return this;
        }

        public final String getPrompt() {
            return this.prompt;
        }

        public final void setPrompt(String prompt) {
            this.prompt = prompt;
        }

        @Override
        public final Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public final String getEventDataStoreOwnerAccountId() {
            return this.eventDataStoreOwnerAccountId;
        }

        public final void setEventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId) {
            this.eventDataStoreOwnerAccountId = eventDataStoreOwnerAccountId;
        }

        @Override
        public final Builder eventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId) {
            this.eventDataStoreOwnerAccountId = eventDataStoreOwnerAccountId;
            return this;
        }

        @Override
        public DescribeQueryResponse build() {
            return new DescribeQueryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeQueryResponse> {
        public Builder queryId(String var1);

        public Builder queryString(String var1);

        public Builder queryStatus(String var1);

        public Builder queryStatus(QueryStatus var1);

        public Builder queryStatistics(QueryStatisticsForDescribeQuery var1);

        default public Builder queryStatistics(Consumer<QueryStatisticsForDescribeQuery.Builder> queryStatistics) {
            return this.queryStatistics((QueryStatisticsForDescribeQuery)((QueryStatisticsForDescribeQuery.Builder)QueryStatisticsForDescribeQuery.builder().applyMutation(queryStatistics)).build());
        }

        public Builder errorMessage(String var1);

        public Builder deliveryS3Uri(String var1);

        public Builder deliveryStatus(String var1);

        public Builder deliveryStatus(DeliveryStatus var1);

        public Builder prompt(String var1);

        public Builder eventDataStoreOwnerAccountId(String var1);
    }
}

