/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventDataStoreStatus {
    CREATED("CREATED"),
    ENABLED("ENABLED"),
    PENDING_DELETION("PENDING_DELETION"),
    STARTING_INGESTION("STARTING_INGESTION"),
    STOPPING_INGESTION("STOPPING_INGESTION"),
    STOPPED_INGESTION("STOPPED_INGESTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventDataStoreStatus> VALUE_MAP;
    private final String value;

    private EventDataStoreStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventDataStoreStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventDataStoreStatus> knownValues() {
        EnumSet<EventDataStoreStatus> knownValues = EnumSet.allOf(EventDataStoreStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventDataStoreStatus.class, EventDataStoreStatus::toString);
    }
}

