/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailAsyncClient;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse;

public class ListEventDataStoresPublisher
implements SdkPublisher<ListEventDataStoresResponse> {
    private final CloudTrailAsyncClient client;
    private final ListEventDataStoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventDataStoresPublisher(CloudTrailAsyncClient client, ListEventDataStoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventDataStoresPublisher(CloudTrailAsyncClient client, ListEventDataStoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventDataStoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventDataStoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListEventDataStoresResponseFetcher
    implements AsyncPageFetcher<ListEventDataStoresResponse> {
        private ListEventDataStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListEventDataStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventDataStoresResponse> nextPage(ListEventDataStoresResponse previousPage) {
            if (previousPage == null) {
                return ListEventDataStoresPublisher.this.client.listEventDataStores(ListEventDataStoresPublisher.this.firstRequest);
            }
            return ListEventDataStoresPublisher.this.client.listEventDataStores((ListEventDataStoresRequest)((Object)ListEventDataStoresPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

