/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEventDataStoreResponse extends CloudTrailResponse implements
        ToCopyableBuilder<UpdateEventDataStoreResponse.Builder, UpdateEventDataStoreResponse> {
    private static final SdkField<String> EVENT_DATA_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventDataStoreArn").getter(getter(UpdateEventDataStoreResponse::eventDataStoreArn))
            .setter(setter(Builder::eventDataStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateEventDataStoreResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateEventDataStoreResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<AdvancedEventSelector>> ADVANCED_EVENT_SELECTORS_FIELD = SdkField
            .<List<AdvancedEventSelector>> builder(MarshallingType.LIST)
            .memberName("AdvancedEventSelectors")
            .getter(getter(UpdateEventDataStoreResponse::advancedEventSelectors))
            .setter(setter(Builder::advancedEventSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedEventSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdvancedEventSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdvancedEventSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> MULTI_REGION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiRegionEnabled").getter(getter(UpdateEventDataStoreResponse::multiRegionEnabled))
            .setter(setter(Builder::multiRegionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionEnabled").build())
            .build();

    private static final SdkField<Boolean> ORGANIZATION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OrganizationEnabled").getter(getter(UpdateEventDataStoreResponse::organizationEnabled))
            .setter(setter(Builder::organizationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationEnabled").build())
            .build();

    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetentionPeriod").getter(getter(UpdateEventDataStoreResponse::retentionPeriod))
            .setter(setter(Builder::retentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()).build();

    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminationProtectionEnabled")
            .getter(getter(UpdateEventDataStoreResponse::terminationProtectionEnabled))
            .setter(setter(Builder::terminationProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled")
                    .build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(UpdateEventDataStoreResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp").getter(getter(UpdateEventDataStoreResponse::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(UpdateEventDataStoreResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_ARN_FIELD,
            NAME_FIELD, STATUS_FIELD, ADVANCED_EVENT_SELECTORS_FIELD, MULTI_REGION_ENABLED_FIELD, ORGANIZATION_ENABLED_FIELD,
            RETENTION_PERIOD_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD,
            KMS_KEY_ID_FIELD));

    private final String eventDataStoreArn;

    private final String name;

    private final String status;

    private final List<AdvancedEventSelector> advancedEventSelectors;

    private final Boolean multiRegionEnabled;

    private final Boolean organizationEnabled;

    private final Integer retentionPeriod;

    private final Boolean terminationProtectionEnabled;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private final String kmsKeyId;

    private UpdateEventDataStoreResponse(BuilderImpl builder) {
        super(builder);
        this.eventDataStoreArn = builder.eventDataStoreArn;
        this.name = builder.name;
        this.status = builder.status;
        this.advancedEventSelectors = builder.advancedEventSelectors;
        this.multiRegionEnabled = builder.multiRegionEnabled;
        this.organizationEnabled = builder.organizationEnabled;
        this.retentionPeriod = builder.retentionPeriod;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The ARN of the event data store.
     * </p>
     * 
     * @return The ARN of the event data store.
     */
    public final String eventDataStoreArn() {
        return eventDataStoreArn;
    }

    /**
     * <p>
     * The name of the event data store.
     * </p>
     * 
     * @return The name of the event data store.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of an event data store. Values can be <code>ENABLED</code> and <code>PENDING_DELETION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EventDataStoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of an event data store. Values can be <code>ENABLED</code> and <code>PENDING_DELETION</code>.
     * @see EventDataStoreStatus
     */
    public final EventDataStoreStatus status() {
        return EventDataStoreStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of an event data store. Values can be <code>ENABLED</code> and <code>PENDING_DELETION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EventDataStoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of an event data store. Values can be <code>ENABLED</code> and <code>PENDING_DELETION</code>.
     * @see EventDataStoreStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdvancedEventSelectors property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdvancedEventSelectors() {
        return advancedEventSelectors != null && !(advancedEventSelectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The advanced event selectors that are applied to the event data store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdvancedEventSelectors} method.
     * </p>
     * 
     * @return The advanced event selectors that are applied to the event data store.
     */
    public final List<AdvancedEventSelector> advancedEventSelectors() {
        return advancedEventSelectors;
    }

    /**
     * <p>
     * Indicates whether the event data store includes events from all regions, or only from the region in which it was
     * created.
     * </p>
     * 
     * @return Indicates whether the event data store includes events from all regions, or only from the region in which
     *         it was created.
     */
    public final Boolean multiRegionEnabled() {
        return multiRegionEnabled;
    }

    /**
     * <p>
     * Indicates whether an event data store is collecting logged events for an organization in Organizations.
     * </p>
     * 
     * @return Indicates whether an event data store is collecting logged events for an organization in Organizations.
     */
    public final Boolean organizationEnabled() {
        return organizationEnabled;
    }

    /**
     * <p>
     * The retention period, in days.
     * </p>
     * 
     * @return The retention period, in days.
     */
    public final Integer retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * Indicates whether termination protection is enabled for the event data store.
     * </p>
     * 
     * @return Indicates whether termination protection is enabled for the event data store.
     */
    public final Boolean terminationProtectionEnabled() {
        return terminationProtectionEnabled;
    }

    /**
     * <p>
     * The timestamp that shows when an event data store was first created.
     * </p>
     * 
     * @return The timestamp that shows when an event data store was first created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The timestamp that shows when the event data store was last updated. <code>UpdatedTimestamp</code> is always
     * either the same or newer than the time shown in <code>CreatedTimestamp</code>.
     * </p>
     * 
     * @return The timestamp that shows when the event data store was last updated. <code>UpdatedTimestamp</code> is
     *         always either the same or newer than the time shown in <code>CreatedTimestamp</code>.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    /**
     * <p>
     * Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The value is a fully specified ARN to
     * a KMS key in the following format.
     * </p>
     * <p>
     * <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
     * </p>
     * 
     * @return Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The value is a fully specified
     *         ARN to a KMS key in the following format.</p>
     *         <p>
     *         <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventDataStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdvancedEventSelectors() ? advancedEventSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(organizationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(terminationProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventDataStoreResponse)) {
            return false;
        }
        UpdateEventDataStoreResponse other = (UpdateEventDataStoreResponse) obj;
        return Objects.equals(eventDataStoreArn(), other.eventDataStoreArn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && hasAdvancedEventSelectors() == other.hasAdvancedEventSelectors()
                && Objects.equals(advancedEventSelectors(), other.advancedEventSelectors())
                && Objects.equals(multiRegionEnabled(), other.multiRegionEnabled())
                && Objects.equals(organizationEnabled(), other.organizationEnabled())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(terminationProtectionEnabled(), other.terminationProtectionEnabled())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEventDataStoreResponse").add("EventDataStoreArn", eventDataStoreArn()).add("Name", name())
                .add("Status", statusAsString())
                .add("AdvancedEventSelectors", hasAdvancedEventSelectors() ? advancedEventSelectors() : null)
                .add("MultiRegionEnabled", multiRegionEnabled()).add("OrganizationEnabled", organizationEnabled())
                .add("RetentionPeriod", retentionPeriod()).add("TerminationProtectionEnabled", terminationProtectionEnabled())
                .add("CreatedTimestamp", createdTimestamp()).add("UpdatedTimestamp", updatedTimestamp())
                .add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventDataStoreArn":
            return Optional.ofNullable(clazz.cast(eventDataStoreArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AdvancedEventSelectors":
            return Optional.ofNullable(clazz.cast(advancedEventSelectors()));
        case "MultiRegionEnabled":
            return Optional.ofNullable(clazz.cast(multiRegionEnabled()));
        case "OrganizationEnabled":
            return Optional.ofNullable(clazz.cast(organizationEnabled()));
        case "RetentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "TerminationProtectionEnabled":
            return Optional.ofNullable(clazz.cast(terminationProtectionEnabled()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventDataStoreResponse, T> g) {
        return obj -> g.apply((UpdateEventDataStoreResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEventDataStoreResponse> {
        /**
         * <p>
         * The ARN of the event data store.
         * </p>
         * 
         * @param eventDataStoreArn
         *        The ARN of the event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStoreArn(String eventDataStoreArn);

        /**
         * <p>
         * The name of the event data store.
         * </p>
         * 
         * @param name
         *        The name of the event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of an event data store. Values can be <code>ENABLED</code> and <code>PENDING_DELETION</code>.
         * </p>
         * 
         * @param status
         *        The status of an event data store. Values can be <code>ENABLED</code> and
         *        <code>PENDING_DELETION</code>.
         * @see EventDataStoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventDataStoreStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of an event data store. Values can be <code>ENABLED</code> and <code>PENDING_DELETION</code>.
         * </p>
         * 
         * @param status
         *        The status of an event data store. Values can be <code>ENABLED</code> and
         *        <code>PENDING_DELETION</code>.
         * @see EventDataStoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventDataStoreStatus
         */
        Builder status(EventDataStoreStatus status);

        /**
         * <p>
         * The advanced event selectors that are applied to the event data store.
         * </p>
         * 
         * @param advancedEventSelectors
         *        The advanced event selectors that are applied to the event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors);

        /**
         * <p>
         * The advanced event selectors that are applied to the event data store.
         * </p>
         * 
         * @param advancedEventSelectors
         *        The advanced event selectors that are applied to the event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedEventSelectors(AdvancedEventSelector... advancedEventSelectors);

        /**
         * <p>
         * The advanced event selectors that are applied to the event data store.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedEventSelectors(List<AdvancedEventSelector>)}.
         * 
         * @param advancedEventSelectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedEventSelectors(java.util.Collection<AdvancedEventSelector>)
         */
        Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder>... advancedEventSelectors);

        /**
         * <p>
         * Indicates whether the event data store includes events from all regions, or only from the region in which it
         * was created.
         * </p>
         * 
         * @param multiRegionEnabled
         *        Indicates whether the event data store includes events from all regions, or only from the region in
         *        which it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionEnabled(Boolean multiRegionEnabled);

        /**
         * <p>
         * Indicates whether an event data store is collecting logged events for an organization in Organizations.
         * </p>
         * 
         * @param organizationEnabled
         *        Indicates whether an event data store is collecting logged events for an organization in
         *        Organizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationEnabled(Boolean organizationEnabled);

        /**
         * <p>
         * The retention period, in days.
         * </p>
         * 
         * @param retentionPeriod
         *        The retention period, in days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(Integer retentionPeriod);

        /**
         * <p>
         * Indicates whether termination protection is enabled for the event data store.
         * </p>
         * 
         * @param terminationProtectionEnabled
         *        Indicates whether termination protection is enabled for the event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled);

        /**
         * <p>
         * The timestamp that shows when an event data store was first created.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp that shows when an event data store was first created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The timestamp that shows when the event data store was last updated. <code>UpdatedTimestamp</code> is always
         * either the same or newer than the time shown in <code>CreatedTimestamp</code>.
         * </p>
         * 
         * @param updatedTimestamp
         *        The timestamp that shows when the event data store was last updated. <code>UpdatedTimestamp</code> is
         *        always either the same or newer than the time shown in <code>CreatedTimestamp</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);

        /**
         * <p>
         * Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The value is a fully specified ARN
         * to a KMS key in the following format.
         * </p>
         * <p>
         * <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
         * </p>
         * 
         * @param kmsKeyId
         *        Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The value is a fully
         *        specified ARN to a KMS key in the following format.</p>
         *        <p>
         *        <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String eventDataStoreArn;

        private String name;

        private String status;

        private List<AdvancedEventSelector> advancedEventSelectors = DefaultSdkAutoConstructList.getInstance();

        private Boolean multiRegionEnabled;

        private Boolean organizationEnabled;

        private Integer retentionPeriod;

        private Boolean terminationProtectionEnabled;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventDataStoreResponse model) {
            super(model);
            eventDataStoreArn(model.eventDataStoreArn);
            name(model.name);
            status(model.status);
            advancedEventSelectors(model.advancedEventSelectors);
            multiRegionEnabled(model.multiRegionEnabled);
            organizationEnabled(model.organizationEnabled);
            retentionPeriod(model.retentionPeriod);
            terminationProtectionEnabled(model.terminationProtectionEnabled);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getEventDataStoreArn() {
            return eventDataStoreArn;
        }

        public final void setEventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
        }

        @Override
        public final Builder eventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EventDataStoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<AdvancedEventSelector.Builder> getAdvancedEventSelectors() {
            List<AdvancedEventSelector.Builder> result = AdvancedEventSelectorsCopier.copyToBuilder(this.advancedEventSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedEventSelectors(Collection<AdvancedEventSelector.BuilderImpl> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copyFromBuilder(advancedEventSelectors);
        }

        @Override
        public final Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copy(advancedEventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(AdvancedEventSelector... advancedEventSelectors) {
            advancedEventSelectors(Arrays.asList(advancedEventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder>... advancedEventSelectors) {
            advancedEventSelectors(Stream.of(advancedEventSelectors)
                    .map(c -> AdvancedEventSelector.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMultiRegionEnabled() {
            return multiRegionEnabled;
        }

        public final void setMultiRegionEnabled(Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
        }

        @Override
        public final Builder multiRegionEnabled(Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
            return this;
        }

        public final Boolean getOrganizationEnabled() {
            return organizationEnabled;
        }

        public final void setOrganizationEnabled(Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
        }

        @Override
        public final Builder organizationEnabled(Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
            return this;
        }

        public final Integer getRetentionPeriod() {
            return retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public UpdateEventDataStoreResponse build() {
            return new UpdateEventDataStoreResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
