/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEventSelectorsRequest extends CloudTrailRequest implements
        ToCopyableBuilder<PutEventSelectorsRequest.Builder, PutEventSelectorsRequest> {
    private static final SdkField<String> TRAIL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrailName").getter(getter(PutEventSelectorsRequest::trailName)).setter(setter(Builder::trailName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailName").build()).build();

    private static final SdkField<List<EventSelector>> EVENT_SELECTORS_FIELD = SdkField
            .<List<EventSelector>> builder(MarshallingType.LIST)
            .memberName("EventSelectors")
            .getter(getter(PutEventSelectorsRequest::eventSelectors))
            .setter(setter(Builder::eventSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AdvancedEventSelector>> ADVANCED_EVENT_SELECTORS_FIELD = SdkField
            .<List<AdvancedEventSelector>> builder(MarshallingType.LIST)
            .memberName("AdvancedEventSelectors")
            .getter(getter(PutEventSelectorsRequest::advancedEventSelectors))
            .setter(setter(Builder::advancedEventSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedEventSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdvancedEventSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdvancedEventSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_NAME_FIELD,
            EVENT_SELECTORS_FIELD, ADVANCED_EVENT_SELECTORS_FIELD));

    private final String trailName;

    private final List<EventSelector> eventSelectors;

    private final List<AdvancedEventSelector> advancedEventSelectors;

    private PutEventSelectorsRequest(BuilderImpl builder) {
        super(builder);
        this.trailName = builder.trailName;
        this.eventSelectors = builder.eventSelectors;
        this.advancedEventSelectors = builder.advancedEventSelectors;
    }

    /**
     * <p>
     * Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following
     * requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     * </p>
     * </li>
     * <li>
     * <p>
     * Start with a letter or number, and end with a letter or number
     * </p>
     * </li>
     * <li>
     * <p>
     * Be between 3 and 128 characters
     * </p>
     * </li>
     * <li>
     * <p>
     * Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     * <code>my--namespace</code> are not valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * Not be in IP address format (for example, 192.168.5.4)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify a trail ARN, it must be in the following format.
     * </p>
     * <p>
     * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     * </p>
     * 
     * @return Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the
     *         following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify a trail ARN, it must be in the following format.
     *         </p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     */
    public final String trailName() {
        return trailName;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventSelectors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventSelectors() {
        return eventSelectors != null && !(eventSelectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the settings for your event selectors. You can configure up to five event selectors for a trail. You
     * can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a
     * <code>PutEventSelectors</code> request, but not both. If you apply <code>EventSelectors</code> to a trail, any
     * existing <code>AdvancedEventSelectors</code> are overwritten.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventSelectors} method.
     * </p>
     * 
     * @return Specifies the settings for your event selectors. You can configure up to five event selectors for a
     *         trail. You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a
     *         <code>PutEventSelectors</code> request, but not both. If you apply <code>EventSelectors</code> to a
     *         trail, any existing <code>AdvancedEventSelectors</code> are overwritten.
     */
    public final List<EventSelector> eventSelectors() {
        return eventSelectors;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdvancedEventSelectors property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdvancedEventSelectors() {
        return advancedEventSelectors != null && !(advancedEventSelectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for
     * your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can
     * use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply
     * <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are overwritten. For
     * more information about advanced event selectors, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html"
     * >Logging data events for trails</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdvancedEventSelectors} method.
     * </p>
     * 
     * @return Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions
     *         for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a
     *         trail. You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not
     *         both. If you apply <code>AdvancedEventSelectors</code> to a trail, any existing
     *         <code>EventSelectors</code> are overwritten. For more information about advanced event selectors, see <a
     *         href
     *         ="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html"
     *         >Logging data events for trails</a> in the <i>CloudTrail User Guide</i>.
     */
    public final List<AdvancedEventSelector> advancedEventSelectors() {
        return advancedEventSelectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trailName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventSelectors() ? eventSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdvancedEventSelectors() ? advancedEventSelectors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventSelectorsRequest)) {
            return false;
        }
        PutEventSelectorsRequest other = (PutEventSelectorsRequest) obj;
        return Objects.equals(trailName(), other.trailName()) && hasEventSelectors() == other.hasEventSelectors()
                && Objects.equals(eventSelectors(), other.eventSelectors())
                && hasAdvancedEventSelectors() == other.hasAdvancedEventSelectors()
                && Objects.equals(advancedEventSelectors(), other.advancedEventSelectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutEventSelectorsRequest").add("TrailName", trailName())
                .add("EventSelectors", hasEventSelectors() ? eventSelectors() : null)
                .add("AdvancedEventSelectors", hasAdvancedEventSelectors() ? advancedEventSelectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrailName":
            return Optional.ofNullable(clazz.cast(trailName()));
        case "EventSelectors":
            return Optional.ofNullable(clazz.cast(eventSelectors()));
        case "AdvancedEventSelectors":
            return Optional.ofNullable(clazz.cast(advancedEventSelectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEventSelectorsRequest, T> g) {
        return obj -> g.apply((PutEventSelectorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutEventSelectorsRequest> {
        /**
         * <p>
         * Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following
         * requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
         * </p>
         * </li>
         * <li>
         * <p>
         * Start with a letter or number, and end with a letter or number
         * </p>
         * </li>
         * <li>
         * <p>
         * Be between 3 and 128 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
         * <code>my--namespace</code> are not valid.
         * </p>
         * </li>
         * <li>
         * <p>
         * Not be in IP address format (for example, 192.168.5.4)
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify a trail ARN, it must be in the following format.
         * </p>
         * <p>
         * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * </p>
         * 
         * @param trailName
         *        Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the
         *        following requirements:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start with a letter or number, and end with a letter or number
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Be between 3 and 128 characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
         *        <code>my--namespace</code> are not valid.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Not be in IP address format (for example, 192.168.5.4)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify a trail ARN, it must be in the following format.
         *        </p>
         *        <p>
         *        <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailName(String trailName);

        /**
         * <p>
         * Specifies the settings for your event selectors. You can configure up to five event selectors for a trail.
         * You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a
         * <code>PutEventSelectors</code> request, but not both. If you apply <code>EventSelectors</code> to a trail,
         * any existing <code>AdvancedEventSelectors</code> are overwritten.
         * </p>
         * 
         * @param eventSelectors
         *        Specifies the settings for your event selectors. You can configure up to five event selectors for a
         *        trail. You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a
         *        <code>PutEventSelectors</code> request, but not both. If you apply <code>EventSelectors</code> to a
         *        trail, any existing <code>AdvancedEventSelectors</code> are overwritten.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSelectors(Collection<EventSelector> eventSelectors);

        /**
         * <p>
         * Specifies the settings for your event selectors. You can configure up to five event selectors for a trail.
         * You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a
         * <code>PutEventSelectors</code> request, but not both. If you apply <code>EventSelectors</code> to a trail,
         * any existing <code>AdvancedEventSelectors</code> are overwritten.
         * </p>
         * 
         * @param eventSelectors
         *        Specifies the settings for your event selectors. You can configure up to five event selectors for a
         *        trail. You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a
         *        <code>PutEventSelectors</code> request, but not both. If you apply <code>EventSelectors</code> to a
         *        trail, any existing <code>AdvancedEventSelectors</code> are overwritten.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSelectors(EventSelector... eventSelectors);

        /**
         * <p>
         * Specifies the settings for your event selectors. You can configure up to five event selectors for a trail.
         * You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a
         * <code>PutEventSelectors</code> request, but not both. If you apply <code>EventSelectors</code> to a trail,
         * any existing <code>AdvancedEventSelectors</code> are overwritten.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.EventSelector.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudtrail.model.EventSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.EventSelector.Builder#build()} is called immediately
         * and its result is passed to {@link #eventSelectors(List<EventSelector>)}.
         * 
         * @param eventSelectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.EventSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSelectors(java.util.Collection<EventSelector>)
         */
        Builder eventSelectors(Consumer<EventSelector.Builder>... eventSelectors);

        /**
         * <p>
         * Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for
         * your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You
         * can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply
         * <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are overwritten. For
         * more information about advanced event selectors, see <a
         * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html"
         * >Logging data events for trails</a> in the <i>CloudTrail User Guide</i>.
         * </p>
         * 
         * @param advancedEventSelectors
         *        Specifies the settings for advanced event selectors. You can add advanced event selectors, and
         *        conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and
         *        selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or
         *        <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code> to a
         *        trail, any existing <code>EventSelectors</code> are overwritten. For more information about advanced
         *        event selectors, see <a href=
         *        "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html"
         *        >Logging data events for trails</a> in the <i>CloudTrail User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors);

        /**
         * <p>
         * Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for
         * your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You
         * can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply
         * <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are overwritten. For
         * more information about advanced event selectors, see <a
         * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html"
         * >Logging data events for trails</a> in the <i>CloudTrail User Guide</i>.
         * </p>
         * 
         * @param advancedEventSelectors
         *        Specifies the settings for advanced event selectors. You can add advanced event selectors, and
         *        conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and
         *        selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or
         *        <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code> to a
         *        trail, any existing <code>EventSelectors</code> are overwritten. For more information about advanced
         *        event selectors, see <a href=
         *        "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html"
         *        >Logging data events for trails</a> in the <i>CloudTrail User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedEventSelectors(AdvancedEventSelector... advancedEventSelectors);

        /**
         * <p>
         * Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for
         * your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You
         * can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply
         * <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are overwritten. For
         * more information about advanced event selectors, see <a
         * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html"
         * >Logging data events for trails</a> in the <i>CloudTrail User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedEventSelectors(List<AdvancedEventSelector>)}.
         * 
         * @param advancedEventSelectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedEventSelectors(java.util.Collection<AdvancedEventSelector>)
         */
        Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder>... advancedEventSelectors);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String trailName;

        private List<EventSelector> eventSelectors = DefaultSdkAutoConstructList.getInstance();

        private List<AdvancedEventSelector> advancedEventSelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventSelectorsRequest model) {
            super(model);
            trailName(model.trailName);
            eventSelectors(model.eventSelectors);
            advancedEventSelectors(model.advancedEventSelectors);
        }

        public final String getTrailName() {
            return trailName;
        }

        public final void setTrailName(String trailName) {
            this.trailName = trailName;
        }

        @Override
        public final Builder trailName(String trailName) {
            this.trailName = trailName;
            return this;
        }

        public final List<EventSelector.Builder> getEventSelectors() {
            List<EventSelector.Builder> result = EventSelectorsCopier.copyToBuilder(this.eventSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventSelectors(Collection<EventSelector.BuilderImpl> eventSelectors) {
            this.eventSelectors = EventSelectorsCopier.copyFromBuilder(eventSelectors);
        }

        @Override
        public final Builder eventSelectors(Collection<EventSelector> eventSelectors) {
            this.eventSelectors = EventSelectorsCopier.copy(eventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSelectors(EventSelector... eventSelectors) {
            eventSelectors(Arrays.asList(eventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSelectors(Consumer<EventSelector.Builder>... eventSelectors) {
            eventSelectors(Stream.of(eventSelectors).map(c -> EventSelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AdvancedEventSelector.Builder> getAdvancedEventSelectors() {
            List<AdvancedEventSelector.Builder> result = AdvancedEventSelectorsCopier.copyToBuilder(this.advancedEventSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedEventSelectors(Collection<AdvancedEventSelector.BuilderImpl> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copyFromBuilder(advancedEventSelectors);
        }

        @Override
        public final Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copy(advancedEventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(AdvancedEventSelector... advancedEventSelectors) {
            advancedEventSelectors(Arrays.asList(advancedEventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder>... advancedEventSelectors) {
            advancedEventSelectors(Stream.of(advancedEventSelectors)
                    .map(c -> AdvancedEventSelector.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEventSelectorsRequest build() {
            return new PutEventSelectorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
