/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.InsightSelector;
import software.amazon.awssdk.services.cloudtrail.model.InsightSelectorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutInsightSelectorsResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, PutInsightSelectorsResponse> {
    private static final SdkField<String> TRAIL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrailARN").getter(PutInsightSelectorsResponse.getter(PutInsightSelectorsResponse::trailARN)).setter(PutInsightSelectorsResponse.setter(Builder::trailARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailARN").build()}).build();
    private static final SdkField<List<InsightSelector>> INSIGHT_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsightSelectors").getter(PutInsightSelectorsResponse.getter(PutInsightSelectorsResponse::insightSelectors)).setter(PutInsightSelectorsResponse.setter(Builder::insightSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightSelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_ARN_FIELD, INSIGHT_SELECTORS_FIELD));
    private final String trailARN;
    private final List<InsightSelector> insightSelectors;

    private PutInsightSelectorsResponse(BuilderImpl builder) {
        super(builder);
        this.trailARN = builder.trailARN;
        this.insightSelectors = builder.insightSelectors;
    }

    public final String trailARN() {
        return this.trailARN;
    }

    public final boolean hasInsightSelectors() {
        return this.insightSelectors != null && !(this.insightSelectors instanceof SdkAutoConstructList);
    }

    public final List<InsightSelector> insightSelectors() {
        return this.insightSelectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trailARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsightSelectors() ? this.insightSelectors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInsightSelectorsResponse)) {
            return false;
        }
        PutInsightSelectorsResponse other = (PutInsightSelectorsResponse)((Object)obj);
        return Objects.equals(this.trailARN(), other.trailARN()) && this.hasInsightSelectors() == other.hasInsightSelectors() && Objects.equals(this.insightSelectors(), other.insightSelectors());
    }

    public final String toString() {
        return ToString.builder((String)"PutInsightSelectorsResponse").add("TrailARN", (Object)this.trailARN()).add("InsightSelectors", this.hasInsightSelectors() ? this.insightSelectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrailARN": {
                return Optional.ofNullable(clazz.cast(this.trailARN()));
            }
            case "InsightSelectors": {
                return Optional.ofNullable(clazz.cast(this.insightSelectors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutInsightSelectorsResponse, T> g) {
        return obj -> g.apply((PutInsightSelectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String trailARN;
        private List<InsightSelector> insightSelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutInsightSelectorsResponse model) {
            super(model);
            this.trailARN(model.trailARN);
            this.insightSelectors(model.insightSelectors);
        }

        public final String getTrailARN() {
            return this.trailARN;
        }

        @Override
        public final Builder trailARN(String trailARN) {
            this.trailARN = trailARN;
            return this;
        }

        public final void setTrailARN(String trailARN) {
            this.trailARN = trailARN;
        }

        public final Collection<InsightSelector.Builder> getInsightSelectors() {
            if (this.insightSelectors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.insightSelectors != null ? (Collection)this.insightSelectors.stream().map(InsightSelector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder insightSelectors(Collection<InsightSelector> insightSelectors) {
            this.insightSelectors = InsightSelectorsCopier.copy(insightSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSelectors(InsightSelector ... insightSelectors) {
            this.insightSelectors(Arrays.asList(insightSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSelectors(Consumer<InsightSelector.Builder> ... insightSelectors) {
            this.insightSelectors(Stream.of(insightSelectors).map(c -> (InsightSelector)((InsightSelector.Builder)InsightSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInsightSelectors(Collection<InsightSelector.BuilderImpl> insightSelectors) {
            this.insightSelectors = InsightSelectorsCopier.copyFromBuilder(insightSelectors);
        }

        @Override
        public PutInsightSelectorsResponse build() {
            return new PutInsightSelectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutInsightSelectorsResponse> {
        public Builder trailARN(String var1);

        public Builder insightSelectors(Collection<InsightSelector> var1);

        public Builder insightSelectors(InsightSelector ... var1);

        public Builder insightSelectors(Consumer<InsightSelector.Builder> ... var1);
    }
}

