/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.PublicKey;
import software.amazon.awssdk.services.cloudtrail.model.PublicKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPublicKeysResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, ListPublicKeysResponse> {
    private static final SdkField<List<PublicKey>> PUBLIC_KEY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PublicKeyList").getter(ListPublicKeysResponse.getter(ListPublicKeysResponse::publicKeyList)).setter(ListPublicKeysResponse.setter(Builder::publicKeyList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PublicKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPublicKeysResponse.getter(ListPublicKeysResponse::nextToken)).setter(ListPublicKeysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<PublicKey> publicKeyList;
    private final String nextToken;

    private ListPublicKeysResponse(BuilderImpl builder) {
        super(builder);
        this.publicKeyList = builder.publicKeyList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPublicKeyList() {
        return this.publicKeyList != null && !(this.publicKeyList instanceof SdkAutoConstructList);
    }

    public final List<PublicKey> publicKeyList() {
        return this.publicKeyList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublicKeyList() ? this.publicKeyList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPublicKeysResponse)) {
            return false;
        }
        ListPublicKeysResponse other = (ListPublicKeysResponse)((Object)obj);
        return this.hasPublicKeyList() == other.hasPublicKeyList() && Objects.equals(this.publicKeyList(), other.publicKeyList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPublicKeysResponse").add("PublicKeyList", this.hasPublicKeyList() ? this.publicKeyList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicKeyList": {
                return Optional.ofNullable(clazz.cast(this.publicKeyList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPublicKeysResponse, T> g) {
        return obj -> g.apply((ListPublicKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private List<PublicKey> publicKeyList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPublicKeysResponse model) {
            super(model);
            this.publicKeyList(model.publicKeyList);
            this.nextToken(model.nextToken);
        }

        public final Collection<PublicKey.Builder> getPublicKeyList() {
            if (this.publicKeyList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.publicKeyList != null ? (Collection)this.publicKeyList.stream().map(PublicKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder publicKeyList(Collection<PublicKey> publicKeyList) {
            this.publicKeyList = PublicKeyListCopier.copy(publicKeyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicKeyList(PublicKey ... publicKeyList) {
            this.publicKeyList(Arrays.asList(publicKeyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicKeyList(Consumer<PublicKey.Builder> ... publicKeyList) {
            this.publicKeyList(Stream.of(publicKeyList).map(c -> (PublicKey)((PublicKey.Builder)PublicKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPublicKeyList(Collection<PublicKey.BuilderImpl> publicKeyList) {
            this.publicKeyList = PublicKeyListCopier.copyFromBuilder(publicKeyList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPublicKeysResponse build() {
            return new ListPublicKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPublicKeysResponse> {
        public Builder publicKeyList(Collection<PublicKey> var1);

        public Builder publicKeyList(PublicKey ... var1);

        public Builder publicKeyList(Consumer<PublicKey.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

